/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.telnet.wrapper.impl;

import com.huawei.uflight.telnet.wrapper.TelnetParams;
import com.huawei.uflight.telnet.wrapper.impl.RegExpMatchEx;
import com.huawei.uflight.telnet.wrapper.impl.TelnetException;
import com.huawei.uflight.telnet.wrapper.impl.beans.CommandMode;
import expect4j.Closure;
import expect4j.Expect4j;
import expect4j.ExpectState;
import expect4j.IOPair;
import expect4j.StreamPair;
import expect4j.matches.Match;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.util.List;
import org.apache.commons.net.io.FromNetASCIIInputStream;
import org.apache.commons.net.io.ToNetASCIIOutputStream;
import org.apache.commons.net.telnet.EchoOptionHandler;
import org.apache.commons.net.telnet.SuppressGAOptionHandler;
import org.apache.commons.net.telnet.TelnetClient;
import org.apache.commons.net.telnet.TelnetOptionHandler;
import org.apache.commons.net.telnet.TerminalTypeOptionHandler;
import org.apache.oro.text.regex.MalformedPatternException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TelnetConnect {
    public static final String CHECK_STR = "\r\n";
    public static final String INIT_MODE_STR = "init_mode";
    private static final int DEFAULT_TIMEOUT = 60000;
    private static final Logger log = LoggerFactory.getLogger(TelnetConnect.class);
    private static final int INDEX_FIRST = 0;
    private volatile Expect4j instance = null;
    private volatile CommandMode curMode = null;
    private volatile String curPrompt;
    private volatile long lastSendTime;
    private CommandMode initMode = new CommandMode("init_mode");
    private volatile TelnetParams telnetParams = null;

    void checkConnect(TelnetParams param) {
        if (!param.equals(this.telnetParams)) {
            this.clear();
            this.login(param);
        }
        if (this.fetchPrompt()) {
            return;
        }
        this.login(param);
    }

    String getPrompt() {
        return this.curPrompt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean fetchPrompt() {
        boolean isFetch = false;
        try {
            this.send(CHECK_STR);
            int retIndex = this.expect(this.curMode.getMatchPattern());
            if (retIndex != 0) {
                boolean bl = isFetch;
                return bl;
            }
            this.curPrompt = this.replaceMacro(this.instance.getLastState().getMatch().trim());
            log.info("current connect prompt is " + this.curPrompt);
            isFetch = true;
        }
        catch (Exception e) {
            log.info("fetchPrompt fail,curMode prompt is " + this.curMode.getMatchPattern());
        }
        finally {
            if (!isFetch) {
                this.clear();
            }
        }
        return isFetch;
    }

    private String replaceMacro(String str) {
        String preStr = str.replace("[", "\\[").replace("]", "\\]");
        return preStr;
    }

    public void login(TelnetParams param) {
        int resultCode = 0;
        try {
            this.instance = this.telnetSpawn(param.getHost(), param.getPort(), param.getConnectTimeOut());
            int index = 0;
            if (param.getLoginMode() == 0) {
                index = this.expect(param.getRootModePrompt());
                this.checkLoginMode(index);
            } else if (param.getLoginMode() == 1) {
                index = this.expect(param.getLoginPassWordPrompt());
                this.checkLoginMode(index);
                resultCode = this.loginPassWord(param);
            } else {
                index = this.expect(param.getLoginUserPrompt());
                this.checkLoginMode(index);
                resultCode = this.loginUser(param);
            }
        }
        catch (SocketTimeoutException e) {
            throw new TelnetException(-200, "connect dev timeout , param is" + param);
        }
        catch (MalformedPatternException e) {
            throw new TelnetException(-200, "connect dev fail,telnetParams is fault, param is" + param);
        }
        catch (TelnetException e) {
            throw new TelnetException(e.getErrCode(), "connect dev fail, telnetParams is fault, param is" + param);
        }
        catch (Exception e) {
            throw new TelnetException(-200, "connect dev fail, app excute fail param is" + param);
        }
        if (resultCode != 0) {
            throw new TelnetException(resultCode);
        }
        this.telnetParams = param;
        this.curPrompt = this.instance.getLastState().getMatch().trim();
        this.initMode.setMatchPattern(param.getRootModePrompt());
        this.setCurMode(this.initMode);
    }

    private void checkLoginMode(int index) {
        if (index != 0) {
            throw new TelnetException(-201);
        }
    }

    CommandMode getInitMode() {
        return this.initMode;
    }

    private int loginUser(TelnetParams param) throws MalformedPatternException {
        this.send(param.getUserName() + CHECK_STR);
        int index = this.expect(param.getLoginPassWordPrompt());
        this.checkLoginMode(index);
        int retcode = 0;
        retcode = this.loginPassWord(param);
        if (retcode != 0) {
            retcode = -203;
        }
        return retcode;
    }

    private int loginPassWord(TelnetParams devParam) throws MalformedPatternException {
        this.send(devParam.getPassWord() + CHECK_STR);
        RegExpMatchEx userNameMatch = new RegExpMatchEx(devParam.getLoginUserPrompt(), null);
        RegExpMatchEx passWordMatch = new RegExpMatchEx(devParam.getLoginPassWordPrompt(), null);
        RegExpMatchEx rootModeMatch = new RegExpMatchEx(devParam.getRootModePrompt(), null);
        RegExpMatchEx continueModeMatch = new RegExpMatchEx(devParam.getLoginContinueStr(), new Closure(){

            public void run(ExpectState paramExpectState) throws Exception {
                TelnetConnect.this.send(TelnetConnect.CHECK_STR);
                paramExpectState.exp_continue();
            }
        });
        Match[] matchs = new Match[]{userNameMatch, passWordMatch, continueModeMatch, rootModeMatch};
        int index = this.expect(matchs);
        if (index == matchs.length - 1) {
            return 0;
        }
        return -202;
    }

    void send(String sendStr) {
        try {
            this.instance.send(sendStr);
            this.lastSendTime = System.currentTimeMillis();
        }
        catch (IOException e) {
            log.error("send fail,sendStr = " + sendStr, (Throwable)e);
            throw new TelnetException(-204);
        }
    }

    void checkConectTiemOut() {
        long current = System.currentTimeMillis();
        if (current - this.lastSendTime > 60000L && null != this.instance) {
            this.clear();
        }
    }

    public void clear() {
        if (null != this.instance) {
            this.instance.close();
            this.instance = null;
        }
        this.curMode = null;
        this.curPrompt = null;
        this.telnetParams = null;
    }

    int expect(String pattern) {
        int index;
        try {
            RegExpMatchEx match = new RegExpMatchEx(pattern, null);
            index = this.instance.expect(new Match[]{match});
        }
        catch (MalformedPatternException e) {
            log.error("expect fail,expectStr = " + pattern, (Throwable)e);
            throw new TelnetException(-304);
        }
        catch (Exception e) {
            log.error("expect fail,expectStr = " + pattern, (Throwable)e);
            throw new TelnetException(-304);
        }
        this.debugLog();
        return index;
    }

    int expect(Match[] matchs) {
        int index;
        try {
            index = this.instance.expect(matchs);
        }
        catch (MalformedPatternException e) {
            log.error("expect fail", (Throwable)e);
            throw new TelnetException(-304);
        }
        catch (Exception e) {
            log.error("expect fail", (Throwable)e);
            throw new TelnetException(-304);
        }
        this.debugLog();
        return index;
    }

    int expect(List<Match> matchList) {
        try {
            int n = this.instance.expect(matchList);
            return n;
        }
        catch (MalformedPatternException e) {
            log.error("expect fail", (Throwable)e);
            throw new TelnetException(-304);
        }
        catch (Exception e) {
            log.error("expect fail", (Throwable)e);
            throw new TelnetException(-304);
        }
        finally {
            this.debugLog();
        }
    }

    public ExpectState getLashState() {
        return this.instance.getLastState();
    }

    private void debugLog() {
        if (log.isDebugEnabled()) {
            log.debug(this.instance.getLastState().getBuffer());
        }
    }

    void setCurMode(CommandMode curMode) {
        this.curMode = curMode;
    }

    public CommandMode getCurMode() {
        return this.curMode;
    }

    private Expect4j telnetSpawn(String hostname, int port, int timeOut) throws Exception {
        final TelnetClient client = new TelnetClient();
        TerminalTypeOptionHandler ttopt = new TerminalTypeOptionHandler("VT100", false, false, true, true);
        EchoOptionHandler echoopt = new EchoOptionHandler(true, false, true, false);
        SuppressGAOptionHandler gaopt = new SuppressGAOptionHandler(false, false, false, false);
        client.addOptionHandler((TelnetOptionHandler)ttopt);
        client.addOptionHandler((TelnetOptionHandler)echoopt);
        client.addOptionHandler((TelnetOptionHandler)gaopt);
        client.setReaderThread(false);
        client.setConnectTimeout(timeOut);
        client.connect(hostname, port);
        FromNetASCIIInputStream is = new FromNetASCIIInputStream(client.getInputStream());
        ToNetASCIIOutputStream os = new ToNetASCIIOutputStream(client.getOutputStream());
        StreamPair pair = new StreamPair((InputStream)is, (OutputStream)os){

            public void close() {
                try {
                    if (client != null && client.isConnected()) {
                        client.disconnect();
                    }
                }
                catch (Exception e) {
                    log.error("close  telnet connect  fail" + e);
                }
            }
        };
        Expect4j expect4j = new Expect4j((IOPair)pair);
        return expect4j;
    }
}

