/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.telnet.wrapper.impl;

import com.huawei.uflight.telnet.wrapper.ResponseResult;
import com.huawei.uflight.telnet.wrapper.impl.AbstractCommand;
import com.huawei.uflight.telnet.wrapper.impl.DeviceCommand;
import com.huawei.uflight.telnet.wrapper.impl.TelnetConnect;
import java.util.List;
import java.util.Map;

public class DeviceCommandGroup
extends AbstractCommand {
    private List<DeviceCommand> commands;
    private boolean autoQuit = false;

    public DeviceCommandGroup(List<DeviceCommand> commands) {
        this.commands = commands;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResponseResult execute(TelnetConnect connect, Map<String, String> values) {
        ResponseResult result = new ResponseResult(ResponseResult.OperType.SET);
        try {
            for (DeviceCommand command : this.commands) {
                command.setCancelImp(this.cancel);
                ResponseResult subResult = command.execute(connect, values);
                if (subResult.isSuccess()) continue;
                result.setErrCode(subResult.getErrCode());
                break;
            }
        }
        finally {
            if (this.autoQuit) {
                DeviceCommandGroup.quitMode(connect, 1);
            }
        }
        return result;
    }

    public void setAutoQuit(boolean autoQuit) {
        this.autoQuit = autoQuit;
    }

    public boolean isAutoQuit() {
        return this.autoQuit;
    }

    @Override
    public void init(Map<String, String> values) {
        for (DeviceCommand command : this.commands) {
            command.init(values);
        }
    }
}

