/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.telnet.wrapper.impl;

import com.huawei.uflight.telnet.wrapper.ResponseResult;
import com.huawei.uflight.telnet.wrapper.impl.AbstractCommand;
import com.huawei.uflight.telnet.wrapper.impl.BufferClosure;
import com.huawei.uflight.telnet.wrapper.impl.ControlProcess;
import com.huawei.uflight.telnet.wrapper.impl.RegExpMatchEx;
import com.huawei.uflight.telnet.wrapper.impl.TelnetConnect;
import com.huawei.uflight.telnet.wrapper.impl.TelnetException;
import com.huawei.uflight.telnet.wrapper.impl.TelnetUtil;
import com.huawei.uflight.telnet.wrapper.impl.beans.CommandMode;
import com.huawei.uflight.telnet.wrapper.impl.beans.CommandRequest;
import com.huawei.uflight.telnet.wrapper.impl.beans.CommandResponse;
import com.huawei.uflight.telnet.wrapper.impl.beans.ContinuePattern;
import com.huawei.uflight.telnet.wrapper.impl.expression.TemplateProcessor;
import com.huawei.uflight.telnet.wrapper.impl.parse.OperParse;
import expect4j.Closure;
import expect4j.ExpectState;
import expect4j.matches.Match;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.oro.text.regex.MalformedPatternException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceCommand
extends AbstractCommand {
    static final String MATCHRESULT = "result";
    static final String MATCH_BUFFER = "buffer";
    private static final int LIST_NOFOUND = -1;
    private final CommandRequest request;
    private final CommandMode requireMode;
    private final CommandResponse response;
    private String cmdExecuteStr;
    private List<String> replyStrList;
    private static final Logger log = LoggerFactory.getLogger(DeviceCommand.class);
    private static final Closure SUC_CLOSURE = new BufferClosure(){

        public void run(ExpectState state) throws Exception {
            this.cacheBuffer(state);
            state.addVar(DeviceCommand.MATCHRESULT, (Object)0);
            state.exp_continue();
        }
    };
    private static final Closure FAIL_CLOSURE = new BufferClosure(){

        public void run(ExpectState state) throws Exception {
            this.cacheBuffer(state);
            state.addVar(DeviceCommand.MATCHRESULT, (Object)-300);
            state.exp_continue();
        }
    };

    public DeviceCommand(CommandMode mode, CommandRequest request, CommandResponse response) {
        this.requireMode = mode;
        this.request = request;
        this.response = response;
    }

    private void addSuccessPatterns(List<Match> matchList) throws MalformedPatternException {
        if (null == this.response.getSuccessPatterns()) {
            return;
        }
        matchList.add((Match)new RegExpMatchEx(this.response.getSuccessPatterns(), SUC_CLOSURE));
    }

    private void addFailPatterns(List<Match> matchList) throws MalformedPatternException {
        if (null == this.response.getFailPatterns()) {
            return;
        }
        matchList.add((Match)new RegExpMatchEx(this.response.getFailPatterns(), FAIL_CLOSURE));
    }

    private void addContinuePatterns(final TelnetConnect connect, List<Match> matchList) throws MalformedPatternException {
        if (null == this.response.getContinuePatterns()) {
            return;
        }
        for (int i = 0; i < this.response.getContinuePatterns().size(); ++i) {
            ContinuePattern pattern = this.response.getContinuePatterns().get(i);
            final String reply = this.replyStrList.get(i);
            matchList.add((Match)new RegExpMatchEx(pattern.getPattern(), new BufferClosure(){

                public void run(ExpectState state) throws Exception {
                    if (!DeviceCommand.this.cancel.isCancel()) {
                        this.cacheBuffer(state);
                        connect.send(reply);
                        state.exp_continue_reset_timer();
                    } else {
                        state.addVar(DeviceCommand.MATCHRESULT, (Object)-301);
                        connect.clear();
                    }
                }
            }));
        }
    }

    private void addEndPatterns(TelnetConnect connect, List<Match> matchList) throws MalformedPatternException {
        matchList.add((Match)new RegExpMatchEx(connect.getPrompt(), new BufferClosure(){

            public void run(ExpectState state) throws Exception {
                this.cacheBuffer(state);
            }
        }));
    }

    @Override
    public ResponseResult execute(TelnetConnect connect, Map<String, String> values) {
        if (null != this.requireMode) {
            this.adjustMode(connect, values);
        }
        connect.send(this.cmdExecuteStr + "\r\n");
        ArrayList<Match> matchList = new ArrayList<Match>();
        try {
            this.addSuccessPatterns(matchList);
            this.addFailPatterns(matchList);
            this.addContinuePatterns(connect, matchList);
            this.addEndPatterns(connect, matchList);
        }
        catch (MalformedPatternException e) {
            log.error("addPatterns fail", (Throwable)e);
            throw new TelnetException(-304);
        }
        int index = connect.expect(matchList);
        if (index == -2) {
            connect.clear();
            throw new TelnetException(-302);
        }
        ExpectState state = connect.getLashState();
        return this.parse(state);
    }

    private ResponseResult parse(ExpectState state) {
        OperParse parse = this.response.getParse();
        ResponseResult result = new ResponseResult(parse.getOperType());
        result.setErrCode(DeviceCommand.getResult(state));
        if (!result.isSuccess()) {
            return result;
        }
        StringBuilder matchBuffer = (StringBuilder)state.getVar(MATCH_BUFFER);
        if (null != matchBuffer) {
            List<String> strList = ControlProcess.process(matchBuffer);
            result.setResult(parse.parseStr(strList));
        }
        return result;
    }

    private void adjustMode(TelnetConnect connect, Map<String, String> values) {
        CommandMode curMode = connect.getCurMode();
        if (this.requireMode.equals(curMode) && !this.requireMode.isWithParam()) {
            return;
        }
        if (this.requireMode.equals(curMode) && this.requireMode.isWithParam()) {
            this.enterMode(this.requireMode, connect, values);
            connect.setCurMode(this.requireMode);
            connect.fetchPrompt();
            return;
        }
        int index = this.requireMode.getModeParents().indexOf(curMode);
        int toCutIndex = -1;
        int quitCount = 0;
        if (index != -1) {
            toCutIndex = index;
        } else {
            List<CommandMode> curmodeParentList = curMode.getModeParents();
            for (int i = 0; i < curmodeParentList.size(); ++i) {
                quitCount = ++i;
                if (this.requireMode.equals(curmodeParentList.get(i)) || (toCutIndex = this.requireMode.getModeParents().indexOf(curmodeParentList.get(i))) != -1) break;
            }
            DeviceCommand.quitMode(connect, quitCount);
        }
        if (toCutIndex == -1 && quitCount == 0) {
            throw new TelnetException(-303, "fail to enter require mode ,request is" + this.request);
        }
        if (toCutIndex >= 0) {
            List<CommandMode> modeList = this.getEnterModeList(toCutIndex, this.requireMode);
            this.enterMode(modeList, connect, values);
        }
        connect.setCurMode(this.requireMode);
        connect.fetchPrompt();
    }

    private List<CommandMode> getEnterModeList(int toCutIndex, CommandMode requireMode) {
        ArrayList<CommandMode> modeList = new ArrayList<CommandMode>();
        for (int i = toCutIndex - 1; i >= 0; --i) {
            modeList.add(requireMode.getModeParents().get(i));
        }
        modeList.add(requireMode);
        return modeList;
    }

    private void enterMode(List<CommandMode> modeList, TelnetConnect connect, Map<String, String> values) {
        for (CommandMode sendMode : modeList) {
            this.enterMode(sendMode, connect, values);
        }
    }

    private void enterMode(CommandMode sendMode, TelnetConnect connect, Map<String, String> values) {
        String modeRequest = sendMode.getRequest();
        if (sendMode.isWithParam()) {
            modeRequest = TemplateProcessor.process(modeRequest, values);
        }
        connect.send(modeRequest + "\r\n");
        int ret = connect.expect(sendMode.getMatchPattern());
        if (ret != 0) {
            throw new TelnetException(ret, "fail to enter require mode ,modeRequest = " + modeRequest);
        }
    }

    @Override
    public void init(Map<String, String> values) {
        String message = this.request.getMessage();
        this.cmdExecuteStr = TemplateProcessor.process(message, values);
        List<ContinuePattern> cPatterns = this.response.getContinuePatterns();
        if (cPatterns != null) {
            this.replyStrList = new ArrayList<String>();
            for (ContinuePattern cp : cPatterns) {
                String replyStr = cp.getReplyChar();
                this.replyStrList.add(TelnetUtil.replaceStrMacro(replyStr, values));
            }
        }
    }

    private static int getResult(ExpectState state) {
        Integer result = (Integer)state.getVar(MATCHRESULT);
        if (null == result || 0 == result) {
            return 0;
        }
        return result;
    }
}

