/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.telnet.wrapper.impl;

import com.huawei.uflight.telnet.wrapper.IDataSourceReg;
import com.huawei.uflight.telnet.wrapper.ITelnetDataSource;
import com.huawei.uflight.telnet.wrapper.ITelnetWrapper;
import com.huawei.uflight.telnet.wrapper.impl.TelnetWrapperImpl;
import java.util.concurrent.ConcurrentHashMap;

public class DataSourceMgr
implements IDataSourceReg {
    private static DataSourceMgr instance = new DataSourceMgr();
    private ConcurrentHashMap<String, ITelnetDataSource> sourceCache = new ConcurrentHashMap();
    private ConcurrentHashMap<String, ITelnetWrapper> wapperCache = new ConcurrentHashMap();

    private DataSourceMgr() {
    }

    public static DataSourceMgr getInstance() {
        return instance;
    }

    public ITelnetDataSource getSource(String wrapperName) {
        if (null == wrapperName) {
            return null;
        }
        return this.sourceCache.get(wrapperName);
    }

    public ITelnetWrapper getWrapper(String wrapperName) {
        if (null == wrapperName) {
            return null;
        }
        if (!this.wapperCache.contains(wrapperName)) {
            TelnetWrapperImpl wrapper = new TelnetWrapperImpl();
            ITelnetDataSource dataSource = this.sourceCache.get(wrapperName);
            wrapper.setTelnetSource(dataSource);
            if (dataSource != null) {
                this.wapperCache.putIfAbsent(wrapperName, wrapper);
            }
        }
        return this.wapperCache.get(wrapperName);
    }

    @Override
    public void add(String wrapperName, ITelnetDataSource dataSource) {
        this.sourceCache.putIfAbsent(wrapperName, dataSource);
    }

    @Override
    public void remove(String wrapperName) {
        this.sourceCache.remove(wrapperName);
        this.wapperCache.remove(wrapperName);
    }
}

