/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.telnet.wrapper.impl;

import com.huawei.uflight.telnet.wrapper.impl.DeviceCommand;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControlProcess {
    private static final String CURSOR_BACK = "\u001b\\[(\\d+)D";
    private static Pattern PATTERN = Pattern.compile("\u001b\\[(\\d+)D");
    private static int MATCH_NUM_POS = 1;
    private static final Logger log = LoggerFactory.getLogger(DeviceCommand.class);

    public static List<String> process(StringBuilder buffer) {
        LinkedList<String> strList = new LinkedList<String>();
        BufferedReader reader = new BufferedReader(new StringReader(buffer.toString()));
        try {
            String line = reader.readLine();
            do {
                if (line == null) continue;
                strList.add(ControlProcess.processBackward(line));
            } while ((line = reader.readLine()) != null);
        }
        catch (IOException e) {
            log.error("ControlProcess process is fail", (Throwable)e);
        }
        return strList;
    }

    private static String processBackward(String line) {
        StringBuilder builder = new StringBuilder(line);
        return ControlProcess.processBackward(builder);
    }

    private static String processBackward(StringBuilder line) {
        Matcher match = PATTERN.matcher(line);
        if (match.find()) {
            int backNum = Integer.parseInt(match.group(MATCH_NUM_POS));
            int matchStart = match.start();
            int matchEnd = match.end();
            int delStart = matchStart - backNum;
            if (delStart < 0) {
                delStart = 0;
            }
            line.delete(delStart, matchEnd);
            ControlProcess.processBackward(line);
        }
        return line.toString().trim();
    }
}

