/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.telnet.wrapper.impl;

import com.huawei.uflight.telnet.wrapper.ITelnetDataSource;
import com.huawei.uflight.telnet.wrapper.impl.TelnetConnect;
import com.huawei.uflight.telnet.wrapper.impl.TelnetException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class ConnectionPoolMgr {
    private ITelnetDataSource dataSource;
    private ConcurrentHashMap<String, DevConnectPool> poolMap = new ConcurrentHashMap();

    public void setTelnetSource(ITelnetDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public TelnetConnect get(String devFdn) {
        if (!this.poolMap.containsKey(devFdn)) {
            this.poolMap.putIfAbsent(devFdn, new DevConnectPool(this.dataSource.getTelnetParams(devFdn).getMaxConectNum()));
        }
        return this.poolMap.get(devFdn).getItem();
    }

    public void put(String devFdn, TelnetConnect instance) {
        DevConnectPool pool = this.poolMap.get(devFdn);
        if (null != pool) {
            pool.putItem(instance);
        }
    }

    public void checkTimeOut() {
        for (DevConnectPool pool : this.poolMap.values()) {
            if (pool.getMaxCount() != pool.getIdleNum()) continue;
            TelnetConnect[] connects = new TelnetConnect[pool.getMaxCount()];
            for (int i = 0; i < pool.getMaxCount(); ++i) {
                connects[i] = pool.getItem();
                connects[i].checkConectTiemOut();
            }
            for (TelnetConnect connect : connects) {
                pool.putItem(connect);
            }
        }
    }

    private class DevConnectPool {
        private final int maxAvaiable;
        private volatile AtomicInteger idelNum;
        private final BlockingQueue<TelnetConnect> connectQueue;

        DevConnectPool(int max) {
            this.maxAvaiable = max;
            this.connectQueue = new ArrayBlockingQueue<TelnetConnect>(max);
            for (int i = 0; i < max; ++i) {
                this.connectQueue.add(new TelnetConnect());
            }
            this.idelNum = new AtomicInteger(this.maxAvaiable);
        }

        TelnetConnect getItem() {
            try {
                TelnetConnect telnetConnect = this.connectQueue.take();
                return telnetConnect;
            }
            catch (InterruptedException e) {
                throw new TelnetException(-400, "get TelnetConnect fail");
            }
            finally {
                this.idelNum.decrementAndGet();
            }
        }

        void putItem(TelnetConnect x) {
            this.connectQueue.add(x);
            this.idelNum.incrementAndGet();
        }

        int getMaxCount() {
            return this.maxAvaiable;
        }

        int getIdleNum() {
            return this.idelNum.get();
        }
    }
}

