/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.telnet;

import com.huawei.uflight.protocol.AbstractNetProtocol;
import com.huawei.uflight.protocol.IProtocolParam;
import com.huawei.uflight.telnet.TelnetParam;
import com.huawei.uflight.telnet.exception.CommException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.SocketException;
import java.util.HashMap;
import org.apache.commons.net.telnet.EchoOptionHandler;
import org.apache.commons.net.telnet.InvalidTelnetOptionException;
import org.apache.commons.net.telnet.TelnetClient;
import org.apache.commons.net.telnet.TelnetOptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TelnetProtocol
extends AbstractNetProtocol {
    private TelnetClient tc;
    private InputStream instr;
    private OutputStreamWriter outstr;
    private TelnetParam telnetParam;
    private static final Logger log = LoggerFactory.getLogger(TelnetProtocol.class);

    public TelnetProtocol(IProtocolParam protocolParam) throws CommException {
        if (protocolParam instanceof TelnetParam) {
            this.telnetParam = (TelnetParam)protocolParam;
            if (this.telnetParam.verify()) {
                return;
            }
        }
        log.error("The protocol parameter(s) is incorrect.");
        throw new CommException(10, "The protocol parameter(s) is incorrect.");
    }

    @Override
    public void connect() {
        try {
            this.tc = new TelnetClient();
            EchoOptionHandler eoh = new EchoOptionHandler(true, true, true, true);
            this.tc.addOptionHandler((TelnetOptionHandler)eoh);
            this.tc.connect(this.telnetParam.getHostname(), this.telnetParam.getPort());
            if (this.netMonitor != null) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("connect", this.telnetParam);
                this.netMonitor.connect(map);
            }
        }
        catch (InvalidTelnetOptionException e) {
            log.error("Failed to connect with the remote host.");
        }
        catch (SocketException e) {
            log.error(e.getMessage());
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
        this.instr = this.tc.getInputStream();
        this.outstr = new OutputStreamWriter(this.tc.getOutputStream());
    }

    @Override
    public void disconnect() throws CommException {
        try {
            if (this.instr != null) {
                this.instr.close();
            }
            if (this.outstr != null) {
                this.outstr.close();
            }
            if (this.tc != null) {
                this.tc.disconnect();
                this.tc = null;
            }
            if (this.netMonitor != null) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("disconnect", "disconnect");
                this.netMonitor.disconnect(map);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }

    @Override
    public String receive() {
        try {
            byte[] byteBuff;
            this.checkNull(this.instr);
            StringBuffer strBuff = new StringBuffer();
            int len = this.instr.available();
            if (0 != len && (len = this.instr.read(byteBuff = new byte[len])) > 0) {
                strBuff.append(new String(byteBuff, 0, len));
            }
            if (this.netMonitor != null) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("msg", strBuff.toString());
                this.netMonitor.receive(map);
            }
            return strBuff.toString();
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return String.valueOf("");
        }
    }

    @Override
    public void send(Object ... cmds) {
        try {
            this.checkNull(this.outstr);
            for (int i = 0; i < cmds.length; ++i) {
                String cmd = (String)cmds[i];
                this.outstr.write(cmd);
                this.outstr.flush();
                if (this.netMonitor == null) continue;
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("cmd", cmd);
                this.netMonitor.send(map);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }
}

