/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.telnet;

import com.huawei.uflight.telnet.Activator;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import org.osgi.framework.Bundle;

public class ResourceProtocol {
    private static final String FILE_PROTOCOL = "file:";
    private static final String BUNDLE_PROTOCOL = "bundle:";

    private static URL getURL(String protocol, String path) {
        URL findURL = null;
        if (protocol.equals(FILE_PROTOCOL)) {
            try {
                findURL = new File(path).toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("not find resource url by" + protocol + path);
            }
        } else {
            String[] bundlePath = path.split(";");
            if (bundlePath.length < 2) {
                throw new IllegalArgumentException("bundlePath is error," + path);
            }
            Bundle bundle = Activator.getBundle(bundlePath[0].trim());
            findURL = bundle.getResource(bundlePath[1].trim());
        }
        if (null == findURL) {
            throw new IllegalArgumentException("not find resource url by" + protocol + path);
        }
        return findURL;
    }

    public static URL getURL(String resourceDesc) {
        String protocol;
        if (null == resourceDesc) {
            return null;
        }
        String desc = resourceDesc.trim();
        String lowerResourceDesc = desc.toLowerCase(Locale.ENGLISH);
        if (lowerResourceDesc.startsWith(FILE_PROTOCOL)) {
            protocol = FILE_PROTOCOL;
        } else if (lowerResourceDesc.startsWith(BUNDLE_PROTOCOL)) {
            protocol = BUNDLE_PROTOCOL;
        } else {
            throw new IllegalArgumentException("resourceDesc has some error, we only support file protocol and bundle protocol resourceDesc is " + resourceDesc);
        }
        String path = desc.substring(protocol.length()).trim();
        return ResourceProtocol.getURL(protocol, path);
    }
}

