/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.tl1.tl1operation;

import com.huawei.uflight.tl1.tl1operation.Fault;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import org.exolab.castor.util.IteratorEnumeration;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;

public class TL1Operation
implements Serializable,
Cloneable {
    private String _name;
    private String _cmdCode;
    private String _mod1;
    private String _mod2;
    private InMsg _inMsg;
    private ArrayList _outMsgList;
    private String cmdDetail = "";
    private ArrayList cmdFaultList = new ArrayList();
    private String strTL1Info = null;
    private Date date = null;
    private long cTag = -1L;
    private List<String> commentList = new ArrayList<String>();

    public TL1Operation() {
        this._outMsgList = new ArrayList();
    }

    public long getCTag() {
        return this.cTag;
    }

    public void setCTag(long tag) {
        this.cTag = tag;
    }

    public String getStrTL1Info() {
        return this.strTL1Info;
    }

    public void setStrTL1Info(String strTL1Info) {
        this.strTL1Info = strTL1Info;
    }

    public String getCmdCode() {
        return this._cmdCode;
    }

    public InMsg getInMsg() {
        return this._inMsg;
    }

    public String getMod1() {
        return this._mod1;
    }

    public String getMod2() {
        return this._mod2;
    }

    public String getName() {
        return this._name;
    }

    public void addOutMsg(OutMsg vOutMsg) throws IndexOutOfBoundsException {
        this._outMsgList.add(vOutMsg);
    }

    public void addOutMsg(OutMsg[] vOutMsgs) throws IndexOutOfBoundsException {
        for (int i = 0; i < vOutMsgs.length; ++i) {
            this._outMsgList.add(vOutMsgs[i]);
        }
    }

    public void addOutMsg(int index, OutMsg vOutMsg) throws IndexOutOfBoundsException {
        this._outMsgList.add(index, vOutMsg);
    }

    public void clearOutMsg() {
        this._outMsgList.clear();
    }

    public Enumeration enumerateOutMsg() {
        return new IteratorEnumeration(this._outMsgList.iterator());
    }

    public OutMsg getOutMsg(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._outMsgList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (OutMsg)this._outMsgList.get(index);
    }

    public OutMsg[] getOutMsg() {
        int size = this._outMsgList.size();
        OutMsg[] mArray = new OutMsg[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (OutMsg)this._outMsgList.get(index);
        }
        return mArray;
    }

    public int getOutMsgCount() {
        return this._outMsgList.size();
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void setCmdCode(String cmdCode) {
        this._cmdCode = cmdCode;
    }

    public void setInMsg(InMsg inMsg) {
        this._inMsg = inMsg;
    }

    public void setMod1(String mod1) {
        this._mod1 = mod1;
    }

    public void setMod2(String mod2) {
        this._mod2 = mod2;
    }

    public void setName(String name) {
        this._name = name;
    }

    public boolean removeOutMsg(OutMsg vOutMsg) {
        boolean removed = this._outMsgList.remove(vOutMsg);
        return removed;
    }

    public void setOutMsg(int index, OutMsg vOutMsg) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._outMsgList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._outMsgList.set(index, vOutMsg);
    }

    public void setOutMsg(OutMsg[] OutMsgArray) {
        this._outMsgList.clear();
        for (int i = 0; i < OutMsgArray.length; ++i) {
            this._outMsgList.add(OutMsgArray[i]);
        }
    }

    public static TL1Operation unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (TL1Operation)Unmarshaller.unmarshal(TL1Operation.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }

    public Object clone() {
        TL1Operation cloneTL1Oper = null;
        try {
            int i;
            cloneTL1Oper = (TL1Operation)super.clone();
            InMsg inMsg = this.getInMsg();
            if (null != inMsg) {
                cloneTL1Oper.setInMsg((InMsg)inMsg.clone());
            }
            cloneTL1Oper._outMsgList = new ArrayList();
            int size = this.getOutMsgCount();
            for (i = 0; i < size; ++i) {
                cloneTL1Oper.addOutMsg((OutMsg)this.getOutMsg(i).clone());
            }
            cloneTL1Oper.cmdFaultList = new ArrayList();
            size = this.getCmdFaultList().size();
            for (i = 0; i < size; ++i) {
                cloneTL1Oper.addCmdFault((Fault)((Fault)this.getCmdFaultList().get(i)).clone());
            }
        }
        catch (Exception e) {
            throw new InternalError();
        }
        return cloneTL1Oper;
    }

    public void setCmdDetail(String cmdDetail) {
        this.cmdDetail = cmdDetail;
    }

    public String getCmdDetail() {
        return this.cmdDetail;
    }

    public void setCmdFaultList(ArrayList cmdFaultList) {
        this.cmdFaultList = cmdFaultList;
    }

    public ArrayList getCmdFaultList() {
        return this.cmdFaultList;
    }

    public void addCmdFault(Fault cmdFault) {
        this.cmdFaultList.add(cmdFault);
    }

    public void clearCmdFaultInfo() {
        this.cmdDetail = "";
        this.cmdFaultList.clear();
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public List<String> getCommentList() {
        return this.commentList;
    }

    public String getCmdKey() {
        StringBuffer buf = new StringBuffer();
        buf.append(this._cmdCode);
        if (null != this._mod1 && !"".equals(this._mod1.trim())) {
            buf.append('-');
            buf.append(this._mod1);
        }
        if (null != this._mod2 && !"".equals(this._mod2.trim())) {
            buf.append('-');
            buf.append(this._mod2);
        }
        return buf.toString();
    }

    public void setCommentList(List<String> commentList) {
        this.commentList = commentList;
    }
}

