/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.tl1.tl1adapter;

import com.huawei.uflight.tl1.tl1adapter.TEPair;
import com.huawei.uflight.tl1.tl1adapter.TEPosPair;
import java.util.ArrayList;
import java.util.List;

public final class TETL1Util {
    private static final String QUOTE_STR = "\"";
    private static final String COMMENT_START_STR = "/*";
    private static final String COMMENT_END_STR = "*/";

    private TETL1Util() {
    }

    public static boolean token(String strtl1, String sep, List<String> result) {
        if (strtl1 == null || sep == null) {
            return false;
        }
        result.clear();
        TEPair tmpair = new TEPair();
        ArrayList<Integer> innerStringVec = new ArrayList<Integer>();
        ArrayList<Integer> quoteStringVec = new ArrayList<Integer>();
        tmpair.first = QUOTE_STR;
        tmpair.second = QUOTE_STR;
        TETL1Util.splitStringNotInQuote(strtl1, tmpair, sep, innerStringVec);
        tmpair.first = COMMENT_START_STR;
        tmpair.second = COMMENT_END_STR;
        TETL1Util.splitStringNotInQuote(strtl1, tmpair, sep, quoteStringVec);
        int len = sep.length();
        int ptoken = 0;
        int pstart = 0;
        int pend = 0;
        pend = strtl1.indexOf(sep, pstart);
        while (pend != -1) {
            String tmp = strtl1.substring(pstart, pend);
            if (TETL1Util.findStr(quoteStringVec, innerStringVec, pend)) {
                result.add(tmp);
                ptoken = pstart = pend + len;
                pend = strtl1.indexOf(sep, pstart);
                continue;
            }
            pend = strtl1.indexOf(sep, pend + len);
        }
        result.add(strtl1.substring(ptoken));
        return true;
    }

    private static boolean findStr(List<Integer> quoteStringVec, List<Integer> innerStringVec, int pos) {
        return quoteStringVec.contains(pos) && innerStringVec.contains(pos);
    }

    public static String excludeTransfer(String str) {
        String strTrans = "\\\"";
        if (str.startsWith("\\\"") && str.endsWith("\\\"")) {
            str = str.substring("\\\"".length(), str.length() - "\\\"".length());
        }
        String strSrc = "\\\"";
        String strDes = QUOTE_STR;
        str = str.replaceAll("\\\"", QUOTE_STR);
        return str;
    }

    private static void splitStringNotInQuote(String pStr, TEPair quotePair, String pSplitStr, List<Integer> result) {
        ArrayList<TEPosPair> vecQuotes = new ArrayList<TEPosPair>();
        int pFirstQuote = 0;
        int pNextQuote = 0;
        while (-1 != (pFirstQuote = pStr.indexOf(quotePair.first, pFirstQuote)) && -1 != (pNextQuote = pStr.indexOf(quotePair.second, pFirstQuote + quotePair.first.length()))) {
            TEPosPair pospair = new TEPosPair();
            pospair.first = pFirstQuote;
            pospair.second = pNextQuote;
            vecQuotes.add(pospair);
            pFirstQuote = pNextQuote + quotePair.second.length();
        }
        pFirstQuote = 0;
        List<Integer> allSplitStrVec = TETL1Util.getAllSplitIndex(pStr, pSplitStr);
        for (int i = 0; i < allSplitStrVec.size(); ++i) {
            int pos = allSplitStrVec.get(i);
            boolean bEqualInQuote = false;
            for (int j = 0; j < vecQuotes.size(); ++j) {
                TEPosPair pospair = (TEPosPair)vecQuotes.get(j);
                if (pos <= pospair.first || pos >= pospair.second) continue;
                bEqualInQuote = true;
                break;
            }
            if (bEqualInQuote) continue;
            result.add(pos);
        }
    }

    public static void findSplitIndexLst(String pStr, String pSplitStr, List<Integer> result) {
        result.clear();
        List<TEPosPair> vecQuotes = TETL1Util.getALLSpacialPair(pStr);
        List<Integer> allSplitStrVec = TETL1Util.getAllSplitIndex(pStr, pSplitStr);
        for (int i = 0; i < allSplitStrVec.size(); ++i) {
            int pos = allSplitStrVec.get(i);
            boolean bEqualInQuote = false;
            for (int j = 0; j < vecQuotes.size(); ++j) {
                TEPosPair pospair = vecQuotes.get(j);
                if (pos <= pospair.first || pos >= pospair.second) continue;
                bEqualInQuote = true;
                break;
            }
            if (bEqualInQuote) continue;
            result.add(pos);
        }
    }

    private static List<TEPosPair> getALLSpacialPair(String pStr) {
        ArrayList<TEPosPair> vecQuotes = new ArrayList<TEPosPair>();
        int quoteIndex = 0;
        int commentIndex = 0;
        int endIndex = 0;
        while (true) {
            TEPosPair pospair;
            quoteIndex = pStr.indexOf(QUOTE_STR, quoteIndex);
            commentIndex = pStr.indexOf(COMMENT_START_STR, commentIndex);
            if (quoteIndex == -1 && commentIndex == -1) break;
            if (quoteIndex > commentIndex) {
                endIndex = pStr.indexOf(QUOTE_STR, quoteIndex + QUOTE_STR.length());
                if (-1 == endIndex) break;
                pospair = new TEPosPair();
                pospair.first = quoteIndex;
                pospair.second = endIndex + QUOTE_STR.length();
                vecQuotes.add(pospair);
                commentIndex = quoteIndex = endIndex + QUOTE_STR.length();
                continue;
            }
            endIndex = pStr.indexOf(COMMENT_END_STR, commentIndex + COMMENT_START_STR.length());
            if (-1 == endIndex) break;
            pospair = new TEPosPair();
            pospair.first = commentIndex;
            pospair.second = endIndex + COMMENT_END_STR.length();
            vecQuotes.add(pospair);
            quoteIndex = commentIndex += COMMENT_END_STR.length();
        }
        return vecQuotes;
    }

    private static List<Integer> getAllSplitIndex(String pStr, String pSplitStr) {
        ArrayList<Integer> allSplitStrVec = new ArrayList<Integer>();
        int curIndex = 0;
        while ((curIndex = pStr.indexOf(pSplitStr, curIndex)) != -1) {
            allSplitStrVec.add(curIndex);
            curIndex += pSplitStr.length();
        }
        return allSplitStrVec;
    }
}

