/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.tl1.tl1adapter;

import com.huawei.uflight.tl1.tl1adapter.TETL1Data;
import com.huawei.uflight.tl1.tl1adapter.TETL1ParseImplBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TETL1RspParserImpl
extends TETL1ParseImplBase {
    private static final int MAX_CTAG_LENGTH = 6;
    private static final String[] COMPLT_STR = new String[]{"COMPLD", "DENY", "PRTL", "DELAY", "RTRV"};
    private static final int RSP_SYMBOL_LEN = 5;
    private static Logger logger = LoggerFactory.getLogger(TETL1RspParserImpl.class);

    @Override
    public boolean parse(byte[] tl1bytes, TETL1Data tl1Data) {
        if (!this.parseTerminator(tl1bytes, tl1Data)) {
            return false;
        }
        if (!this.parseHead(tl1bytes, tl1Data)) {
            return false;
        }
        String strTL1 = new String(tl1bytes);
        if (!(strTL1 = strTL1.substring(tl1Data.getHeaderEndPos() + 1, strTL1.length() - 3)).startsWith("\r\nM  ")) {
            logger.error("The response msg is invalid , msg=" + strTL1);
            return false;
        }
        boolean bHasTextBlock = true;
        int pEnd = strTL1.indexOf(13, 5);
        String rspIdentifStr = null;
        if (pEnd == -1) {
            bHasTextBlock = false;
            pEnd = strTL1.length();
        }
        if (!this.parseRspIdentif(rspIdentifStr = strTL1.substring(0, pEnd), tl1Data)) {
            return false;
        }
        if (bHasTextBlock) {
            strTL1 = strTL1.substring(pEnd);
            return this.parseTextBlock(strTL1.getBytes(), tl1Data);
        }
        return true;
    }

    private boolean parseRspIdentif(String rspIdentifStr, TETL1Data tl1Data) {
        String tmpStr = rspIdentifStr.substring(5);
        String[] rspIdentArr = tmpStr.split(" ");
        if (rspIdentArr.length != 2) {
            logger.error("the response identification is invalidate, response identification is:" + rspIdentifStr);
            return false;
        }
        if (!this.parseCTag(rspIdentArr[0], tl1Data)) {
            return false;
        }
        return this.parseCompleteCode(rspIdentArr[1], tl1Data);
    }

    private boolean parseCTag(String cTag, TETL1Data tl1Data) {
        if (cTag.length() > 6) {
            LoggerFactory.getLogger(this.getClass()).error("The length of ctag in Response Identificationis too long,cTag=" + cTag);
            return false;
        }
        try {
            tl1Data.setCtag(Long.parseLong(cTag));
        }
        catch (NumberFormatException e) {
            LoggerFactory.getLogger(this.getClass()).error("The ctag is invalid in Response Identification\n");
            return false;
        }
        return true;
    }

    private boolean parseCompleteCode(String completeCode, TETL1Data tl1Data) {
        if (completeCode.equals(COMPLT_STR[0])) {
            tl1Data.setCmplCode(0);
        } else if (completeCode.equals(COMPLT_STR[1])) {
            tl1Data.setCmplCode(1);
        } else if (completeCode.equals(COMPLT_STR[2])) {
            tl1Data.setCmplCode(2);
        } else if (completeCode.equals(COMPLT_STR[3])) {
            tl1Data.setCmplCode(3);
        } else if (completeCode.equals(COMPLT_STR[4])) {
            tl1Data.setCmplCode(4);
        } else {
            logger.error("The complete code is invalid in Response Identification, complete code = " + completeCode);
            return false;
        }
        return true;
    }

    @Override
    public String toTL1String(TETL1Data tl1Data) {
        throw new UnsupportedOperationException("not implement");
    }
}

