/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.tl1.tl1adapter;

import com.huawei.uflight.necomm.TECommInfo;
import com.huawei.uflight.necomm.TECommunicationMgr;
import com.huawei.uflight.necomm.TEMessageBlock;
import com.huawei.uflight.tl1.TETL1NECommMgr;
import com.huawei.uflight.tl1.internal.TEAdapterManager;
import com.huawei.uflight.tl1.internal.TEMessage;
import com.huawei.uflight.tl1.internal.TEMessageAdapter;
import com.huawei.uflight.tl1.internal.TEMessageInfo;
import com.huawei.uflight.tl1.internal.TEMessageUnit;
import com.huawei.uflight.tl1.internal.TEProtocolAdapter;
import com.huawei.uflight.tl1.internal.TETL1CommuMgr;
import com.huawei.uflight.tl1.internal.TETL1TaskManager;
import com.huawei.uflight.tl1.tl1adapter.TETL1Data;
import com.huawei.uflight.tl1.tl1adapter.TETL1FrameHead;
import com.huawei.uflight.tl1.tl1adapter.TETL1InputMessage;
import com.huawei.uflight.tl1.tl1adapter.TETL1Message;
import com.huawei.uflight.tl1.tl1adapter.TETL1NEInfo;
import com.huawei.uflight.tl1.tl1adapter.TETL1NeMsg;
import com.huawei.uflight.tl1.tl1adapter.TETL1ParamBlock;
import com.huawei.uflight.tl1.tl1adapter.TETL1ParamLine;
import com.huawei.uflight.tl1.tl1adapter.TETL1Parser;
import com.huawei.uflight.tl1.tl1adapter.TETL1ResponseMsg;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TETL1ProtocolAdapter
extends TEProtocolAdapter {
    private static Logger logger = LoggerFactory.getLogger(TETL1ProtocolAdapter.class);
    private static TETL1ProtocolAdapter instance = new TETL1ProtocolAdapter();
    private Map<String, TEMessageAdapter> rptAdapterMap = new HashMap<String, TEMessageAdapter>();

    public static TETL1ProtocolAdapter getInstance() {
        return instance;
    }

    private TETL1ProtocolAdapter() {
        super(10);
    }

    public int checkMessageValid(byte[] bufVec, int offset, int size, TECommInfo commInfo) {
        if (size < 4) {
            logger.info("MESSAGE_LENGTH_LESS: packetHeadLength= 4,offset: " + offset + ",size: " + size);
            return -2;
        }
        TETL1FrameHead head = new TETL1FrameHead();
        int ret = head.readFromStream(bufVec);
        if (0 != ret) {
            return ret;
        }
        int oLen = offset + size;
        int dLen = head.getLength();
        if (oLen < dLen) {
            return -2;
        }
        this.handleMessage(bufVec, dLen, commInfo);
        return dLen;
    }

    private boolean isFilter(String logs) {
        return logs.contains("ENT-NTP-AUTHPARA") || logs.contains("ED-NTP-AUTHPARA");
    }

    private void handleMessage(byte[] bufVec, int pakegeLen, TECommInfo commInfo) {
        int tl1PayloadLen = pakegeLen - 4;
        if (tl1PayloadLen <= 0) {
            return;
        }
        byte[] pData = new byte[tl1PayloadLen + 1];
        pData[tl1PayloadLen] = 0;
        System.arraycopy(bufVec, 4, pData, 0, tl1PayloadLen);
        String pDataStr = new String(pData);
        if (!this.isFilter(pDataStr)) {
            logger.info("revc from Ne <<<..." + pDataStr);
        }
        int curIndex = 0;
        int endCharIndex = -1;
        char derminatorChar = (char)pData[tl1PayloadLen - 1];
        do {
            if (-1 == (endCharIndex = derminatorChar != '<' ? this.getFirstPkgEndIndex(pDataStr, curIndex) : pDataStr.indexOf("\r\n<", curIndex))) {
                logger.error("Invalid Msg,Can't find the end of TL1 msg\n");
                return;
            }
            byte[] tmpPData = new byte[endCharIndex - curIndex + 3];
            System.arraycopy(pData, curIndex, tmpPData, 0, endCharIndex - curIndex + 3);
            this.handleOnePakage(tmpPData, commInfo);
        } while ((char)pData[curIndex = endCharIndex + 3] != '\u0000');
    }

    private void handleOnePakage(byte[] pkgData, TECommInfo commInfo) {
        TETL1Data pTl1data = new TETL1Data();
        boolean parseSucc = TETL1Parser.getInstance().parse(pkgData, pTl1data);
        if (!parseSucc) {
            logger.info("Invalid Msg,Can't parse the TL1 string:" + new String(pkgData));
            return;
        }
        String neName = pTl1data.getData(101);
        long neid = -1L;
        if (2 == pTl1data.getMsgType()) {
            neid = TETL1NECommMgr.getInstance().getLogicReportNEID(neName);
        } else {
            String oldNeName;
            neid = TETL1CommuMgr.instance().getLogicNeID(commInfo, neName);
            if (-1L == neid && null != (oldNeName = TETL1NECommMgr.getInstance().getOldNENameByNew(neName))) {
                neid = TETL1CommuMgr.instance().getLogicNeID(commInfo, oldNeName);
            }
        }
        if (pTl1data.getMsgType() == 3) {
            this.handleTL1Data(neid, pTl1data);
            return;
        }
        if (-1L == neid) {
            logger.info("Can't get neid by NE name ,name is:" + neName);
            return;
        }
        TETL1NEInfo pInfo = TETL1CommuMgr.instance().getNEInfo(neid);
        if (null == pInfo) {
            logger.info("CheckMessageValid Ne 0x%x ,Gne = 0x%x CommuInfo not exist!\n" + neid);
            return;
        }
        pInfo.resetKeepTime();
        TETL1Data pFrame = pInfo.insertFrame(pTl1data);
        if (null == pFrame) {
            logger.info("handleOnePakage(),The message not full,wait for the next packet, ctag=" + pTl1data.getCtag());
        } else if (pFrame.getMsgType() == 2) {
            this.handleTL1ReportData(neid, pFrame);
        } else {
            this.handleTL1Data(neid, pFrame);
        }
    }

    private int getFirstPkgEndIndex(String pDataStr, int offset) {
        int continueCharIndex;
        int endCharIndex = pDataStr.indexOf("\r\n;", offset);
        return endCharIndex > (continueCharIndex = pDataStr.indexOf("\r\n>", offset)) ? endCharIndex : continueCharIndex;
    }

    private int handleTL1ReportData(long neID, TETL1Data pData) {
        TETL1ResponseMsg pMsg = new TETL1ResponseMsg();
        String strCmd = pData.getData(109);
        TEMessageAdapter pAdapter = this.getMessageAdapter(strCmd);
        if (null == pAdapter) {
            logger.warn("No found message adapter,the cmdcode=" + strCmd);
            return 98310;
        }
        this.tl1DataToMsg(neID, pData, pMsg);
        TETL1Message pTL1Msg = new TETL1Message();
        pTL1Msg.setType(3);
        List<TETL1NeMsg> msgVct = pTL1Msg.getMsgVect();
        msgVct.add(pMsg);
        TEMessageBlock msgBlock = new TEMessageBlock(pTL1Msg);
        TETL1TaskManager.getInstance().putReportQueue(msgBlock);
        return 0;
    }

    private int handleTL1Data(long neid, TETL1Data pData) {
        long iCTAG = pData.getCtag();
        if (0L == iCTAG) {
            logger.info("The ctag of TL1 message is zero!,msg type=" + pData.getMsgType());
            return 0;
        }
        TEMessageUnit sinkMsgUnit = new TEMessageUnit();
        sinkMsgUnit.msgSerial = iCTAG;
        sinkMsgUnit.protocolType = 10;
        TEAdapterManager pAdapterManager = TEAdapterManager.getInstance();
        TEMessageUnit srcMsgUnit = pAdapterManager.findSrcMsgUnit(sinkMsgUnit);
        if (null == srcMsgUnit) {
            logger.info("No source message unit for sink message,serial=" + iCTAG);
            return 98306;
        }
        TEMessageInfo srcMsgInfo = pAdapterManager.findSrcMsgInfo(srcMsgUnit);
        if (null == srcMsgInfo) {
            pAdapterManager.eraseSinkUnitMap(sinkMsgUnit);
            logger.info("No source message info for sink message,serial=%d\n" + iCTAG);
            return 98305;
        }
        TETL1Message sinkMsg = (TETL1Message)srcMsgInfo.sinkMessage;
        TETL1NeMsg pNeMsg = sinkMsg.getNeMsg(iCTAG);
        if (null == pNeMsg) {
            return 98306;
        }
        TETL1ResponseMsg rspMsg = (TETL1ResponseMsg)pNeMsg;
        if (pData.getMsgType() == 3) {
            int ak = pData.getAckCode();
            rspMsg.setACK(ak);
            rspMsg.setCompleteCode(6);
            if (2 != ak) {
                return 0;
            }
        } else if (pData.getMsgType() == 1) {
            String oldNEName;
            String nename = pData.getData(101);
            if (!nename.equalsIgnoreCase(oldNEName = TETL1NECommMgr.getInstance().getTL1NEName(neid))) {
                logger.info("Modify neid<->nename map, old map is :" + neid + ":" + oldNEName + "; new map is :" + neid + ":" + nename);
                TETL1NECommMgr.getInstance().putLogicNEIDName(neid, nename);
            }
            this.tl1DataToMsg(neid, pData, rspMsg);
        }
        if (rspMsg.getCompleteCode() != 4) {
            srcMsgInfo.deleteSinkMessage(sinkMsgUnit);
            pAdapterManager.eraseSinkUnitMap(sinkMsgUnit);
        }
        if (srcMsgInfo.getSinkMessageCount() == 0) {
            sinkMsg.setFlag(false);
            TETL1Message rspMessage = new TETL1Message();
            rspMessage.setType(2);
            rspMessage.setMsgVect(sinkMsg.getMsgVect(), true);
            rspMessage.setTEMessageUnit(srcMsgUnit);
            TEMessageBlock msgBlock = new TEMessageBlock(rspMessage);
            TETL1TaskManager.getInstance().putResponseQueue(msgBlock);
        }
        return 0;
    }

    public int sendMessage(TEMessage pMessage) {
        TETL1Message pMsg = (TETL1Message)pMessage;
        List<TETL1NeMsg> msgVct = pMsg.getMsgVect();
        ArrayList<String> vctStr = new ArrayList<String>();
        TETL1NEInfo[] neInfos = new TETL1NEInfo[msgVct.size()];
        for (int i = 0; i < msgVct.size(); ++i) {
            TETL1NeMsg tl1NeMsg = msgVct.get(i);
            String pstrTL1 = this.getTL1StringFromMsg(tl1NeMsg);
            if (null == pstrTL1) {
                logger.info("Can't generate input message!\n");
                return -1;
            }
            vctStr.add(pstrTL1);
            tl1NeMsg.setMsgContent(pstrTL1);
            if (pstrTL1.length() > 8192) {
                logger.info("The input message is too long,msg:%s\n" + pstrTL1);
                return -1;
            }
            neInfos[i] = TETL1CommuMgr.instance().getNEInfo(tl1NeMsg.getNEID());
            if (null != neInfos[i]) continue;
            logger.info(" Get Handle error when callSendMessage,neid=" + tl1NeMsg.getNEID());
            return -1;
        }
        TETL1FrameHead head = new TETL1FrameHead();
        for (int i = 0; i < msgVct.size(); ++i) {
            byte[] pBody = ((String)vctStr.get(i)).getBytes();
            byte[] buf = new byte[pBody.length + 4];
            head.setLength(pBody.length + 4);
            byte[] pHead = head.getNetData();
            System.arraycopy(pHead, 0, buf, 0, 4);
            System.arraycopy(pBody, 0, buf, 4, pBody.length);
            TECommInfo commInfo = TETL1CommuMgr.instance().getNECommInfo(neInfos[i].getNeID());
            TECommunicationMgr.instance().send(commInfo, buf, buf.length);
        }
        return 0;
    }

    public void addMsgAdapter(String key, TEMessageAdapter adapter) {
        if (null == key || key.length() == 0) {
            logger.info("add report message adapter error,key should not be null!\n");
            return;
        }
        this.rptAdapterMap.put(key, adapter);
    }

    public void removeMsgAdaper(String key) {
        this.rptAdapterMap.remove(key);
    }

    public TEMessageAdapter getMessageAdapter(String cmdCode) {
        int pos;
        if (null == cmdCode || cmdCode.length() == 0) {
            logger.info("Get report message adapter error,key should not be null!\n");
            return null;
        }
        TEMessageAdapter pMessageAdapter = this.rptAdapterMap.get(cmdCode);
        if (null == pMessageAdapter && -1 != (pos = cmdCode.indexOf(45))) {
            Iterator<Map.Entry<String, TEMessageAdapter>> iter = this.rptAdapterMap.entrySet().iterator();
            String strcmd = "";
            while (iter.hasNext()) {
                Map.Entry<String, TEMessageAdapter> entry = iter.next();
                String keyStr = entry.getKey();
                int vpos = cmdCode.indexOf(keyStr);
                if (vpos == -1 || keyStr.length() <= strcmd.length()) continue;
                strcmd = keyStr;
            }
            return this.rptAdapterMap.get(strcmd);
        }
        return pMessageAdapter;
    }

    @Override
    public void destroy() {
    }

    @Override
    public int handleMessage(TEMessage pMessage) {
        switch (pMessage.getType()) {
            case 1: {
                return this.sendMessage(pMessage);
            }
            case 2: 
            case 3: {
                return pMessage.handleMessage();
            }
        }
        logger.info("Msg type error: %d \n" + pMessage.getType());
        return -1;
    }

    private TETL1Data inputMsgToTL1Data(TETL1NeMsg pMsg) {
        TETL1Data tl1data = new TETL1Data();
        TETL1InputMessage pInputMsg = (TETL1InputMessage)pMsg;
        tl1data.setMsgType(0);
        String cmdcode = pInputMsg.getCmdCode();
        if (null == cmdcode || cmdcode.trim().length() == 0) {
            logger.warn("The CmdCode is null.");
            return null;
        }
        tl1data.addData(100, pInputMsg.getCmdCode());
        int mCount = pInputMsg.getModifierCount();
        tl1data.setModifierCount(mCount);
        for (int i = 0; i < mCount; ++i) {
            tl1data.addData(200 + i + 1, pInputMsg.getModifier(i));
        }
        tl1data.addData(102, pInputMsg.getAid());
        long neid = pInputMsg.getNEID();
        String sName = TETL1NECommMgr.getInstance().getTL1NEName(neid);
        if (null == sName) {
            logger.info("Get NE Name fail,neid =" + neid);
            sName = "";
        }
        tl1data.addData(101, sName);
        tl1data.addData(103, String.valueOf(pInputMsg.getSerial()));
        TETL1ParamLine pimpl = pInputMsg.getParamLine();
        tl1data.setStrParamLine(pimpl.getStrParam());
        List<List<TETL1ParamBlock>> paramlines = tl1data.getParamLines();
        if (null != pimpl.getParamBlockVct() && !pimpl.getParamBlockVct().isEmpty()) {
            paramlines.add(pimpl.getParamBlockVct());
        }
        return tl1data;
    }

    private void tl1DataToMsg(long neid, TETL1Data tl1data, TETL1ResponseMsg pMsg) {
        String strValue = tl1data.getData(101);
        if (null == pMsg.getMsgContent()) {
            pMsg.setMsgContent(new String(tl1data.getRawBytes()));
        } else {
            pMsg.setMsgContent(pMsg.getMsgContent().concat("\r\n").concat(new String(tl1data.getRawBytes())));
        }
        pMsg.setNEID(neid);
        Date datetime = tl1data.getDateTime();
        pMsg.setData(datetime);
        List<String> dstErrVct = pMsg.getErrCodes();
        List<String> srcErrVct = tl1data.getErrVct();
        dstErrVct.addAll(srcErrVct);
        List<String> dstErrInfo = pMsg.getErrComments();
        List<String> srcErrInfo = tl1data.getCommentVct();
        dstErrInfo.addAll(srcErrInfo);
        List<TETL1ParamLine> params = pMsg.getParamLines();
        TETL1ParamLine impl = null;
        List<List<TETL1ParamBlock>> paramlines = tl1data.getParamLines();
        int size = paramlines.size();
        for (int i = 0; i < size; ++i) {
            impl = new TETL1ParamLine();
            if (tl1data.getMsgType() != 2) {
                impl.setPosParamNameVector(pMsg.getPosParamVct());
            }
            List<TETL1ParamBlock> paramline = paramlines.get(i);
            impl.setParamBlockVct(paramline);
            params.add(impl);
        }
        pMsg.setType(tl1data.getMsgType());
        if (tl1data.getMsgType() == 1) {
            pMsg.setSerial(tl1data.getCtag());
            pMsg.setCompleteCode(tl1data.getCmplCode());
        } else if (tl1data.getMsgType() == 2) {
            strValue = tl1data.getData(100);
            pMsg.setCmdCode(strValue);
            int icount = tl1data.getModifierCount();
            for (int i = 0; i < icount; ++i) {
                strValue = tl1data.getData(200 + i + 1);
                pMsg.appendModifier(strValue);
            }
            List<String> atagVct = tl1data.getAtagVct();
            pMsg.setATAG(atagVct);
            pMsg.setAlmcode(tl1data.getAlrmCode());
        } else {
            logger.info(" Get Handle error when call TETL1ProtocolAdapter::tl1DataToMsg! \n");
        }
    }

    public String getTL1StringFromMsg(TETL1NeMsg pmsg) {
        if (null == pmsg) {
            return null;
        }
        if (pmsg.getType() == 0) {
            TETL1Data tl1data = this.inputMsgToTL1Data(pmsg);
            return TETL1Parser.getInstance().toTL1String(tl1data);
        }
        return null;
    }

    @Override
    public int cancelMessage(TEMessage pMessage) {
        return TEAdapterManager.getInstance().unRegisterSinkMessage(pMessage);
    }
}

