/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.tl1.tl1adapter;

import com.huawei.uflight.tl1.tl1adapter.TETL1ParamBlock;
import com.huawei.uflight.tl1.tl1adapter.TETL1Util;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.LoggerFactory;

public class TETL1PosParamBlock
extends TETL1ParamBlock {
    private List<String> vctParam;
    private static final String NULLSTRING = "";

    public TETL1PosParamBlock() {
        this.vctParam = new ArrayList<String>();
    }

    public TETL1PosParamBlock(int num) {
        this.vctParam = new ArrayList<String>(num);
        for (int i = 0; i < num; ++i) {
            this.vctParam.add(NULLSTRING);
        }
    }

    @Override
    public String toString() {
        if (this.vctParam.isEmpty()) {
            return NULLSTRING;
        }
        StringBuffer buf = new StringBuffer();
        for (String paramValue : this.vctParam) {
            buf.append(",");
            buf.append(paramValue);
        }
        String strout = buf.toString();
        strout = strout.substring(1, strout.length());
        return strout;
    }

    @Override
    public boolean setStrValue(String name, String value) {
        throw new UnsupportedOperationException("does support setstrvalue in tetelposparamimpl");
    }

    @Override
    public boolean setStrValue(int position, String value) {
        if (position >= this.vctParam.size()) {
            LoggerFactory.getLogger(this.getClass()).error("Invalid index for position parameter when setStrValue,index=" + position);
            return false;
        }
        this.vctParam.set(position, value);
        return true;
    }

    @Override
    public String getStrValue(String name, String defaultValue) {
        throw new UnsupportedOperationException("does support getStrValue in tetelposparamimpl");
    }

    @Override
    public String getStrValue(String name) {
        throw new UnsupportedOperationException("does support getStrValue in tetelposparamimpl");
    }

    @Override
    public String getStrValue(int position, String defaultValue) {
        if (position >= this.vctParam.size()) {
            LoggerFactory.getLogger(this.getClass()).error("Invalid index for position parameter when getStrValue,index=" + position);
            return defaultValue;
        }
        return this.getStrValue(position);
    }

    @Override
    public String getStrValue(int position) {
        return this.vctParam.get(position);
    }

    @Override
    public int count() {
        return this.vctParam.size();
    }

    @Override
    public boolean setStrParam(String str) {
        if (NULLSTRING.equals(str)) {
            return true;
        }
        ArrayList<String> tmpList = new ArrayList<String>();
        if (!TETL1Util.token(str, ",", tmpList)) {
            LoggerFactory.getLogger(this.getClass()).error("Exception raised when TETL1PosParamBlock::setStrParam!");
            return false;
        }
        if (tmpList.isEmpty()) {
            return false;
        }
        this.vctParam.addAll(tmpList);
        return true;
    }

    @Override
    public boolean deleteParam(String name) {
        throw new UnsupportedOperationException("You should not use deleteParam in TETL1PosParamBlock\n");
    }

    @Override
    public boolean setNull(int position) {
        if (position >= this.vctParam.size()) {
            LoggerFactory.getLogger(this.getClass()).error("Invalid index for position parameter when setNull,index=" + position);
            return false;
        }
        this.vctParam.set(position, NULLSTRING);
        return true;
    }

    @Override
    public void clear() {
        this.vctParam.clear();
    }

    @Override
    public int type() {
        return 1;
    }

    public void add(String value) {
        this.vctParam.add(value);
    }

    public List<String> getAllParams() {
        return this.vctParam;
    }
}

