/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.tl1.tl1adapter;

import com.huawei.uflight.tl1.tl1adapter.TETL1AckParserImpl;
import com.huawei.uflight.tl1.tl1adapter.TETL1AutoMsgParserImpl;
import com.huawei.uflight.tl1.tl1adapter.TETL1Data;
import com.huawei.uflight.tl1.tl1adapter.TETL1InputMsgParserImpl;
import com.huawei.uflight.tl1.tl1adapter.TETL1ParseImplBase;
import com.huawei.uflight.tl1.tl1adapter.TETL1RspParserImpl;
import org.slf4j.LoggerFactory;

public final class TETL1Parser {
    private static TETL1Parser instance = new TETL1Parser();
    private TETL1ParseImplBase[] parseImplMap = new TETL1ParseImplBase[4];

    private TETL1Parser() {
        this.parseImplMap[2] = new TETL1AutoMsgParserImpl();
        this.parseImplMap[0] = new TETL1InputMsgParserImpl();
        this.parseImplMap[3] = new TETL1AckParserImpl();
        this.parseImplMap[1] = new TETL1RspParserImpl();
    }

    public static TETL1Parser getInstance() {
        return instance;
    }

    public boolean parse(byte[] tl1bytes, TETL1Data tl1Data) {
        if (tl1bytes == null) {
            LoggerFactory.getLogger(this.getClass()).info("TETL1Parse.parse() fail,the tl1bytes is null.");
            return false;
        }
        TETL1ParseImplBase pImpl = null;
        String strTL1 = new String(tl1bytes);
        if (strTL1.indexOf("\r\n<") != -1) {
            pImpl = this.parseImplMap[3];
            tl1Data.setMsgType(3);
        } else if (strTL1.indexOf("\r\nM  ") != -1) {
            pImpl = this.parseImplMap[1];
            tl1Data.setMsgType(1);
        } else {
            pImpl = this.parseImplMap[2];
            tl1Data.setMsgType(2);
        }
        tl1Data.setRawBytes(tl1bytes);
        return pImpl.parse(tl1bytes, tl1Data);
    }

    public String toTL1String(TETL1Data tl1data) {
        TETL1ParseImplBase pImpl = this.parseImplMap[tl1data.getMsgType()];
        return pImpl.toTL1String(tl1data);
    }
}

