/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.tl1.tl1adapter;

import com.huawei.uflight.tl1.tl1adapter.TETL1Data;
import com.huawei.uflight.tl1.tl1adapter.TETL1NameParamBlock;
import com.huawei.uflight.tl1.tl1adapter.TETL1ParamBlock;
import com.huawei.uflight.tl1.tl1adapter.TETL1PosParamBlock;
import com.huawei.uflight.tl1.tl1adapter.TETL1Util;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TETL1ParseImplBase {
    static final int MIN_HEAD_LENGTH = 20;
    static final int MAX_SID_LENGTH = 20;
    static final int MAX_TB_LENGTH = 8192;
    static final int ERRCODE_LENGTH = 4;
    static final String TB_SEPARATOR = "\r\n   ";
    static final String TB_SEPARATOR_G199 = "\r\n";
    static final String MSG_HEAD_START = "\r\n\n   ";
    static final int MSG_HEAD_START_LEN = 6;
    static final int TB_SEPARATOR_LEN = 5;
    static final int TB_SEPARATOR_LEN_G199 = 2;
    private static Logger logger = LoggerFactory.getLogger(TETL1ParseImplBase.class);

    public abstract String toTL1String(TETL1Data var1);

    public abstract boolean parse(byte[] var1, TETL1Data var2);

    boolean parseTerminator(byte[] tl1bytes, TETL1Data tl1Data) {
        String strTL1 = new String(tl1bytes);
        if (strTL1.endsWith("\r\n;")) {
            tl1Data.setFull(true);
            return true;
        }
        if (strTL1.endsWith("\r\n>")) {
            tl1Data.setFull(false);
            return true;
        }
        logger.error("The msg terminator is invalid , msg=" + strTL1);
        return false;
    }

    boolean parseHead(byte[] tl1bytes, TETL1Data tl1Data) {
        String strTL1 = new String(tl1bytes);
        int len = strTL1.length();
        if (20 > len) {
            logger.error("The length of TL1 msg head is too short,head=" + strTL1);
            return false;
        }
        if (!strTL1.startsWith(MSG_HEAD_START)) {
            logger.error("The msg head is invalidate! msg=" + strTL1);
            return false;
        }
        int pos = 6;
        int pEnd = strTL1.indexOf(13, pos);
        if (-1 == pEnd) {
            pEnd = strTL1.length();
        }
        tl1Data.setHeaderEndPos(pEnd - 1);
        String tmp = strTL1.substring(pos, pEnd);
        return this.parseHeadBody(tmp, tl1Data);
    }

    private boolean parseHeadBody(String headBody, TETL1Data tl1Data) {
        String[] strVct = headBody.split(" ");
        if (strVct.length != 3) {
            logger.error("The sid ,date,time in TL1 msg is not correct,msg=" + headBody);
            return false;
        }
        if (!this.parseSID(strVct[0], tl1Data)) {
            return false;
        }
        return this.parseDataTime(strVct[1], strVct[2], tl1Data);
    }

    private boolean parseSID(String sidStr, TETL1Data tl1Data) {
        if ("".equals(sidStr)) {
            logger.error("The sid is null.");
            return false;
        }
        if (20 < sidStr.length()) {
            logger.error("The sid is too long,sid=" + sidStr);
            return false;
        }
        tl1Data.addData(101, sidStr);
        return true;
    }

    private boolean parseDataTime(String dataStr, String timeStr, TETL1Data tl1Data) {
        String[] dataArr = dataStr.split("-");
        if (dataArr.length != 3) {
            logger.error("The format of date is not correct,date=" + dataStr);
            return false;
        }
        int year = Integer.parseInt(dataArr[0]);
        int month = Integer.parseInt(dataArr[1]) - 1;
        int day = Integer.parseInt(dataArr[2]);
        String[] timeArr = timeStr.split(":");
        if (timeArr.length != 3) {
            logger.error("The format of time is not correct,time=" + timeStr);
            return false;
        }
        int hrs = Integer.parseInt(timeArr[0]);
        int min = Integer.parseInt(timeArr[1]);
        int sec = Integer.parseInt(timeArr[2]);
        if (year <= 88) {
            year += 2000;
        } else if (year >= 89 && year < 1000) {
            year += 1900;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month, day, hrs, min, sec);
        tl1Data.setDateTime(calendar.getTime());
        return true;
    }

    boolean parseTextBlock(byte[] tl1bytes, TETL1Data tl1Data) {
        String strTL1 = new String(tl1bytes);
        if (strTL1.length() == 0) {
            logger.info("The textblock is null.");
            return true;
        }
        if (!this.checkTextBlockValidate(strTL1)) {
            return false;
        }
        List<String> textLst = this.getAllText(strTL1);
        int size = textLst.size();
        for (int i = 0; i < size; ++i) {
            String tmp = textLst.get(i);
            boolean sucess = tmp.startsWith("/*") ? this.parseComment(tmp, tl1Data) : (tmp.startsWith("\"") ? this.parseQuoteLine(tmp, tl1Data) : this.parseUnQuoteLine(tmp, tl1Data));
            if (sucess) continue;
            logger.error("parseTextBlock() fail,the textBlock is :\n" + strTL1);
            return false;
        }
        return true;
    }

    private boolean checkTextBlockValidate(String textBlock) {
        if (textBlock.length() > 8192) {
            logger.error("The textblock of msg is too long,msg=" + textBlock);
            return false;
        }
        if (!textBlock.startsWith(TB_SEPARATOR) && !textBlock.startsWith(TB_SEPARATOR_G199)) {
            logger.error("The textblock is invalid,msg =" + textBlock);
            return false;
        }
        return true;
    }

    private List<String> getAllText(String textBlock) {
        ArrayList<Integer> splitIndexLst = new ArrayList<Integer>();
        ArrayList<String> textLst = new ArrayList<String>();
        int startCharLen = 5;
        String startChar = TB_SEPARATOR;
        if (!textBlock.startsWith(TB_SEPARATOR) && textBlock.startsWith(TB_SEPARATOR_G199)) {
            startCharLen = 2;
            startChar = TB_SEPARATOR_G199;
            textLst.add(textBlock.substring(startCharLen));
            return textLst;
        }
        String truncateStr = textBlock.substring(startCharLen);
        TETL1Util.findSplitIndexLst(truncateStr, startChar, splitIndexLst);
        int curIndex = 0;
        int splitIndex = 0;
        for (int k = 0; k < splitIndexLst.size(); ++k) {
            splitIndex = (Integer)splitIndexLst.get(k);
            textLst.add(truncateStr.substring(curIndex, splitIndex));
            curIndex = splitIndex + startCharLen;
        }
        textLst.add(truncateStr.substring(curIndex));
        return textLst;
    }

    private boolean parseComment(String comment, TETL1Data tl1Data) {
        if (!comment.endsWith("*/")) {
            logger.error("Comment is invalidate, no end slash, Comment = " + comment);
            return false;
        }
        comment = comment.substring(2, comment.length() - 2);
        tl1Data.getCommentVct().add(comment);
        return true;
    }

    private boolean parseQuoteLine(String quoteLine, TETL1Data tl1Data) {
        if (!quoteLine.endsWith("\"")) {
            logger.error("QuoteLine is invalidate, no end quote, quoteLine = " + quoteLine);
            return false;
        }
        quoteLine = quoteLine.substring(1, quoteLine.length() - 1);
        ArrayList<TETL1ParamBlock> pVct = new ArrayList<TETL1ParamBlock>();
        tl1Data.getParamLines().add(pVct);
        return this.parseParamLines(quoteLine, pVct);
    }

    private boolean parseUnQuoteLine(String unQuoteLine, TETL1Data tl1Data) {
        if (unQuoteLine.length() != 4) {
            logger.error("The error code is too long,code=\"" + unQuoteLine + "\"");
            return false;
        }
        tl1Data.getErrVct().add(unQuoteLine);
        return true;
    }

    private boolean parseParamLines(String strTL1, List<TETL1ParamBlock> pVct) {
        TETL1ParamBlock pBlock = null;
        ArrayList<Integer> dummyVec = new ArrayList<Integer>();
        ArrayList<String> result = new ArrayList<String>();
        TETL1Util.token(strTL1, ":", result);
        for (String str : result) {
            TETL1Util.findSplitIndexLst(str, "=", dummyVec);
            pBlock = dummyVec.isEmpty() ? new TETL1PosParamBlock() : new TETL1NameParamBlock();
            pBlock.setStrParam(str);
            pVct.add(pBlock);
        }
        return true;
    }

    String generateParamLines(List<List<TETL1ParamBlock>> params) {
        if (params.isEmpty()) {
            return "";
        }
        if (params.size() != 1) {
            throw new IllegalArgumentException("when generate ParamLines\u00a3\u00acthe paramline size != 1");
        }
        List<TETL1ParamBlock> pVct = params.get(0);
        if (pVct.isEmpty()) {
            return "";
        }
        int len = pVct.size();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            if (i != 0) {
                buf.append(":");
            }
            buf.append(pVct.get(i).toString());
        }
        return buf.toString();
    }
}

