/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.tl1.tl1adapter;

import com.huawei.uflight.tl1.tl1adapter.TETL1NameParamBlock;
import com.huawei.uflight.tl1.tl1adapter.TETL1ParamBlock;
import com.huawei.uflight.tl1.tl1adapter.TETL1PosParamBlock;
import com.huawei.uflight.tl1.tl1adapter.TETL1Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.LoggerFactory;

public class TETL1ParamLine
extends TETL1ParamBlock {
    private String strParamLine;
    private TETL1ParamBlock currParamBlock;
    private Map<String, String> nameValueMap;
    private List<TETL1ParamBlock> paramBlockLst = new ArrayList<TETL1ParamBlock>();
    private List<String> paramLst;
    private List<String> posParamNameLst;
    private int nameItor;
    private String strNullParam = "";

    public TETL1ParamLine() {
        this.nameValueMap = new HashMap<String, String>();
        this.paramLst = new ArrayList<String>();
    }

    @Override
    public int count() {
        return this.nameValueMap.size();
    }

    @Override
    public String getStrValue(int index, String defaultValue) {
        String value = this.getStrValue(index);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    @Override
    public String getStrValue(int index) {
        if (index >= this.paramLst.size()) {
            throw new IllegalArgumentException("Invalid index for position parameterwhen getStrValue in iMapTL1ParamLineImpl,index=%d\n" + index);
        }
        return this.paramLst.get(index);
    }

    @Override
    public String getStrValue(String name, String defaultValue) {
        String value = this.getStrValue(name);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    @Override
    public String getStrValue(String name) {
        if ("".equals(name)) {
            throw new IllegalArgumentException("The name of parameter is empty when getStrValue in iMapTL1ParamLineImpl");
        }
        String result = this.nameValueMap.get(name);
        return result;
    }

    @Override
    public boolean setStrValue(String name, String value) {
        return this.currParamBlock.setStrValue(name, value);
    }

    @Override
    public boolean setStrValue(int pos, String value) {
        return this.currParamBlock.setStrValue(pos, value);
    }

    @Override
    public boolean deleteParam(String name) {
        return this.currParamBlock.deleteParam(name);
    }

    @Override
    public boolean setNull(int pos) {
        return this.currParamBlock.setNull(pos);
    }

    @Override
    public void clear() {
        this.nameValueMap.clear();
        this.paramLst.clear();
        for (TETL1ParamBlock pblock : this.paramBlockLst) {
            pblock.clear();
        }
        this.paramBlockLst.clear();
    }

    @Override
    public boolean setStrParam(String strParamLine) {
        this.strParamLine = strParamLine;
        return true;
    }

    @Override
    public int type() {
        return 2;
    }

    @Override
    public String toString() {
        String strTL1 = "";
        StringBuffer buf = new StringBuffer();
        if (this.paramBlockLst != null) {
            for (TETL1ParamBlock pblock : this.paramBlockLst) {
                buf.append(pblock.toString());
                buf.append(":");
            }
        }
        strTL1 = buf.toString();
        return strTL1;
    }

    public void add(int pamramtype, int num) {
        this.currParamBlock = null;
        if (0 == pamramtype) {
            this.currParamBlock = new TETL1NameParamBlock();
        } else if (1 == pamramtype) {
            this.currParamBlock = new TETL1PosParamBlock(num);
        } else if (3 == pamramtype) {
            this.currParamBlock = new TETL1PosParamBlock();
        } else {
            throw new IllegalArgumentException("Invalid parameter type" + pamramtype + " when user add in iMapTL1ParamLineImpl \n");
        }
        if (this.paramBlockLst == null) {
            this.paramBlockLst = new ArrayList<TETL1ParamBlock>();
        }
        if (this.currParamBlock != null) {
            this.paramBlockLst.add(this.currParamBlock);
        }
    }

    public List<TETL1ParamBlock> getParamBlockVct() {
        return this.paramBlockLst;
    }

    public void setParamBlockVct(List<TETL1ParamBlock> pVct) {
        this.paramBlockLst = pVct;
        int len = pVct.size();
        for (int i = 0; i < len; ++i) {
            TETL1ParamBlock pBlock = this.paramBlockLst.get(i);
            this.addParamBlock(pBlock);
        }
    }

    private void addParamBlock(TETL1ParamBlock pBlock) {
        if (pBlock.type() == 0) {
            String strtmp;
            TETL1NameParamBlock pParam = (TETL1NameParamBlock)pBlock;
            Map<String, String> paramMap = pParam.getAllParams();
            for (Map.Entry<String, String> entry : paramMap.entrySet()) {
                String name = entry.getKey();
                String value = entry.getValue();
                value = TETL1Util.excludeTransfer(value);
                this.nameValueMap.put(name, value);
                this.paramLst.add(value);
            }
            if (this.posParamNameLst != null && this.nameItor != this.posParamNameLst.size() && "TL1_EMPTY_NAME".equals(strtmp = this.posParamNameLst.get(this.nameItor))) {
                ++this.nameItor;
            }
            return;
        }
        if (pBlock.type() == 1) {
            TETL1PosParamBlock pParam;
            List<String> paramVct;
            if (this.posParamNameLst == null) {
                return;
            }
            if (this.nameItor == this.posParamNameLst.size()) {
                String strTemp = pBlock.toString();
                LoggerFactory.getLogger(this.getClass()).info("There is a posparamblock not registered name of the value.The block is :" + strTemp);
                return;
            }
            if (pBlock.count() == 0) {
                ++this.nameItor;
                return;
            }
            String strtmp = this.posParamNameLst.get(this.nameItor);
            String[] nameVct = strtmp.split(",");
            if (nameVct.length < (paramVct = (pParam = (TETL1PosParamBlock)pBlock).getAllParams()).size()) {
                LoggerFactory.getLogger(this.getClass()).info("The name of parameter block of position from app isn't enought\u00a3\u00ac" + strtmp);
            }
            String pStr = null;
            for (int i = 0; i < nameVct.length; ++i) {
                if (i < paramVct.size()) {
                    pStr = paramVct.get(i);
                    pStr = TETL1Util.excludeTransfer(pStr);
                    this.nameValueMap.put(nameVct[i], pStr);
                    this.paramLst.add(pStr);
                    continue;
                }
                LoggerFactory.getLogger(this.getClass()).info("register value more than message from device, name is " + nameVct[i]);
                this.paramLst.add(this.strNullParam);
                this.nameValueMap.put(nameVct[i], this.strNullParam);
            }
            ++this.nameItor;
        } else {
            throw new IllegalArgumentException("not name param and not pos param, so what r u?");
        }
    }

    public void setPosParamNameVector(List<String> posParamNameLst) {
        if (posParamNameLst == null) {
            throw new IllegalArgumentException("this setPosParamNameVector param cannot be null");
        }
        this.posParamNameLst = posParamNameLst;
        this.nameItor = 0;
    }

    public String getStrParam() {
        return this.strParamLine;
    }
}

