/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.tl1.tl1adapter;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.LoggerFactory;

public class TETL1NeMsg {
    protected long serial = 0L;
    protected long logicNeId = 0L;
    protected int msgType = 0;
    protected String strCmdCode;
    protected String strTL1 = null;
    protected List<String> vctModifier = new ArrayList<String>(2);

    public void setType(int type) {
        this.msgType = type;
    }

    public int getType() {
        return this.msgType;
    }

    public void setCmdCode(String cmdcode) {
        if (null == cmdcode || "".equals(cmdcode)) {
            throw new IllegalArgumentException("cmdcode is null");
        }
        this.strCmdCode = cmdcode;
    }

    public String getCmdCode() {
        return this.strCmdCode;
    }

    public String getModifier(int index) {
        if (index >= this.vctModifier.size()) {
            LoggerFactory.getLogger(this.getClass()).error("Invalid index of modifier when getModifier,The index=" + index + ",size=" + this.vctModifier.size());
            return "";
        }
        return this.vctModifier.get(index);
    }

    public void appendModifier(String modifier) {
        if (null == modifier || "".equals(modifier.trim())) {
            return;
        }
        if (this.vctModifier.size() >= 2) {
            throw new IllegalArgumentException("There have been 2 modifiers,can't append\n");
        }
        this.vctModifier.add(modifier);
    }

    public String getMsgContent() {
        return this.strTL1;
    }

    public void setMsgContent(String strContent) {
        this.strTL1 = strContent;
    }

    public void setNEID(long neid) {
        if (-1L == neid) {
            throw new IllegalArgumentException("TETL1NeMsg::setNEID() fail, neid=" + neid);
        }
        this.logicNeId = neid;
    }

    public long getNEID() {
        return this.logicNeId;
    }

    public void setSerial(long serial) {
        this.serial = serial;
    }

    public long getSerial() {
        return this.serial;
    }

    public int getModifierCount() {
        return this.vctModifier.size();
    }

    public String getCmdKey() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.strCmdCode);
        for (int i = 0; i < this.vctModifier.size(); ++i) {
            buf.append('-');
            buf.append(this.vctModifier.get(i));
        }
        return buf.toString();
    }
}

