/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.tl1.tl1adapter;

import com.huawei.uflight.tl1.tl1adapter.TETL1ParamBlock;
import com.huawei.uflight.tl1.tl1adapter.TETL1Util;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.LoggerFactory;

public class TETL1NameParamBlock
extends TETL1ParamBlock {
    private static final int NAME_LENGTH = 20;
    public static final String NAMESEPARATOR = "=";
    private Map<String, String> nameValueMap = new LinkedHashMap<String, String>();

    @Override
    public String toString() {
        String strout = "";
        if (this.nameValueMap.isEmpty()) {
            return strout;
        }
        StringBuffer buf = new StringBuffer();
        for (Map.Entry<String, String> entry : this.nameValueMap.entrySet()) {
            buf.append(entry.getKey());
            buf.append(NAMESEPARATOR);
            buf.append(entry.getValue());
            buf.append(",");
        }
        strout = buf.toString();
        strout = strout.substring(0, strout.length() - 1);
        return strout;
    }

    @Override
    public boolean setStrValue(String name, String value) {
        if (null == name || "".equals(name)) {
            LoggerFactory.getLogger(this.getClass()).error("the name of parameter is empty");
            return false;
        }
        this.nameValueMap.put(name, value);
        return true;
    }

    @Override
    public boolean setStrValue(int position, String value) {
        throw new UnsupportedOperationException("You should not use setStrValue by position in TETL1NameParamBlock");
    }

    @Override
    public String getStrValue(String name, String defaultValue) {
        if ("".equals(name)) {
            LoggerFactory.getLogger(this.getClass()).error("the name of parameter is empty");
            return defaultValue;
        }
        String value = this.getStrValue(name);
        if (null == value) {
            value = defaultValue;
        }
        return value;
    }

    @Override
    public String getStrValue(String name) {
        return this.nameValueMap.get(name);
    }

    @Override
    public String getStrValue(int position, String defaultValue) {
        if (position > this.nameValueMap.size()) {
            LoggerFactory.getLogger(this.getClass()).error("Invalid position when getStrValue in TETL1NameParamBlock");
            return defaultValue;
        }
        String value = this.getStrValue(position);
        if (null == value) {
            value = defaultValue;
        }
        return value;
    }

    @Override
    public String getStrValue(int position) {
        int index = 0;
        for (Map.Entry<String, String> entry : this.nameValueMap.entrySet()) {
            if (index == position) {
                return entry.getValue();
            }
            ++index;
        }
        return null;
    }

    @Override
    public int count() {
        return this.nameValueMap.size();
    }

    @Override
    public boolean deleteParam(String name) {
        this.notEmpty(name);
        String value = this.nameValueMap.remove(name);
        return value != null;
    }

    @Override
    public boolean setNull(int pos) {
        throw new UnsupportedOperationException("You should not use setNull in TETL1NameParamBlock");
    }

    @Override
    public void clear() {
        this.nameValueMap.clear();
    }

    @Override
    public int type() {
        return 0;
    }

    @Override
    public boolean setStrParam(String str) {
        if (null == str || "".equals(str)) {
            return true;
        }
        ArrayList<String> strLst = new ArrayList<String>();
        TETL1Util.token(str, ",", strLst);
        String name = null;
        String value = null;
        for (String subStr : strLst) {
            ArrayList<String> result = new ArrayList<String>();
            TETL1Util.token(subStr, NAMESEPARATOR, result);
            name = (String)result.get(0);
            if ("".equals(name)) {
                LoggerFactory.getLogger(this.getClass()).info("The name of parameter can't be null,the str is:" + subStr);
                continue;
            }
            if (name.length() > 20) {
                LoggerFactory.getLogger(this.getClass()).info("The length of parameter name is too long,The name is:" + name);
                continue;
            }
            if (this.nameValueMap.containsKey(name)) {
                LoggerFactory.getLogger(this.getClass()).info("The parameter whose name is " + name + " repeat!");
                continue;
            }
            if (result.size() == 1) {
                this.nameValueMap.put(name, "");
                continue;
            }
            value = (String)result.get(1);
            this.nameValueMap.put(name, value);
        }
        return true;
    }

    public Map<String, String> getAllParams() {
        return this.nameValueMap;
    }
}

