/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.tl1.tl1adapter;

import com.huawei.uflight.necomm.TECommConnection;
import com.huawei.uflight.necomm.TECommInfo;
import com.huawei.uflight.tl1.internal.TETL1TaskManager;
import com.huawei.uflight.tl1.tl1adapter.TETL1Data;
import com.huawei.uflight.tl1.tl1adapter.TETL1InputMessage;
import com.huawei.uflight.tl1.tl1adapter.TETL1Message;
import com.huawei.uflight.tl1.tl1adapter.TETL1NeMsg;
import com.huawei.uflight.tl1.tl1adapter.TETL1ProtocolAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TETL1NEInfo
implements TECommConnection {
    private static final int COMMUINFO_LIFE = 180;
    private static final int COMMUINFO_INTERVAL = 60;
    private static Logger logger = LoggerFactory.getLogger(TETL1NEInfo.class);
    private Map<Long, TETL1Data> rspMsgMap = new HashMap<Long, TETL1Data>();
    private Map<Long, TETL1Data> autoMsgMap = new HashMap<Long, TETL1Data>();
    private int keepTime = 0;
    private long neID = 0L;
    private int connectState = 0;

    public int getConnectState() {
        return this.connectState;
    }

    private TETL1Data combinateData(Map<Long, TETL1Data> frameMap, long key, TETL1Data pFrame) {
        TETL1Data tl1data = frameMap.get(key);
        if (null == tl1data) {
            tl1data = pFrame;
            frameMap.put(key, pFrame);
        } else {
            tl1data.appendTL1Data(pFrame);
        }
        if (tl1data.getFull()) {
            frameMap.remove(key);
            return tl1data;
        }
        logger.info("The message not full, ctag=" + pFrame.getCtag());
        return null;
    }

    public TETL1NEInfo(long neID) {
        this.neID = neID;
        this.keepTime = 180;
    }

    public void refreshFrame() {
        String str1 = "The TL1 response message frame timeout,The ctag is:";
        this.refreshInfo(this.rspMsgMap, str1);
        String str2 = "The TL1 response message frame timeout,The command code is:";
        this.refreshInfo(this.autoMsgMap, str2);
    }

    public static void refreshNEInfo(Map<TETL1NEInfo, TECommInfo> msgMap) {
        TETL1NEInfo neInfo2 = null;
        for (TETL1NEInfo neInfo2 : msgMap.keySet()) {
            TETL1Message tl1message = new TETL1Message();
            ArrayList<TETL1NeMsg> msgList = new ArrayList<TETL1NeMsg>();
            tl1message.setMsgVect(msgList, true);
            TETL1InputMessage inputmsg = new TETL1InputMessage();
            inputmsg.setCmdCode("XXX");
            inputmsg.setNEID(neInfo2.neID);
            msgList.add(inputmsg);
            if (neInfo2.getConnectState() != 1) continue;
            TETL1ProtocolAdapter.getInstance().sendMessage(tl1message);
        }
    }

    public void refreshInfo(Map<Long, TETL1Data> msgMap, String fmt) {
        TETL1Data pData = null;
        for (Map.Entry<Long, TETL1Data> iterObj : msgMap.entrySet()) {
            pData = iterObj.getValue();
            if (pData.decKeepTime() > 0) continue;
            logger.info(fmt + pData.getCtag());
            msgMap.remove(iterObj.getKey());
        }
    }

    TETL1Data insertFrame(TETL1Data pFrameData) {
        switch (pFrameData.getMsgType()) {
            case 2: {
                long atagNum = Long.parseLong(pFrameData.getAtagVct().get(0));
                return this.combinateData(this.autoMsgMap, atagNum, pFrameData);
            }
            case 1: {
                long ctag = pFrameData.getCtag();
                TETL1Data teTL1Data = this.combinateData(this.rspMsgMap, ctag, pFrameData);
                if (teTL1Data != null && teTL1Data.getCommentVct().contains("LOGIN NOT ACTIVE")) {
                    TETL1TaskManager.getInstance().dispatchNELoginState((int)this.neID, false);
                }
                return teTL1Data;
            }
        }
        logger.info("Unkonw Message, the msgType = " + pFrameData.getMsgType());
        return null;
    }

    public int decKeepTime() {
        int tmp;
        this.keepTime = tmp = this.keepTime - 60;
        return this.keepTime;
    }

    public void resetKeepTime() {
        this.keepTime = 180;
    }

    @Override
    public void connectStateChanged(int connectState) {
        boolean bConnected;
        if (connectState == 0) {
            this.connectState = 1;
            bConnected = true;
        } else {
            this.connectState = 0;
            bConnected = false;
        }
        TETL1TaskManager.getInstance().dispatchNEState(this.neID, bConnected);
        logger.info("NE(neid=" + this.neID + ") STATE: " + connectState);
    }

    public String toString() {
        String linesep = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        sb.append("neID:");
        sb.append(this.neID);
        sb.append(linesep);
        sb.append("connstate:");
        sb.append(this.getConnectState());
        sb.append(linesep);
        sb.append(linesep);
        sb.append("m_rspMsgMap size:");
        sb.append(this.rspMsgMap.size());
        sb.append(linesep);
        sb.append(this.getMapInfo(this.rspMsgMap));
        sb.append(linesep);
        sb.append("m_autoMsgMap size:");
        sb.append(this.autoMsgMap.size());
        sb.append(linesep);
        sb.append(this.getMapInfo(this.autoMsgMap));
        sb.append(linesep);
        return sb.toString();
    }

    private String getMapInfo(Map<Long, TETL1Data> map) {
        String linesep = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        for (Map.Entry<Long, TETL1Data> iterObj : map.entrySet()) {
            long tagid = iterObj.getKey();
            TETL1Data tl1data = iterObj.getValue();
            sb.append("tagid:").append(tagid).append("\ttl1Data Message:").append(linesep);
            sb.append(tl1data.toString());
        }
        return sb.toString();
    }

    public long getNeID() {
        return this.neID;
    }
}

