/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.tl1.tl1adapter;

import com.huawei.uflight.tl1.internal.TEAdapterManager;
import com.huawei.uflight.tl1.internal.TEMessage;
import com.huawei.uflight.tl1.internal.TEMessageAdapter;
import com.huawei.uflight.tl1.internal.TEMessageInfo;
import com.huawei.uflight.tl1.internal.TEMessageUnit;
import com.huawei.uflight.tl1.internal.TEProtocolAdapter;
import com.huawei.uflight.tl1.tl1adapter.TETL1NeMsg;
import com.huawei.uflight.tl1.tl1adapter.TETL1ProtocolAdapter;
import com.huawei.uflight.tl1.tl1adapter.TETL1ResponseMsg;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.LoggerFactory;

public class TETL1Message
extends TEMessage {
    private List<TETL1NeMsg> vctMsg = new ArrayList<TETL1NeMsg>();
    private TEMessageUnit msgUnit = null;
    private boolean clearFlag = true;

    public TETL1Message() {
        super(TETL1ProtocolAdapter.getInstance(), 1, 60, false);
    }

    public List<TETL1NeMsg> getMsgVect() {
        return this.vctMsg;
    }

    @Override
    public int handleMessage() {
        TEProtocolAdapter pProtocolAdapter = this.getProtocolAdapter();
        int tmpMType = this.getType();
        switch (tmpMType) {
            case 1: {
                return pProtocolAdapter.handleMessage(this);
            }
            case 2: {
                int ret = this.handleResponse();
                if (ret != 0) {
                    LoggerFactory.getLogger(this.getClass()).info("Handle TL1 response message error: %d ");
                }
                return ret;
            }
            case 3: {
                return this.handleReport();
            }
        }
        LoggerFactory.getLogger(this.getClass()).info(" Message type error is: " + tmpMType);
        return 98318;
    }

    @Override
    public TEMessageAdapter getMessageAdapter() {
        LoggerFactory.getLogger(this.getClass()).info("No GetMessageAdapter For TL1!");
        return null;
    }

    public TETL1NeMsg getNeMsg(long serial) {
        int size = this.vctMsg.size();
        for (int i = 0; i < size; ++i) {
            TETL1NeMsg msg = this.vctMsg.get(i);
            if (msg.getSerial() != serial) continue;
            return msg;
        }
        LoggerFactory.getLogger(this.getClass()).info("Can't find corresponding  reponse msg of ctag=" + serial);
        return null;
    }

    public void setFlag(boolean flag) {
        this.clearFlag = flag;
    }

    public boolean getFlag() {
        return this.clearFlag;
    }

    public void setTEMessageUnit(TEMessageUnit unit) {
        this.msgUnit = unit;
    }

    public void setMsgVect(List<TETL1NeMsg> vct, boolean flag) {
        if (this.clearFlag) {
            this.vctMsg.clear();
        }
        this.vctMsg = vct;
        this.clearFlag = flag;
    }

    private int handleResponse() {
        TEAdapterManager pAdapterManager = TEAdapterManager.getInstance();
        TEMessageInfo info = pAdapterManager.findSrcMsgInfo(this.msgUnit);
        if (null == info) {
            return 0;
        }
        int iResult = 0;
        info.sinkMessage = null;
        iResult = info.messageAdapter.handleResponse(this, info.srcMessage, info.pData, true);
        if (info.getSinkMessageCount() == 0) {
            pAdapterManager.eraseSrcInfoMap(this.msgUnit);
        }
        return iResult;
    }

    private int handleReport() {
        String strCmd;
        TETL1NeMsg pmsg = this.vctMsg.get(0);
        String[] strKey = new String[3];
        strKey[0] = strKey[2] = (strCmd = pmsg.getCmdCode());
        int num = pmsg.getModifierCount();
        for (int i = 0; i < num; ++i) {
            strKey[0] = strKey[0] + "-";
            strKey[0] = strKey[0] + pmsg.getModifier(i);
            if (0 != i) continue;
            strKey[1] = strKey[0];
        }
        TEMessageAdapter pMsgAdapter = null;
        for (int i = 0; i < 3 && null == (pMsgAdapter = TETL1ProtocolAdapter.getInstance().getMessageAdapter(strKey[i])); ++i) {
            LoggerFactory.getLogger(this.getClass()).info("No adapter for report message whose cmdcode is " + strKey[i] + "We'll find the next cmdcode=" + strKey[i + 1]);
        }
        if (null == pMsgAdapter) {
            LoggerFactory.getLogger(this.getClass()).info("No adapter for report message whose cmdcode is \"" + strKey[0] + "\"");
            return 0;
        }
        int ret = pMsgAdapter.handleReport(this);
        if (0 > ret) {
            LoggerFactory.getLogger(this.getClass()).info("Adapter handle report message error whose cmdcode is %s \n" + strKey[0]);
        }
        return ret;
    }

    public int getCommandCount() {
        return this.vctMsg.size();
    }

    public long getError() {
        int size = this.vctMsg.size();
        for (int i = 0; i < size; ++i) {
            TETL1ResponseMsg it = (TETL1ResponseMsg)this.vctMsg.get(i);
            int usResult = it.getCompleteCode();
            if (usResult == 0) continue;
            return usResult;
        }
        return 0L;
    }
}

