/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.tl1.tl1adapter;

import com.huawei.uflight.tl1.tl1adapter.TETL1Data;
import com.huawei.uflight.tl1.tl1adapter.TETL1ParamBlock;
import com.huawei.uflight.tl1.tl1adapter.TETL1ParseImplBase;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TETL1InputMsgParserImpl
extends TETL1ParseImplBase {
    private static final int MAX_TID_LENGTH = 20;
    private static final String INPUT_MSG_SEPARATOR = ":";
    private static Logger logger = LoggerFactory.getLogger(TETL1InputMsgParserImpl.class);

    @Override
    public boolean parse(byte[] tl1bytes, TETL1Data tl1Data) {
        throw new UnsupportedOperationException("not implement");
    }

    @Override
    public String toTL1String(TETL1Data tl1data) {
        StringBuilder strTL1 = new StringBuilder();
        String strValue = tl1data.getData(100);
        strTL1.append(strValue);
        for (int i = 1; i <= tl1data.getModifierCount(); ++i) {
            strTL1.append('-');
            strValue = tl1data.getData(200 + i);
            strTL1.append(strValue);
        }
        if (31 < strTL1.length()) {
            logger.error("The Command Code is too long,tid=" + strTL1);
            return null;
        }
        strTL1.append(INPUT_MSG_SEPARATOR);
        strValue = tl1data.getData(101);
        if (strValue.length() > 20) {
            logger.error("The tid is too long,tid=" + strValue);
            return null;
        }
        strTL1.append(strValue);
        strTL1.append(INPUT_MSG_SEPARATOR);
        strValue = tl1data.getData(102);
        strTL1.append(strValue);
        strTL1.append(INPUT_MSG_SEPARATOR);
        strValue = tl1data.getData(103);
        strTL1.append(strValue);
        String strParam = tl1data.getStrParamLine();
        List<List<TETL1ParamBlock>> params = tl1data.getParamLines();
        if (strParam != null || params.size() == 1 && params.get(0) != null) {
            strTL1.append(INPUT_MSG_SEPARATOR);
            strTL1.append(INPUT_MSG_SEPARATOR);
            if (strParam != null) {
                strTL1.append(strParam);
            } else {
                strTL1.append(this.generateParamLines(params));
            }
        }
        strTL1.append(";");
        if (strTL1.length() > 8192) {
            logger.error("The length of input message is too long,msg=" + strTL1);
            return null;
        }
        return strTL1.toString();
    }
}

