/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.tl1.tl1adapter;

import com.huawei.uflight.tl1.internal.SerialGenerator;
import com.huawei.uflight.tl1.tl1adapter.TETL1NameParamBlock;
import com.huawei.uflight.tl1.tl1adapter.TETL1NeMsg;
import com.huawei.uflight.tl1.tl1adapter.TETL1ParamBlock;
import com.huawei.uflight.tl1.tl1adapter.TETL1ParamLine;
import com.huawei.uflight.tl1.tl1adapter.TETL1PosParamBlock;
import org.slf4j.LoggerFactory;

public class TETL1InputMessage
extends TETL1NeMsg {
    public static final int AIDPARAM_LENGTH = 512;
    public static final int MAX_AIDPARAM = 2;
    private TETL1ParamLine paramLine = new TETL1ParamLine();
    private TETL1ParamBlock posAid;
    private TETL1ParamBlock nameAid;

    public TETL1InputMessage() {
        this.serial = SerialGenerator.assignSerial();
    }

    public boolean addAIDPosParam(String value) {
        if (value.length() > 512) {
            LoggerFactory.getLogger(this.getClass()).error("The length of aid parameter is too long\n");
            return false;
        }
        if (this.posAid == null) {
            this.posAid = new TETL1PosParamBlock();
        }
        if (this.posAid.count() == 2) {
            LoggerFactory.getLogger(this.getClass()).error("There are already two aid parameters\n");
            return false;
        }
        ((TETL1PosParamBlock)this.posAid).add(value);
        return true;
    }

    public boolean addAIDNameParam(String name, String value) {
        if (this.nameAid == null) {
            this.nameAid = new TETL1NameParamBlock();
        }
        if (this.nameAid.count() == 2) {
            LoggerFactory.getLogger(this.getClass()).error("There are already two aid parameters\n");
            return false;
        }
        if ("".equals(name)) {
            LoggerFactory.getLogger(this.getClass()).error("The name of parameter for aid is null when addAIDNameParam!\n");
            return false;
        }
        this.nameAid.setStrValue(name, value);
        return true;
    }

    public String getAid() {
        TETL1ParamBlock pAid = null;
        if (this.nameAid != null) {
            pAid = this.nameAid;
        } else if (this.posAid != null) {
            pAid = this.posAid;
        } else {
            return "";
        }
        return pAid.toString();
    }

    public boolean setAid(String strAid) {
        int pos = strAid.indexOf(61);
        TETL1ParamBlock pAid = null;
        if (pos != -1) {
            pAid = this.nameAid = new TETL1NameParamBlock();
        } else {
            if (this.posAid == null) {
                this.posAid = new TETL1PosParamBlock();
            }
            pAid = this.posAid;
        }
        return pAid.setStrParam(strAid);
    }

    public void addParamLine(String value) {
        this.paramLine.setStrParam(value);
    }

    public void clear() {
        if (this.nameAid != null) {
            this.nameAid.clear();
        }
        if (this.posAid != null) {
            this.posAid.clear();
        }
        this.paramLine.clear();
    }

    public TETL1ParamLine getParamLine() {
        return this.paramLine;
    }

    public void clearAID() {
        if (this.nameAid != null) {
            this.nameAid.clear();
        }
        if (this.posAid != null) {
            this.posAid.clear();
        }
    }
}

