/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.tl1.tl1adapter;

import com.huawei.uflight.necomm.IOStreamConvertor;
import org.slf4j.LoggerFactory;

public class TETL1FrameHead {
    private short version = (short)3;
    private short reserve = 0;
    private int length = 0;

    public int readFromStream(byte[] data) {
        if (data.length < 4) {
            LoggerFactory.getLogger(this.getClass()).info("The data received is too short!\n");
            return -2;
        }
        this.version = (short)IOStreamConvertor.readUnsignedByte(data[0]);
        this.reserve = (short)IOStreamConvertor.readUnsignedByte(data[1]);
        this.length = IOStreamConvertor.readUnsignedShort(data, 2);
        if (this.version != 3) {
            LoggerFactory.getLogger(this.getClass()).info("The TL1 data received is invalid !\n");
            return -1;
        }
        if (this.length < 4) {
            LoggerFactory.getLogger(this.getClass()).info("The TL1 message data received is too short !\n");
            return -3;
        }
        if (this.length > 16384) {
            LoggerFactory.getLogger(this.getClass()).info("The TL1 message data received is too long !\n");
            return -4;
        }
        if (this.length > data.length) {
            return -2;
        }
        return 0;
    }

    public byte[] getNetData() {
        byte[] frameHeadByte = new byte[4];
        int nOffset = 0;
        byte[] tmpByte = new byte[]{(byte)this.version};
        System.arraycopy(tmpByte, 0, frameHeadByte, nOffset, 1);
        tmpByte = new byte[]{(byte)this.reserve};
        System.arraycopy(tmpByte, 0, frameHeadByte, ++nOffset, 1);
        tmpByte = IOStreamConvertor.unsignedShort2Bytes(this.length);
        System.arraycopy(tmpByte, 0, frameHeadByte, ++nOffset, 2);
        return frameHeadByte;
    }

    public short getVersion() {
        return this.version;
    }

    public void setVersion(short version) {
        this.version = version;
    }

    public short getReserve() {
        return this.reserve;
    }

    public void setReserve(short reserve) {
        this.reserve = reserve;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }
}

