/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.tl1.tl1adapter;

import com.huawei.uflight.tl1.tl1adapter.TETL1ParamBlock;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TETL1Data {
    private Map<Integer, String> constData;
    private List<String> vctErr;
    private List<String> vctComment;
    private List<List<TETL1ParamBlock>> vctParamLine;
    private List<String> vctATAG;
    private int iKeepTime = 1800;
    private int usModifierCount = 0;
    private boolean bFull = false;
    private int ackCode = 5;
    private Date datetime = null;
    private long ctag = 0L;
    private int cmplCode = 5;
    private int alrmCode = 3;
    private String strParamLine;
    private int msgType = 4;
    private byte[] rawBytes = new byte[0];
    private static final int FRAME_KEEPALIVE = 1800;
    private static final int FRAME_KEEP_TIME_SLICE = 900;
    private int headerEndPos = -1;

    public TETL1Data() {
        this.constData = new HashMap<Integer, String>();
        this.vctParamLine = new ArrayList<List<TETL1ParamBlock>>();
        this.vctErr = new ArrayList<String>();
        this.vctComment = new ArrayList<String>();
        this.vctATAG = new ArrayList<String>();
    }

    public void setFull(boolean isFull) {
        this.bFull = isFull;
    }

    public boolean getFull() {
        return this.bFull;
    }

    public void addData(int key, String value) {
        this.constData.put(key, value);
        if (key == 103) {
            this.ctag = Long.parseLong(value);
        }
    }

    public String getData(int key) {
        String value = this.constData.get(key);
        return value == null ? "" : value;
    }

    public List<String> getErrVct() {
        return this.vctErr;
    }

    public List<String> getCommentVct() {
        return this.vctComment;
    }

    public List<String> getAtagVct() {
        return this.vctATAG;
    }

    public List<List<TETL1ParamBlock>> getParamLines() {
        return this.vctParamLine;
    }

    public synchronized void resetKeepTime() {
        this.iKeepTime = 1800;
    }

    public synchronized int decKeepTime() {
        this.iKeepTime -= 900;
        return this.iKeepTime;
    }

    public int getModifierCount() {
        return this.usModifierCount;
    }

    public void setModifierCount(int num) {
        this.usModifierCount = num;
    }

    public void clearParams() {
        this.vctParamLine.clear();
    }

    public void setDateTime(Date datetime) {
        this.datetime = datetime;
    }

    public Date getDateTime() {
        return this.datetime;
    }

    public int getMsgType() {
        return this.msgType;
    }

    public void setMsgType(int msgType) {
        this.msgType = msgType;
    }

    public String getStrParamLine() {
        return this.strParamLine;
    }

    public void setStrParamLine(String s) {
        this.strParamLine = s;
    }

    public void setAckCode(int code) {
        this.ackCode = code;
    }

    public int getAckCode() {
        return this.ackCode;
    }

    public void setCtag(long ctag) {
        this.ctag = ctag;
    }

    public long getCtag() {
        return this.ctag;
    }

    public void setAlrmCode(int a) {
        this.alrmCode = a;
    }

    public int getAlrmCode() {
        return this.alrmCode;
    }

    public void setCmplCode(int c) {
        this.cmplCode = c;
    }

    public int getCmplCode() {
        return this.cmplCode;
    }

    public byte[] getRawBytes() {
        return this.rawBytes;
    }

    public void setRawBytes(byte[] rawBytes) {
        byte[] tmparray = new byte[rawBytes.length];
        System.arraycopy(rawBytes, 0, tmparray, 0, tmparray.length);
        this.rawBytes = tmparray;
    }

    public String toString() {
        return new String(this.rawBytes);
    }

    public int getHeaderEndPos() {
        return this.headerEndPos;
    }

    public void setHeaderEndPos(int headerEndPos) {
        this.headerEndPos = headerEndPos;
    }

    public int getKeepTime() {
        return this.iKeepTime;
    }

    public void setKeepTime(int keepTime) {
        this.iKeepTime = keepTime;
    }

    public void appendTL1Data(TETL1Data tl1data) {
        if (tl1data.getCtag() != this.ctag) {
            throw new IllegalArgumentException("ctag not equal,can't merge tl1data.");
        }
        this.vctParamLine.addAll(tl1data.getParamLines());
        this.vctErr.addAll(tl1data.getErrVct());
        this.vctComment.addAll(tl1data.getCommentVct());
        this.cmplCode = tl1data.getCmplCode();
        this.bFull = tl1data.bFull;
        this.addRawBytes(tl1data.rawBytes);
    }

    public void addRawBytes(byte[] rawBytes) {
        byte[] tmparray = new byte[this.rawBytes.length + rawBytes.length];
        System.arraycopy(this.rawBytes, 0, tmparray, 0, this.rawBytes.length);
        System.arraycopy(rawBytes, 0, tmparray, this.rawBytes.length, rawBytes.length);
        this.rawBytes = tmparray;
    }
}

