/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.tl1.tl1adapter;

import com.huawei.uflight.tl1.tl1adapter.TETL1Data;
import com.huawei.uflight.tl1.tl1adapter.TETL1ParseImplBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TETL1AutoMsgParserImpl
extends TETL1ParseImplBase {
    private static final String[] ALRM_STR = new String[]{"*C", "**", "*", "A"};
    private static Logger logger = LoggerFactory.getLogger(TETL1AutoMsgParserImpl.class);

    @Override
    public boolean parse(byte[] tl1bytes, TETL1Data tl1Data) {
        if (!this.parseTerminator(tl1bytes, tl1Data)) {
            return false;
        }
        if (!this.parseHead(tl1bytes, tl1Data)) {
            return false;
        }
        String strTL1 = new String(tl1bytes);
        if (!(strTL1 = strTL1.substring(tl1Data.getHeaderEndPos() + 1, strTL1.length() - 3)).startsWith("\r\n")) {
            logger.error("The auto msg is invalid , msg=" + strTL1);
            return false;
        }
        boolean bHasTextBlock = true;
        int index = 2;
        int pEnd = strTL1.indexOf(13, index);
        String autoIDStr = null;
        if (pEnd == -1) {
            bHasTextBlock = false;
            pEnd = strTL1.length();
        }
        if (!this.parseAutoID(autoIDStr = strTL1.substring(0, pEnd), tl1Data)) {
            return false;
        }
        if (bHasTextBlock) {
            strTL1 = strTL1.substring(pEnd);
            return this.parseTextBlock(strTL1.getBytes(), tl1Data);
        }
        return true;
    }

    private boolean parseAutoID(String autoIDStr, TETL1Data tl1Data) {
        String atag;
        String tmpStr = autoIDStr.substring(2);
        String[] strVct = tmpStr.split(" ");
        if (strVct.length < 3 || strVct.length > 6) {
            logger.error("The auto msg is invalid , msg" + autoIDStr);
            return false;
        }
        int postion = 0;
        String alarmCode = strVct[postion];
        if (!this.parseAlmCode(alarmCode, tl1Data)) {
            return false;
        }
        if (2 == tl1Data.getAlrmCode() || 3 == tl1Data.getAlrmCode()) {
            ++postion;
        }
        if (!this.parseATag(atag = strVct[++postion], tl1Data)) {
            return false;
        }
        String[] cmdCodeArr = new String[strVct.length - postion - 1];
        System.arraycopy(strVct, postion + 1, cmdCodeArr, 0, cmdCodeArr.length);
        return this.parseCmdCode(cmdCodeArr, tl1Data);
    }

    private boolean parseAlmCode(String alarmCode, TETL1Data tl1Data) {
        if (ALRM_STR[0].equals(alarmCode)) {
            tl1Data.setAlrmCode(0);
        } else if (ALRM_STR[1].equals(alarmCode)) {
            tl1Data.setAlrmCode(1);
        } else if (ALRM_STR[2].equals(alarmCode)) {
            tl1Data.setAlrmCode(2);
        } else if (ALRM_STR[3].equals(alarmCode)) {
            tl1Data.setAlrmCode(3);
        } else {
            logger.error("The alarm code is invalid , alarmCode=" + alarmCode);
            return false;
        }
        return true;
    }

    private boolean parseATag(String atag, TETL1Data tl1Data) {
        if (atag.length() > 6) {
            logger.error("The length of atag is too long , atag=" + atag);
            return false;
        }
        int atagValue = -1;
        try {
            atagValue = Integer.parseInt(atag);
        }
        catch (NumberFormatException e) {
            logger.error("The atag is  invalid, atag=" + atag);
            return false;
        }
        if (0 > atagValue) {
            logger.error("The atag is  invalid, atag=" + atag);
            return false;
        }
        tl1Data.getAtagVct().add(atag);
        return true;
    }

    private boolean parseCmdCode(String[] cmdCodeArr, TETL1Data tl1Data) {
        StringBuilder cmdBuilder = new StringBuilder();
        String verb = cmdCodeArr[0];
        cmdBuilder.append(verb);
        if (verb.length() > 31) {
            logger.error("The length of verb is too long , verb=" + verb);
            return false;
        }
        tl1Data.addData(100, verb);
        for (int j = 1; j < cmdCodeArr.length; ++j) {
            String strmodifer = cmdCodeArr[j];
            if (strmodifer.length() > 31) {
                logger.error("The length of modifier is too long , modifier=" + strmodifer);
                return false;
            }
            tl1Data.addData(200 + j, strmodifer);
            cmdBuilder.append("-").append(strmodifer);
        }
        tl1Data.setModifierCount(cmdCodeArr.length - 1);
        tl1Data.addData(109, cmdBuilder.toString());
        return true;
    }

    @Override
    public String toTL1String(TETL1Data tl1Data) {
        throw new UnsupportedOperationException("doesnt implement");
    }
}

