/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.tl1.tl1adapter;

import com.huawei.uflight.tl1.tl1adapter.TETL1Data;
import com.huawei.uflight.tl1.tl1adapter.TETL1ParseImplBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TETL1AckParserImpl
extends TETL1ParseImplBase {
    private static Logger logger = LoggerFactory.getLogger(TETL1AckParserImpl.class);

    @Override
    public boolean parse(byte[] tl1bytes, TETL1Data tl1Data) {
        String strTL1 = new String(tl1bytes);
        if (!strTL1.endsWith("\r\n<")) {
            LoggerFactory.getLogger(this.getClass()).error("The ack msg is invalid,msg=" + strTL1);
            return false;
        }
        String[] strVct = (strTL1 = strTL1.substring(0, strTL1.length() - "\r\n<".length())).split(" ");
        if (strVct.length != 2) {
            logger.error("The ack msg is invalid,msg=" + strTL1);
            return false;
        }
        try {
            tl1Data.setCtag(Long.parseLong(strVct[1]));
        }
        catch (NumberFormatException e) {
            logger.error("The ctag in ack message is invalid,msg=" + strTL1);
            return false;
        }
        return this.parseAckCode(strVct[0], tl1Data);
    }

    private boolean parseAckCode(String ackcode, TETL1Data tl1Data) {
        if ("IP".equals(ackcode) || "PF".equals(ackcode)) {
            tl1Data.setAckCode(0);
            return true;
        }
        if ("OK".equals(ackcode)) {
            tl1Data.setAckCode(1);
            return true;
        }
        if ("NA".equals(ackcode)) {
            tl1Data.setAckCode(2);
            return true;
        }
        if ("NG".equals(ackcode)) {
            tl1Data.setAckCode(3);
            return true;
        }
        if ("RL".equals(ackcode)) {
            tl1Data.setAckCode(4);
            return true;
        }
        logger.error("The ack code is invalid,ackcode = " + ackcode);
        return false;
    }

    @Override
    public String toTL1String(TETL1Data tl1Data) {
        throw new UnsupportedOperationException("doesnt implement");
    }
}

