/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.tl1.internal;

import com.huawei.uflight.necomm.TEMessageBlock;
import com.huawei.uflight.necomm.TEThreadPool;
import com.huawei.uflight.tl1.NEStateNoticeHandle;
import com.huawei.uflight.tl1.OperationResult;
import com.huawei.uflight.tl1.TL1NoticeHandler;
import com.huawei.uflight.tl1.internal.TEAdapterManager;
import com.huawei.uflight.tl1.internal.TEFunInterfaceObject;
import com.huawei.uflight.tl1.internal.TEMessage;
import com.huawei.uflight.tl1.internal.TEMessageAdapter;
import com.huawei.uflight.tl1.internal.TETL1FunSrvObjectMessage;
import com.huawei.uflight.tl1.tl1adapter.TETL1ProtocolAdapter;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TETL1TaskManager {
    private static TETL1TaskManager taskManager = new TETL1TaskManager();
    private static Logger logger = LoggerFactory.getLogger(TETL1TaskManager.class);
    private Map<String, List<TL1NoticeHandler>> reportListenerMap = new HashMap<String, List<TL1NoticeHandler>>();
    private Map<String, TL1Operation> reportCmdIDToOperationMap = new HashMap<String, TL1Operation>();
    private Map<Long, List<NEStateNoticeHandle>> neStateMap = new HashMap<Long, List<NEStateNoticeHandle>>();
    private BlockingQueue<TEMessageBlock> responseQueue = new LinkedBlockingQueue<TEMessageBlock>();
    private BlockingQueue<TEMessageBlock> reportQueue = new LinkedBlockingQueue<TEMessageBlock>();
    private Thread responseProcessThread = null;
    private Thread reportProcessThread = null;
    private static TEThreadPool dispatchNEStatePool;

    public static TETL1TaskManager getInstance() {
        return taskManager;
    }

    private TETL1TaskManager() {
        this.init();
    }

    private void init() {
        this.responseProcessThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            TEMessageBlock msgBlock = (TEMessageBlock)TETL1TaskManager.this.responseQueue.take();
                            TEMessage tl1Msg = (TEMessage)msgBlock.getObj();
                            tl1Msg.handleMessage();
                        }
                    }
                    catch (Exception e) {
                        logger.error("Handle Response Message Error!", (Throwable)e);
                        continue;
                    }
                    break;
                }
            }
        });
        this.responseProcessThread.setName("responseThread1");
        this.reportProcessThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        TEMessageBlock msgBlock = (TEMessageBlock)TETL1TaskManager.this.reportQueue.take();
                        TEMessage tl1Msg = (TEMessage)msgBlock.getObj();
                        tl1Msg.handleMessage();
                        continue;
                    }
                    catch (Exception e) {
                        logger.error("Handle Report Message Error!", (Throwable)e);
                        continue;
                    }
                    break;
                }
            }
        });
        this.reportProcessThread.setName("reportThread1");
        this.responseProcessThread.start();
        this.reportProcessThread.start();
        dispatchNEStatePool = new TEThreadPool("TL1NEStatusDispatchThreadPool", 10);
    }

    public void putResponseQueue(TEMessageBlock tl1Msg) {
        this.responseQueue.add(tl1Msg);
    }

    public void putReportQueue(TEMessageBlock tl1Msg) {
        this.reportQueue.add(tl1Msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationResult sendMessage(TEFunInterfaceObject funInterObj) {
        if (funInterObj == null) {
            logger.warn("sendCommand(),the funInterObj is null.");
            return null;
        }
        TETL1FunSrvObjectMessage objMsg = new TETL1FunSrvObjectMessage(funInterObj);
        int ret = objMsg.sendMessage();
        if (funInterObj.msgType != 2) {
            TEFunInterfaceObject tEFunInterfaceObject = funInterObj;
            synchronized (tEFunInterfaceObject) {
                while (!funInterObj.messageInsignal) {
                    try {
                        LoggerFactory.getLogger(this.getClass()).info(Thread.currentThread().getName() + " wait at lock " + funInterObj);
                        funInterObj.wait((long)(funInterObj.timeOut + 2) * 1000L);
                        funInterObj.messageInsignal = true;
                    }
                    catch (InterruptedException e) {
                        LoggerFactory.getLogger(this.getClass()).error("TETL1TaskManager::OperationResult", (Throwable)e);
                    }
                }
            }
            ret = funInterObj.operResult.retCode;
        }
        logger.info(Thread.currentThread().getName() + " return operResult: " + ret);
        return new OperationResult(ret);
    }

    public void dispatchMessage(TETL1FunSrvObjectMessage rsp) {
        if (rsp.syncFlag == 1) {
            this.dispatchCommand(rsp);
        } else if (rsp.syncFlag == 3) {
            this.dispatchCommandAndCheck(rsp);
        } else {
            this.dispatchRequest(rsp);
        }
    }

    private void dispatchRequest(TETL1FunSrvObjectMessage rsp) {
        rsp.funInterfaceObject.handleResponse(rsp.funInterfaceObject.operationList, rsp.funInterfaceObject.operResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchCommand(TETL1FunSrvObjectMessage rsp) {
        TEFunInterfaceObject tEFunInterfaceObject = rsp.funInterfaceObject;
        synchronized (tEFunInterfaceObject) {
            rsp.funInterfaceObject.messageInsignal = true;
            rsp.funInterfaceObject.operResult = new OperationResult(0);
            logger.info(Thread.currentThread().getName() + " NotifyAll at lock " + rsp.funInterfaceObject);
            rsp.funInterfaceObject.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchCommandAndCheck(TETL1FunSrvObjectMessage rsp) {
        boolean dataValid = rsp.funInterfaceObject.checkDataValid(rsp.funInterfaceObject.operationList, rsp.funInterfaceObject.operResult);
        if (dataValid) {
            TEFunInterfaceObject tEFunInterfaceObject = rsp.funInterfaceObject;
            synchronized (tEFunInterfaceObject) {
                rsp.funInterfaceObject.messageInsignal = true;
                rsp.funInterfaceObject.operResult = new OperationResult(0);
                rsp.funInterfaceObject.handleResponse(rsp.funInterfaceObject.operationList, rsp.funInterfaceObject.operResult);
                logger.info(Thread.currentThread().getName() + " NotifyAll at lock " + rsp.funInterfaceObject);
                rsp.funInterfaceObject.notifyAll();
            }
        }
    }

    public void dispatchReportListener(long neID, TL1Operation oper) {
        String cmdKey = oper.getCmdKey();
        List<TL1NoticeHandler> listnerList = this.reportListenerMap.get(cmdKey);
        if (listnerList != null) {
            for (TL1NoticeHandler handler : listnerList) {
                handler.handleNotice(cmdKey, neID, oper);
            }
        }
    }

    public void registerListener(TL1Operation oper, TL1NoticeHandler handle) {
        String cmdKey = oper.getCmdKey();
        List<TL1NoticeHandler> listnerList = this.reportListenerMap.get(cmdKey);
        TETL1ProtocolAdapter.getInstance().addMsgAdapter(cmdKey, TEMessageAdapter.getInstance());
        if (listnerList != null) {
            listnerList.add(handle);
        } else {
            listnerList = new ArrayList<TL1NoticeHandler>();
            listnerList.add(handle);
            this.reportListenerMap.put(cmdKey, listnerList);
        }
        this.reportCmdIDToOperationMap.put(cmdKey, oper);
        logger.info("register report listener success, cmdKey=" + cmdKey + ",handle=" + handle);
    }

    public void registerNEStateListener(long neID, NEStateNoticeHandle rspHandler) {
        List<NEStateNoticeHandle> handleLst = this.neStateMap.get(neID);
        if (null == handleLst) {
            handleLst = new ArrayList<NEStateNoticeHandle>();
            this.neStateMap.put(neID, handleLst);
        }
        handleLst.add(rspHandler);
    }

    public void unregisterNEStateListener(long neID, NEStateNoticeHandle noticeHandle) {
        if (this.neStateMap.containsKey(neID)) {
            this.neStateMap.get(neID).remove(noticeHandle);
        }
    }

    public void unregisterNEStateListener(long neID) {
        if (this.neStateMap.containsKey(neID)) {
            this.neStateMap.remove(neID);
        }
    }

    public void dispatchNEState(final long neID, final boolean neConnectState) {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                int neState = 1;
                List handleLst = (List)TETL1TaskManager.this.neStateMap.get(neID);
                neState = neConnectState ? 1 : 0;
                if (handleLst != null) {
                    for (NEStateNoticeHandle handle : handleLst) {
                        handle.handleNoticeNeStateChange(neID, neState);
                    }
                }
            }
        };
        dispatchNEStatePool.runTask(task);
    }

    public void dispatchNELoginState(int neID, boolean neLoginState) {
        int neLogin = 1;
        List<NEStateNoticeHandle> rspHandler = this.neStateMap.get(neID);
        neLogin = neLoginState ? 1 : 0;
        if (rspHandler != null) {
            for (NEStateNoticeHandle handle : rspHandler) {
                handle.handleNoticeNeLoginChange(neID, neLogin);
            }
        }
    }

    public TL1Operation getReportOperation(String cmdCode) {
        TL1Operation oper = this.reportCmdIDToOperationMap.get(cmdCode);
        if (oper != null) {
            return (TL1Operation)oper.clone();
        }
        return null;
    }

    public void unRegisterListener(TL1Operation oper) {
        String cmdKey = oper.getCmdKey();
        this.reportListenerMap.remove(cmdKey);
        TETL1ProtocolAdapter.getInstance().removeMsgAdaper(cmdKey);
        this.reportCmdIDToOperationMap.remove(cmdKey);
        logger.info("unregister report listener success, cmdKey=" + cmdKey);
    }

    public void unRegisterListener(TL1Operation oper, TL1NoticeHandler handle) {
        String cmdKey = oper.getCmdKey();
        List<TL1NoticeHandler> listenList = this.reportListenerMap.get(cmdKey);
        if (handle == null || listenList == null) {
            TETL1ProtocolAdapter.getInstance().removeMsgAdaper(cmdKey);
            this.reportCmdIDToOperationMap.remove(cmdKey);
            logger.info("unregister report listener success, cmdKey=" + cmdKey + ",handle=" + handle);
            return;
        }
        listenList.remove(handle);
        if (listenList.isEmpty()) {
            TETL1ProtocolAdapter.getInstance().removeMsgAdaper(cmdKey);
            this.reportCmdIDToOperationMap.remove(cmdKey);
        }
        logger.info("unregister report listener success, cmdKey=" + cmdKey + ",handle=" + handle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleError(TEMessage pMessage, byte[] pUserData, int errCode) {
        logger.info("HandleError(), the errorCode is :" + errCode);
        if (!(pMessage instanceof TETL1FunSrvObjectMessage)) {
            return;
        }
        TETL1FunSrvObjectMessage rsp = (TETL1FunSrvObjectMessage)pMessage;
        if (rsp.syncFlag == 1) {
            TEFunInterfaceObject tEFunInterfaceObject = rsp.funInterfaceObject;
            synchronized (tEFunInterfaceObject) {
                rsp.funInterfaceObject.operationList = null;
                rsp.funInterfaceObject.operResult = new OperationResult(errCode);
                rsp.funInterfaceObject.messageInsignal = true;
                logger.info(Thread.currentThread().getName() + "NotifyAll at lock " + rsp.funInterfaceObject);
                rsp.funInterfaceObject.notifyAll();
            }
        } else if (rsp.syncFlag == 3) {
            TEFunInterfaceObject tEFunInterfaceObject = rsp.funInterfaceObject;
            synchronized (tEFunInterfaceObject) {
                rsp.funInterfaceObject.operResult = new OperationResult(errCode);
                rsp.funInterfaceObject.messageInsignal = true;
                logger.info(Thread.currentThread().getName() + "NotifyAll at lock " + rsp.funInterfaceObject);
                rsp.funInterfaceObject.notifyAll();
                rsp.funInterfaceObject.handleTimeout();
            }
        } else {
            rsp.funInterfaceObject.handleTimeout();
        }
        TEAdapterManager.getInstance().unRegisterSinkMessage(pMessage);
    }

    public String toString() {
        String linesep = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        sb.append("responseQueue size:");
        sb.append(this.responseQueue.size());
        sb.append(linesep);
        sb.append(this.responseQueue.toString());
        sb.append(linesep);
        sb.append("reportQueue size:");
        sb.append(this.reportQueue.size());
        sb.append(linesep);
        sb.append(this.reportQueue.toString());
        sb.append(linesep);
        sb.append("reportListenerMap size:");
        sb.append(this.reportListenerMap.size());
        sb.append(linesep);
        sb.append(this.reportListenerMap.toString());
        sb.append(linesep);
        sb.append("reportCmdIDToOperationMap size:");
        sb.append(this.reportCmdIDToOperationMap.size());
        sb.append(linesep);
        sb.append(this.reportCmdIDToOperationMap.toString());
        sb.append(linesep);
        sb.append("neStateMap size:");
        sb.append(this.neStateMap.size());
        sb.append(linesep);
        sb.append(this.neStateMap.toString());
        sb.append(linesep);
        return sb.toString();
    }
}

