/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.tl1.internal;

import com.huawei.uflight.necomm.TECommInfo;
import com.huawei.uflight.necomm.TECommunicationMgr;
import com.huawei.uflight.necomm.osgi.NECommActivator;
import com.huawei.uflight.tl1.TETL1NECommMgr;
import com.huawei.uflight.tl1.internal.TEAdapterManager;
import com.huawei.uflight.tl1.tl1adapter.TETL1NEInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TETL1CommuMgr {
    private static final int COMMUINFO_RECYCLE_INTERVAL = 30000;
    private static final int FRAME_RECYCLE_INTERVAL = 200000;
    private static TETL1CommuMgr instanceObj = new TETL1CommuMgr();
    private Timer frameRecycleTimer = null;
    private Timer commuInfoRecycleTimer = null;
    private static Logger logger = LoggerFactory.getLogger(TETL1CommuMgr.class);
    private Map<TETL1NEInfo, TECommInfo> neCommInfoMap = new Hashtable<TETL1NEInfo, TECommInfo>();
    private Map<Long, TETL1NEInfo> commNeMap = new Hashtable<Long, TETL1NEInfo>();
    private Map<TECommInfo, List<Long>> commInfoNeIDMap = new Hashtable<TECommInfo, List<Long>>();

    private TETL1CommuMgr() {
        this.init();
    }

    public static TETL1CommuMgr instance() {
        return instanceObj;
    }

    private void init() {
        this.frameRecycleTimer = new Timer();
        TETL1FrameRecycleTask recycleTask = new TETL1FrameRecycleTask();
        this.frameRecycleTimer.schedule((TimerTask)recycleTask, 200000L, 200000L);
        if (!NECommActivator.isIntegratedMode()) {
            this.commuInfoRecycleTimer = new Timer();
            TETL1CommuInfoRecycleTask linkTask = new TETL1CommuInfoRecycleTask();
            this.commuInfoRecycleTimer.schedule((TimerTask)linkTask, 30000L, 30000L);
        }
    }

    public int closeConnect(long neID, int port, String ipAddress, int commType) {
        logger.info("closeConnect NE ,neID = " + neID + "port = " + port + "ipAddress =" + ipAddress + "commType=" + commType);
        TETL1NEInfo neInfo = this.commNeMap.get(neID);
        if (null == neInfo) {
            logger.info("TETL1CommuMgr closeConnect: neInfo is not eixt.");
            return 0;
        }
        TECommInfo commInfo = this.neCommInfoMap.get(neInfo);
        if (commInfo == null) {
            logger.info("TETL1CommuMgr closeConnect: commInfo is not eixt.");
            return 0;
        }
        TECommunicationMgr.instance().close(commInfo, neInfo, true);
        this.unregisterTL1Commu(neID);
        return 0;
    }

    public int createConect(long neID, int port, String ipAddress, int commType, String baudrate) {
        TETL1NEInfo commNEInfo = this.commNeMap.get(neID);
        if (commNEInfo != null && commNEInfo.getConnectState() == 1) {
            logger.error("neID is exist ,neID = " + neID + "port = " + port + "ipAddress =" + ipAddress + "commType=" + commType);
            return 0;
        }
        String[][] serialParams = null;
        switch (commType) {
            case 1: {
                commType = 0;
                break;
            }
            case 2: {
                commType = 1;
                break;
            }
            case 3: {
                commType = 2;
                if (null == baudrate) break;
                serialParams = new String[][]{{"baudrate", String.valueOf(baudrate)}};
                break;
            }
            case 4: {
                commType = 4;
                break;
            }
            default: {
                logger.warn("The commType is invalidate,1:TCP  2:OSI  3:Serial  4:SSL,commType=" + commType);
            }
        }
        TECommInfo commInfo = new TECommInfo(commType, ipAddress, port, serialParams);
        TETL1NEInfo neInfo = new TETL1NEInfo(neID);
        this.registerTL1Commu(commInfo, neInfo);
        logger.info("Connect NE Start,neID = " + neID + "port = " + port + "ipAddress =" + ipAddress + "commType=" + commType);
        int result = TECommunicationMgr.instance().connect(commInfo, neInfo, TEAdapterManager.getInstance());
        if (result != 0) {
            logger.info("TETL1CommuMgr createConect: No Succeed, errCode = " + result);
        } else {
            logger.info("Connect NE Succeed. neid = " + neID);
            if (NECommActivator.isIntegratedMode()) {
                neInfo.connectStateChanged(0);
            }
        }
        return result;
    }

    public synchronized boolean refreshConnect(long neID, int port, String ipAddress, int commType) {
        LoggerFactory.getLogger(this.getClass()).info("refreshConnect, neID = " + neID, (Object)("port = " + port + "ipAddress =" + ipAddress + "commType=" + commType));
        this.closeConnect(neID, port, ipAddress, commType);
        int result = this.createConect(neID, port, ipAddress, commType, null);
        if (result != 0) {
            LoggerFactory.getLogger(this.getClass()).info("refreshConnect fail");
            return false;
        }
        return true;
    }

    public TETL1NEInfo getNEInfo(long ulGNeId) {
        TETL1NEInfo neInfo = this.commNeMap.get(ulGNeId);
        if (neInfo == null) {
            logger.info(" getNECommuInfo: No GateWay NE, ulGNeId=" + ulGNeId);
        }
        return neInfo;
    }

    public void updateNEInfo(long neID, TETL1NEInfo neInfo) {
        this.commNeMap.put(neID, neInfo);
    }

    public TECommInfo getNECommInfo(long ulNeID) {
        if (ulNeID <= 0L) {
            return null;
        }
        TETL1NEInfo neInfo = this.commNeMap.get(ulNeID);
        TECommInfo comInfo = this.neCommInfoMap.get(neInfo);
        return comInfo;
    }

    public int registerTL1Commu(TECommInfo commInfo, TETL1NEInfo neInfo) {
        if (this.neCommInfoMap.containsKey(neInfo)) {
            logger.info("TEQXCommuMgr registerNEInfo: CommInfo Is exit.");
            return 0;
        }
        neInfo.resetKeepTime();
        this.neCommInfoMap.put(neInfo, commInfo);
        this.commNeMap.put(neInfo.getNeID(), neInfo);
        List<Long> neIDLst = this.commInfoNeIDMap.get(commInfo);
        if (null == neIDLst) {
            neIDLst = new ArrayList<Long>();
            this.commInfoNeIDMap.put(commInfo, neIDLst);
        }
        if (!neIDLst.contains(neInfo.getNeID())) {
            neIDLst.add(neInfo.getNeID());
        }
        return 0;
    }

    public int unregisterTL1Commu(long neId) {
        TETL1NEInfo neInfo = this.commNeMap.get(neId);
        TECommInfo commInfo = this.neCommInfoMap.remove(neInfo);
        this.commNeMap.remove(neId);
        List<Long> neIDLst = this.commInfoNeIDMap.get(commInfo);
        if (null != neIDLst) {
            neIDLst.remove(neId);
        }
        return 0;
    }

    public int unregistConnectorReleated(TECommInfo commInfo) {
        for (Map.Entry<TETL1NEInfo, TECommInfo> entry : this.neCommInfoMap.entrySet()) {
            TECommInfo tmpcommInfo = entry.getValue();
            if (!commInfo.equals(tmpcommInfo)) continue;
            TETL1NEInfo neInfo = entry.getKey();
            this.neCommInfoMap.remove(neInfo);
            this.commNeMap.remove(neInfo.getNeID());
        }
        this.commInfoNeIDMap.remove(commInfo);
        return 0;
    }

    public void recycleFrameHandler() {
        Collection<TETL1NEInfo> neInfos = this.commNeMap.values();
        for (TETL1NEInfo neInfo : neInfos) {
            neInfo.refreshFrame();
        }
    }

    public void recycleCommuInfoHandler() {
        TETL1NEInfo.refreshNEInfo(this.neCommInfoMap);
    }

    public long getLogicNeID(TECommInfo commInfo, String neName) {
        List<Long> neIDLst = this.commInfoNeIDMap.get(commInfo);
        if (null == neIDLst) {
            logger.info("The commInfo not register , commInfo = " + commInfo);
            return -1L;
        }
        long gneID = -1L;
        for (long neID : neIDLst) {
            if (neName.equalsIgnoreCase(TETL1NECommMgr.getInstance().getTL1NEName(neID))) {
                return neID;
            }
            if (!"".equals(TETL1NECommMgr.getInstance().getTL1NEName(neID))) continue;
            gneID = neID;
        }
        return gneID;
    }

    class TETL1CommuInfoRecycleTask
    extends TimerTask {
        TETL1CommuInfoRecycleTask() {
        }

        @Override
        public void run() {
            TETL1CommuMgr.this.recycleCommuInfoHandler();
        }
    }

    class TETL1FrameRecycleTask
    extends TimerTask {
        TETL1FrameRecycleTask() {
        }

        @Override
        public void run() {
            TETL1CommuMgr.this.recycleFrameHandler();
        }
    }
}

