/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.tl1.internal;

import com.huawei.uflight.tl1.TETL1NECommMgr;
import com.huawei.uflight.tl1.internal.TEAdapterManager;
import com.huawei.uflight.tl1.internal.TEMessage;
import com.huawei.uflight.tl1.internal.TEMessageInfo;
import com.huawei.uflight.tl1.internal.TEMessageUnit;
import com.huawei.uflight.tl1.internal.TETL1FunSrvObjectMessage;
import com.huawei.uflight.tl1.internal.TETL1TaskManager;
import com.huawei.uflight.tl1.tl1adapter.TETL1CmdInfo;
import com.huawei.uflight.tl1.tl1adapter.TETL1InputMessage;
import com.huawei.uflight.tl1.tl1adapter.TETL1Message;
import com.huawei.uflight.tl1.tl1adapter.TETL1NameParamBlock;
import com.huawei.uflight.tl1.tl1adapter.TETL1NeMsg;
import com.huawei.uflight.tl1.tl1adapter.TETL1ParamBlock;
import com.huawei.uflight.tl1.tl1adapter.TETL1ParamLine;
import com.huawei.uflight.tl1.tl1adapter.TETL1PosParamBlock;
import com.huawei.uflight.tl1.tl1adapter.TETL1ProtocolAdapter;
import com.huawei.uflight.tl1.tl1adapter.TETL1ResponseMsg;
import com.huawei.uflight.tl1.tl1operation.DataBlock;
import com.huawei.uflight.tl1.tl1operation.Fault;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.MsgBlock;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.StagBlock;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import com.huawei.uflight.tl1.tl1operation.types.ParamType;
import com.huawei.uflight.util.SecurityUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TEMessageAdapter {
    private static TEMessageAdapter instance = new TEMessageAdapter();
    private static Logger logger = LoggerFactory.getLogger(TEMessageAdapter.class);

    private TEMessageAdapter() {
    }

    public static TEMessageAdapter getInstance() {
        return instance;
    }

    public int handleAsyncError(TEMessage pMessage, byte[] pUserData, int errCode) {
        TETL1TaskManager.getInstance().handleError(pMessage, pUserData, errCode);
        return 0;
    }

    public int sendMessage(TEMessage pMessage) {
        TETL1Message tl1Msg = new TETL1Message();
        TETL1FunSrvObjectMessage funMsg = (TETL1FunSrvObjectMessage)pMessage;
        List<TETL1CmdInfo> cmdInfoLst = this.convertOperationToTL1Cmd(funMsg);
        if (null == cmdInfoLst || cmdInfoLst.isEmpty()) {
            logger.warn("sendMessage() fail,no msg to send.");
            return 1;
        }
        ArrayList<TETL1NeMsg> inputMsgLst = new ArrayList<TETL1NeMsg>(cmdInfoLst.size());
        ArrayList<TETL1NeMsg> outputMsgLst = new ArrayList<TETL1NeMsg>(cmdInfoLst.size());
        for (TETL1CmdInfo cmdInfo : cmdInfoLst) {
            inputMsgLst.add(cmdInfo.getInputMsg());
            outputMsgLst.add(cmdInfo.getOutputMsg());
        }
        tl1Msg.setMsgVect(inputMsgLst, false);
        tl1Msg.setTimeOut(pMessage.getTimeOut());
        this.registerPrivateMessage(pMessage, this, null, tl1Msg.getTimeOut());
        this.registerMessage(pMessage, outputMsgLst);
        return tl1Msg.handleMessage();
    }

    private int registerPrivateMessage(TEMessage pMessag, TEMessageAdapter pMsgAdapter, byte[] pUserData, int nTimeOut) {
        return TEAdapterManager.getInstance().registerPrivateMessage(pMessag, pMsgAdapter, pUserData, nTimeOut);
    }

    private List<TETL1CmdInfo> convertOperationToTL1Cmd(TETL1FunSrvObjectMessage funsrvObject) {
        List<TL1Operation> operationList = funsrvObject.funInterfaceObject.operationList;
        if (operationList == null || operationList.isEmpty()) {
            logger.info("TEFunSrvDataTL1MessageAdapter convertOperationToTL1Cmd:No Data.");
            return null;
        }
        ArrayList<TETL1CmdInfo> cmdInfoLst = new ArrayList<TETL1CmdInfo>();
        int size = operationList.size();
        for (int i = 0; i < size; ++i) {
            TL1Operation curOper = operationList.get(i);
            cmdInfoLst.add(new TETL1CmdInfo(this.getInputInfo(funsrvObject.getNeId(), curOper), this.getOutputInfo(curOper)));
        }
        return cmdInfoLst;
    }

    private TETL1NeMsg getInputInfo(long neID, TL1Operation curOper) {
        TETL1InputMessage inputMsg = new TETL1InputMessage();
        inputMsg.setNEID(neID);
        inputMsg.setCmdCode(curOper.getCmdCode());
        inputMsg.appendModifier(curOper.getMod1());
        inputMsg.appendModifier(curOper.getMod2());
        InMsg inMsg = curOper.getInMsg();
        if (null != inMsg) {
            MsgBlock msgblock;
            StagBlock stagblock = inMsg.getStagBlock();
            if (stagblock != null) {
                Part[] partArray = inMsg.getStagBlock().getAID().getPart();
                for (int j = 0; j < partArray.length; ++j) {
                    Part part = partArray[j];
                    ParamType parttype = part.getParamType();
                    if (parttype.getType() == 0) {
                        inputMsg.addAIDPosParam(part.getValue());
                        continue;
                    }
                    inputMsg.addAIDNameParam(part.getName(), part.getValue());
                }
            }
            if ((msgblock = inMsg.getMsgBlock()) != null) {
                DataBlock[] datablockArray = inMsg.getMsgBlock().getDataBlock();
                this.fillParamLine(inputMsg, datablockArray);
            }
        }
        inputMsg.setMsgContent(TETL1ProtocolAdapter.getInstance().getTL1StringFromMsg(inputMsg));
        curOper.setCTag(inputMsg.getSerial());
        curOper.setCmdDetail(inputMsg.getMsgContent());
        if (TETL1NECommMgr.getInstance().getHandle() != null && TETL1NECommMgr.getInstance().getHandle().isFileterLog(curOper.getName())) {
            return inputMsg;
        }
        logger.info("inputMessage:" + inputMsg.getMsgContent());
        return inputMsg;
    }

    private TETL1NeMsg getOutputInfo(TL1Operation curOper) {
        TETL1ResponseMsg outputMsg = new TETL1ResponseMsg();
        outputMsg.setSerial(curOper.getCTag());
        outputMsg.setCmdCode(curOper.getCmdCode());
        outputMsg.appendModifier(curOper.getMod1());
        outputMsg.appendModifier(curOper.getMod2());
        OutMsg outMsg = curOper.getOutMsg(0);
        MsgBlock msgblock = outMsg.getMsgBlock();
        if (msgblock != null) {
            DataBlock[] datablockArray = msgblock.getDataBlock();
            ArrayList<String> posParamNameLst = new ArrayList<String>();
            StringBuilder posParamNameStr = new StringBuilder();
            for (DataBlock dataBlock : datablockArray) {
                posParamNameStr.setLength(0);
                if (0 == dataBlock.getParamType().getType()) {
                    for (Part part : dataBlock.getPart()) {
                        posParamNameStr.append(",").append(part.getName());
                    }
                }
                if (0 == posParamNameStr.length()) continue;
                posParamNameLst.add(posParamNameStr.toString().substring(1));
            }
            outputMsg.setPosParamVct(posParamNameLst);
        }
        return outputMsg;
    }

    private TETL1InputMessage fillParamLine(TETL1InputMessage inputMsg, DataBlock[] datablockArray) {
        TETL1ParamLine impl = inputMsg.getParamLine();
        for (int k = 0; k < datablockArray.length; ++k) {
            String value;
            Part part;
            int j;
            DataBlock datablock = datablockArray[k];
            if (datablock.getParamType() == null) continue;
            int dbblcokType = datablock.getParamType().getType();
            Part[] partArray = datablock.getPart();
            if (dbblcokType == 0) {
                impl.add(1, partArray.length);
                for (j = 0; j < partArray.length; ++j) {
                    part = partArray[j];
                    value = part.getEncryptflag() ? new String(SecurityUtil.decryptStrToByte((String)part.getValue())) : part.getValue();
                    if (value == null) {
                        value = "";
                    }
                    impl.setStrValue(j, value);
                }
                continue;
            }
            impl.add(0, 0);
            for (j = 0; j < partArray.length; ++j) {
                part = partArray[j];
                value = part.getEncryptflag() ? new String(SecurityUtil.decryptStrToByte((String)part.getValue())) : part.getValue();
                if (value == null) continue;
                impl.setStrValue(part.getName(), part.getValue());
            }
        }
        return inputMsg;
    }

    private int registerMessage(TEMessage pSource, List<TETL1NeMsg> outputMsgLst) {
        if (outputMsgLst.isEmpty()) {
            logger.info(" There is not any input msg! \n");
            return -1;
        }
        TEMessageUnit msgSrcUnit = new TEMessageUnit(pSource.getMessageSerial(), pSource.getProtocolAdapter().getType());
        TEMessageInfo pMsgInfo = null;
        TEMessageInfo msgInfo = TEAdapterManager.getInstance().findSrcMsgInfo(msgSrcUnit);
        if (null == msgInfo) {
            logger.info("msgSrcUnit: " + msgSrcUnit.msgSerial + ", Type: " + pSource.getProtocolAdapter().getType() + "qx5Cmd: " + "qx5Cmd.getCommandKey()");
            logger.info("Register null message adatper! qx5Cmd\u00a3\u00ba ");
            msgInfo = new TEMessageInfo();
            msgInfo.iTimeOut = pSource.getTimeOut();
            pMsgInfo = msgInfo;
            msgInfo.srcMessage = pSource;
            TEAdapterManager.getInstance().insertToSrcInfoMap(msgSrcUnit, msgInfo);
        } else {
            pMsgInfo = msgInfo;
        }
        if (pMsgInfo.sinkMessage == null) {
            pMsgInfo.sinkMessage = new TETL1Message();
            pMsgInfo.sinkMessage.setType(2);
        }
        TETL1Message pTL1Msg = (TETL1Message)pMsgInfo.sinkMessage;
        int size = outputMsgLst.size();
        for (int it = 0; it < size; ++it) {
            TETL1ResponseMsg curNeMsg = (TETL1ResponseMsg)outputMsgLst.get(it);
            TEMessageUnit msgSinkUnit = new TEMessageUnit(curNeMsg.getSerial(), 10);
            pMsgInfo.addSinkMessage(msgSinkUnit);
            TEAdapterManager.getInstance().insertToSinkUnitMap(msgSinkUnit, msgSrcUnit);
            TETL1ResponseMsg pNeMsg = new TETL1ResponseMsg();
            pNeMsg.setSerial(curNeMsg.getSerial());
            pNeMsg.setPosParamVct(curNeMsg.getPosParamVct());
            pNeMsg.setCmdCode(curNeMsg.getCmdCode());
            int count = curNeMsg.getModifierCount();
            for (int i = 0; i < count; ++i) {
                pNeMsg.appendModifier(curNeMsg.getModifier(i));
            }
            pTL1Msg.getMsgVect().add(pNeMsg);
        }
        return 0;
    }

    public int handleReport(TEMessage msg) {
        if (!(msg instanceof TETL1Message)) {
            logger.error("handleReport error, the message is invalidate.");
            return -1;
        }
        TETL1Message tl1msg = (TETL1Message)msg;
        List<TETL1NeMsg> msgList = tl1msg.getMsgVect();
        TETL1ResponseMsg rspMsg = (TETL1ResponseMsg)msgList.get(0);
        String cmdKey = rspMsg.getCmdKey();
        long neID = rspMsg.getNEID();
        TL1Operation oper = TETL1TaskManager.getInstance().getReportOperation(cmdKey);
        if (null == oper) {
            logger.info("The report message not register:" + cmdKey);
            return 0;
        }
        ArrayList<TL1Operation> operList = new ArrayList<TL1Operation>();
        operList.add(oper);
        this.fillReturnData(operList, rspMsg);
        TETL1TaskManager.getInstance().dispatchReportListener(neID, oper);
        return 0;
    }

    public int handleResponse(TEMessage rspResult, TEMessage rspSource, byte[] pData, boolean bLastFlag) {
        if (!(rspResult instanceof TETL1Message) || !(rspSource instanceof TETL1FunSrvObjectMessage)) {
            logger.error("handleResponse error, the message is invalidate.");
            return -1;
        }
        TETL1Message pResult = (TETL1Message)rspResult;
        TETL1FunSrvObjectMessage pSource = (TETL1FunSrvObjectMessage)rspSource;
        pSource.setResult(pResult.getError());
        List<TETL1NeMsg> cmdList = pResult.getMsgVect();
        List<TL1Operation> operationList = pSource.funInterfaceObject.operationList;
        if (operationList == null) {
            return 0;
        }
        int size = cmdList.size();
        for (int i = 0; i < size; ++i) {
            TETL1ResponseMsg rspMsg = (TETL1ResponseMsg)cmdList.get(i);
            this.fillReturnData(operationList, rspMsg);
        }
        TETL1TaskManager.getInstance().dispatchMessage(pSource);
        return 0;
    }

    private void fillReturnData(List<TL1Operation> operList, TETL1ResponseMsg rspMsg) {
        int size = operList.size();
        for (int i = 0; i < size; ++i) {
            TL1Operation curOper = operList.get(i);
            String cmdKey = rspMsg.getCmdKey();
            if (!curOper.getCmdKey().equals(cmdKey) || rspMsg.getType() != 2 && curOper.getCTag() != rspMsg.getSerial()) continue;
            curOper.setDate(rspMsg.getDate());
            curOper.setStrTL1Info(rspMsg.getMsgContent());
            curOper.setCommentList(rspMsg.getErrComments());
            this.fillOutMsg(curOper, rspMsg);
        }
    }

    private void fillOutMsg(TL1Operation oper, TETL1ResponseMsg rspMsg) {
        if (oper.getOutMsgCount() == 0) {
            logger.info("The operation is no outmsg description, the operation name is :" + oper.getName());
            return;
        }
        List<TETL1ParamLine> paramlines = rspMsg.getParamLines();
        if (null == paramlines || paramlines.isEmpty()) {
            if (rspMsg.getCompleteCode() == 0) {
                oper.clearOutMsg();
            } else {
                OutMsg outmsg = (OutMsg)oper.getOutMsg(0).clone();
                Fault fault = outmsg.getFault();
                this.fillFault(fault, rspMsg);
                oper.addOutMsg(outmsg);
            }
        } else {
            for (TETL1ParamLine paramline : paramlines) {
                OutMsg outmsg = (OutMsg)oper.getOutMsg(0).clone();
                MsgBlock msgBlock = outmsg.getMsgBlock();
                this.fillMsgBlock(msgBlock, paramline);
                Fault fault = outmsg.getFault();
                this.fillFault(fault, rspMsg);
                oper.addOutMsg(outmsg);
            }
        }
        if (oper.getOutMsgCount() == 0) {
            logger.info("oper.getOutputCount() is empty, the operation name is : " + oper.getName());
            return;
        }
        OutMsg delOutput = oper.getOutMsg(0);
        oper.removeOutMsg(delOutput);
    }

    private void fillFault(Fault fault, TETL1ResponseMsg rspMsg) {
        fault.setCompletionCode(rspMsg.getCompleteCode());
        String codeStr = "";
        String commentStr = "";
        if (rspMsg.getErrCodes().size() > 0) {
            codeStr = rspMsg.getErrCodes().get(0);
        }
        if (rspMsg.getErrComments().size() > 0) {
            commentStr = rspMsg.getErrComments().get(0);
        }
        fault.setErrCode(codeStr);
        fault.setErrDesc(commentStr);
    }

    private void fillMsgBlock(MsgBlock msgBlock, TETL1ParamLine paramline) {
        if (null == msgBlock) {
            logger.info("fillMsgBlock(), the msgBlock is null.");
            return;
        }
        List<TETL1ParamBlock> vctParamBlock = paramline.getParamBlockVct();
        if (null == vctParamBlock) {
            logger.info("fillMsgBlock(), the paramline is null.");
            return;
        }
        try {
            int size = vctParamBlock.size();
            for (int index = 0; index < size; ++index) {
                TETL1ParamBlock paramBlock = vctParamBlock.get(index);
                DataBlock datablock = msgBlock.getDataBlock(index);
                this.fillPartFromParamBlock(datablock, paramBlock);
            }
        }
        catch (Exception e) {
            logger.error("NE's response is inconsistent with that defined in the TL1 description file.Datas will be ignore.");
        }
    }

    private void fillPartFromParamBlock(DataBlock datablock, TETL1ParamBlock pblock) {
        int type = datablock.getParamType().getType();
        if (pblock instanceof TETL1PosParamBlock && type == 0) {
            this.fillPosDataBlock(datablock, pblock);
        } else if (pblock instanceof TETL1NameParamBlock && type == 1) {
            this.fillNameDataBlock(datablock, pblock);
        } else {
            logger.info("type not match,fillPartFromParamBlock failed." + datablock + "<-->" + pblock);
        }
    }

    private void fillPosDataBlock(DataBlock datablock, TETL1ParamBlock pblock) {
        Part[] parts = datablock.getPart();
        TETL1PosParamBlock paramblock = (TETL1PosParamBlock)pblock;
        List<String> allValueLst = paramblock.getAllParams();
        for (int i = 0; i < parts.length && i < allValueLst.size(); ++i) {
            if (parts[i].getEncryptflag()) {
                parts[i].setValue(SecurityUtil.encryptByteToStr((byte[])allValueLst.get(i).getBytes()));
                continue;
            }
            parts[i].setValue(allValueLst.get(i));
        }
    }

    private void fillNameDataBlock(DataBlock datablock, TETL1ParamBlock pblock) {
        Part[] parts = datablock.getPart();
        TETL1NameParamBlock paramblock = (TETL1NameParamBlock)pblock;
        Map<String, String> nameValueMap = paramblock.getAllParams();
        for (int i = 0; i < parts.length; ++i) {
            Part part = parts[i];
            String name = part.getName();
            String value = part.getEncryptflag() ? SecurityUtil.encryptByteToStr((byte[])nameValueMap.get(name).getBytes()) : nameValueMap.get(name);
            if (null == value) continue;
            part.setValue(value);
        }
    }
}

