/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.tl1.internal;

import com.huawei.uflight.necomm.IOStreamConvertor;
import com.huawei.uflight.necomm.TECommInfo;
import com.huawei.uflight.necomm.TEInputDataReceiver;
import com.huawei.uflight.tl1.internal.TEMessage;
import com.huawei.uflight.tl1.internal.TEMessageAdapter;
import com.huawei.uflight.tl1.internal.TEMessageInfo;
import com.huawei.uflight.tl1.internal.TEMessageUnit;
import com.huawei.uflight.tl1.tl1adapter.TETL1ProtocolAdapter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TEAdapterManager
implements TEInputDataReceiver {
    private static TEAdapterManager instance = new TEAdapterManager();
    private static Logger logger = LoggerFactory.getLogger(TEAdapterManager.class);
    private Map<TEMessageUnit, TEMessageUnit> sinkSrcMap = new HashMap<TEMessageUnit, TEMessageUnit>();
    private Map<TEMessageUnit, TEMessageInfo> srcMsgInfoMap = new HashMap<TEMessageUnit, TEMessageInfo>();
    private Timer messageTimer = null;
    private TimerTask messageTimerTask = new TimerTask(){

        @Override
        public void run() {
            TEAdapterManager.this.handleTimeOut();
        }
    };

    private TEAdapterManager() {
        this.init();
    }

    public void init() {
        this.messageTimer = new Timer();
        this.messageTimer.schedule(this.messageTimerTask, 5000L, 5000L);
    }

    public static TEAdapterManager getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int registerPrivateMessage(TEMessage pSource, TEMessageAdapter pMsgAdapter, byte[] pUserData, int nTimeOut) {
        TEMessageUnit msgSrcUnit = new TEMessageUnit(pSource.getMessageSerial(), pSource.getProtocolAdapter().getType());
        TEMessageInfo msgInfo = new TEMessageInfo(pSource, pMsgAdapter, null, nTimeOut);
        Map<TEMessageUnit, TEMessageInfo> map = this.srcMsgInfoMap;
        synchronized (map) {
            TEMessageInfo iter = this.srcMsgInfoMap.get(msgSrcUnit);
            if (iter != null) {
                if (null != pUserData) {
                    iter.setUserData(pUserData);
                }
                return 0;
            }
            msgInfo.srcMessage = pSource;
            msgInfo.pData = pUserData;
            this.srcMsgInfoMap.put(msgSrcUnit, msgInfo);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int registerMessage(TEMessage pSource, TEMessage pSink) {
        TEMessageUnit msgSrcUnit = new TEMessageUnit(pSource.getMessageSerial(), pSource.getProtocolAdapter().getType());
        TEMessageUnit msgSinkUnit = new TEMessageUnit(pSink.getMessageSerial(), pSink.getProtocolAdapter().getType());
        Map<TEMessageUnit, TEMessageInfo> map = this.srcMsgInfoMap;
        synchronized (map) {
            TEMessageInfo iter = this.srcMsgInfoMap.get(msgSrcUnit);
            if (iter == null) {
                LoggerFactory.getLogger(this.getClass()).info("Register null message adatper!");
                TEMessageInfo msgInfo = new TEMessageInfo();
                msgInfo.srcMessage = pSource;
                msgInfo.iTimeOut = pSource.getTimeOut();
                msgInfo.addSinkMessage(msgSinkUnit);
                this.srcMsgInfoMap.put(msgSrcUnit, msgInfo);
            } else {
                iter.addSinkMessage(msgSinkUnit);
            }
            this.sinkSrcMap.put(msgSinkUnit, msgSrcUnit);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int unRegisterSourceMessage(TEMessage pSource) {
        TEMessageUnit msgSrcUnit = new TEMessageUnit(pSource.getMessageSerial(), pSource.getProtocolAdapter().getType());
        Map<TEMessageUnit, TEMessageInfo> map = this.srcMsgInfoMap;
        synchronized (map) {
            TEMessageInfo msgInfo = this.srcMsgInfoMap.get(msgSrcUnit);
            if (msgInfo == null) {
                logger.info("TEAdapterManager::UnRegisterSourceMessage, not found source message in map.\n");
                return 0;
            }
            int size = msgInfo.getSinkMessageCount();
            for (int i = 0; i < size; ++i) {
                TEMessageUnit messageUnitSink = msgInfo.getSinkMsgUnit(i);
                this.sinkSrcMap.remove(this.sinkSrcMap.get(messageUnitSink));
            }
            this.srcMsgInfoMap.remove(msgSrcUnit);
            logger.info("unRegister serial: " + msgSrcUnit.msgSerial);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int unRegisterSinkMessage(TEMessage pSinkMsg) {
        TEMessageUnit msgSinkUnit = new TEMessageUnit(pSinkMsg.getMessageSerial(), pSinkMsg.getProtocolAdapter().getType());
        TEMessageUnit msgIter = this.sinkSrcMap.get(msgSinkUnit);
        if (msgIter == null) {
            logger.info("TEAdapterManager::UnRegisterSinkMessage, not found sink message in map table.\n");
            return 0;
        }
        Map<TEMessageUnit, TEMessageInfo> map = this.srcMsgInfoMap;
        synchronized (map) {
            TEMessageInfo infoIter = this.srcMsgInfoMap.get(msgIter);
            if (infoIter != null) {
                infoIter.deleteSinkMessage(msgSinkUnit);
            } else {
                logger.info("TEAdapterManager::UnRegisterSinkMessage, not found sink message in source.\n");
            }
        }
        this.sinkSrcMap.remove(msgSinkUnit);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TEMessageUnit findSrcMsgUnit(TEMessageUnit sinkMsgUnit) {
        Map<TEMessageUnit, TEMessageUnit> map = this.sinkSrcMap;
        synchronized (map) {
            return this.sinkSrcMap.get(sinkMsgUnit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TEMessageInfo findSrcMsgInfo(TEMessageUnit srcMsgUnit) {
        Map<TEMessageUnit, TEMessageInfo> map = this.srcMsgInfoMap;
        synchronized (map) {
            return this.srcMsgInfoMap.get(srcMsgUnit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eraseSinkUnitMap(TEMessageUnit sinkMsgUnit) {
        Map<TEMessageUnit, TEMessageUnit> map = this.sinkSrcMap;
        synchronized (map) {
            this.sinkSrcMap.remove(sinkMsgUnit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eraseSrcInfoMap(TEMessageUnit srcMsgUnit) {
        Map<TEMessageUnit, TEMessageInfo> map = this.srcMsgInfoMap;
        synchronized (map) {
            this.srcMsgInfoMap.remove(srcMsgUnit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertToSrcInfoMap(TEMessageUnit srcMsgUnit, TEMessageInfo srcMsgInfo) {
        Map<TEMessageUnit, TEMessageInfo> map = this.srcMsgInfoMap;
        synchronized (map) {
            this.srcMsgInfoMap.put(srcMsgUnit, srcMsgInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertToSinkUnitMap(TEMessageUnit sinkMsgUnit, TEMessageUnit srcMsgUnit) {
        Map<TEMessageUnit, TEMessageUnit> map = this.sinkSrcMap;
        synchronized (map) {
            this.sinkSrcMap.put(sinkMsgUnit, srcMsgUnit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTimeOut() {
        Map<TEMessageUnit, TEMessageInfo> map = this.srcMsgInfoMap;
        synchronized (map) {
            HashMap messageInfoMap = (HashMap)((HashMap)this.srcMsgInfoMap).clone();
            Set entries = messageInfoMap.entrySet();
            for (Map.Entry entry : entries) {
                TEMessageInfo info = (TEMessageInfo)entry.getValue();
                TEMessageUnit srcUnit = (TEMessageUnit)entry.getKey();
                TEMessage pSrcMessage = info.srcMessage;
                if (null == pSrcMessage) {
                    logger.info("TEAdapterManager HandleTimeOut: Warning, Pointer is NULL! \n ");
                    continue;
                }
                if (info.iTimeOut < 0) {
                    logger.info("TEAdapterManager HandleTimeOut: Del msg.");
                    int size = info.getSinkMessageCount();
                    for (int i = 0; i < size; ++i) {
                        this.sinkSrcMap.remove(info.getSinkMsgUnit(i));
                    }
                    TEMessageAdapter pMessageAdapter = info.messageAdapter;
                    byte[] pUserData = info.pData;
                    this.srcMsgInfoMap.remove(srcUnit);
                    if (pMessageAdapter == null) {
                        logger.info("handle timeout Remove serial: " + srcUnit.msgSerial);
                        pMessageAdapter = TEMessageAdapter.getInstance();
                    }
                    pMessageAdapter.handleAsyncError(pSrcMessage, pUserData, 1090650120);
                }
                info.iTimeOut -= 5;
            }
        }
    }

    @Override
    public int checkMessageValid(byte[] data, int offset, int size, TECommInfo commInfo) {
        return TETL1ProtocolAdapter.getInstance().checkMessageValid(data, offset, size, commInfo);
    }

    @Override
    public int getMaxPacketLength() {
        return 16384;
    }

    @Override
    public int getHeadLength() {
        return 4;
    }

    @Override
    public int getFrameLength(byte[] buffer) {
        return IOStreamConvertor.readUnsignedShort(buffer, 2) - 4;
    }
}

