/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.tl1;

import com.huawei.uflight.tl1.ICallBackHandle;
import com.huawei.uflight.tl1.NEStateNoticeHandle;
import com.huawei.uflight.tl1.OperationResult;
import com.huawei.uflight.tl1.ResponseHandler;
import com.huawei.uflight.tl1.TL1NoticeHandler;
import com.huawei.uflight.tl1.internal.TEFunInterfaceObject;
import com.huawei.uflight.tl1.internal.TETL1CommuMgr;
import com.huawei.uflight.tl1.internal.TETL1TaskManager;
import com.huawei.uflight.tl1.tl1adapter.TETL1NEInfo;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.LoggerFactory;

public final class TETL1NECommMgr {
    private static TETL1NECommMgr instance = new TETL1NECommMgr();
    private Map<Long, String> logicNEIDNameMap = new HashMap<Long, String>();
    private ICallBackHandle chandle = null;
    private Map<String, String> neNameNewToOldMap = new HashMap<String, String>();

    private TETL1NECommMgr() {
    }

    public static TETL1NECommMgr getInstance() {
        return instance;
    }

    public void registerCallHandle(ICallBackHandle handle) {
        this.chandle = handle;
    }

    public ICallBackHandle getHandle() {
        return this.chandle;
    }

    public OperationResult sendMessage(int neID, List<TL1Operation> operationList, ResponseHandler handler, int timeOut) {
        TEFunInterfaceObject funObj = new TEFunInterfaceObject(neID, handler, operationList, timeOut);
        TETL1NEInfo neInfo = TETL1CommuMgr.instance().getNEInfo(neID);
        if (neInfo != null && neInfo.getConnectState() == 1) {
            funObj.msgType = (byte)2;
            return TETL1TaskManager.getInstance().sendMessage(funObj);
        }
        LoggerFactory.getLogger(this.getClass()).warn("The neid(neid=" + neID + ") not register or ne status is abort.");
        OperationResult operResult = new OperationResult(1090617361, "");
        return operResult;
    }

    public OperationResult sendCommand(int neID, List<TL1Operation> operList, int timeOut) {
        return this.sendCommand(neID, operList, null, timeOut);
    }

    public OperationResult sendCommand(int neID, List<TL1Operation> operList, ResponseHandler rspHandler, int timeOut) {
        TEFunInterfaceObject funObj = new TEFunInterfaceObject(neID, rspHandler, operList, timeOut);
        TETL1NEInfo neInfo = TETL1CommuMgr.instance().getNEInfo(neID);
        funObj.msgType = null == rspHandler ? (byte)1 : (byte)3;
        if (neInfo != null && neInfo.getConnectState() == 1) {
            return TETL1TaskManager.getInstance().sendMessage(funObj);
        }
        LoggerFactory.getLogger(this.getClass()).warn("The neid(neid=" + neID + ") not register or ne status is abort.");
        OperationResult operResult = new OperationResult(1090617361, "");
        return operResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putLogicNEIDName(long logicNEID, String neName) {
        if (null == neName) {
            neName = "";
        }
        Map<Long, String> map = this.logicNEIDNameMap;
        synchronized (map) {
            this.logicNEIDNameMap.put(logicNEID, neName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTL1NEName(long logicNEID) {
        String neName = null;
        Map<Long, String> map = this.logicNEIDNameMap;
        synchronized (map) {
            neName = this.logicNEIDNameMap.get(logicNEID);
        }
        if (neName == null) {
            LoggerFactory.getLogger(this.getClass()).info("logicNEID not register, logicNEID = " + logicNEID);
        }
        return neName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTL1NEID(long logicNEID) {
        Map<Long, String> map = this.logicNEIDNameMap;
        synchronized (map) {
            this.logicNEIDNameMap.remove(logicNEID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLogicNEID(String neName) {
        if (null == neName) {
            neName = "";
        }
        Map<Long, String> map = this.logicNEIDNameMap;
        synchronized (map) {
            for (Map.Entry<Long, String> entry : this.logicNEIDNameMap.entrySet()) {
                if (!neName.equals(entry.getValue())) continue;
                return entry.getKey().intValue();
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLogicReportNEID(String neName) {
        Map<Long, String> map = this.logicNEIDNameMap;
        synchronized (map) {
            for (Map.Entry<Long, String> entry : this.logicNEIDNameMap.entrySet()) {
                if (!neName.equalsIgnoreCase(entry.getValue())) continue;
                return entry.getKey().intValue();
            }
        }
        return -1L;
    }

    public int createConect(long neID, int port, String ipAddress, int commType) {
        return this.createConect(neID, port, ipAddress, commType, null);
    }

    public int createConect(long neID, int port, String ipAddress, int commType, String baudrate) {
        return TETL1CommuMgr.instance().createConect(neID, port, ipAddress, commType, baudrate);
    }

    public int closeConnect(long neID, int port, String ipAddress, int commType) {
        return TETL1CommuMgr.instance().closeConnect(neID, port, ipAddress, commType);
    }

    public boolean refreshConnect(long neID, int port, String ipAddress, int commType) {
        return TETL1CommuMgr.instance().refreshConnect(neID, port, ipAddress, commType);
    }

    public void registerListener(TL1Operation oper, TL1NoticeHandler rspHandler) {
        TETL1TaskManager.getInstance().registerListener(oper, rspHandler);
    }

    public void unregisterListener(TL1Operation oper) {
        TETL1TaskManager.getInstance().unRegisterListener(oper);
    }

    public void unregisterListener(TL1Operation oper, TL1NoticeHandler rspHandler) {
        TETL1TaskManager.getInstance().unRegisterListener(oper, rspHandler);
    }

    public void registerNEStateListener(long neID, NEStateNoticeHandle rspHandler) {
        TETL1TaskManager.getInstance().registerNEStateListener(neID, rspHandler);
    }

    public void unregisterNEStateListener(long neID, NEStateNoticeHandle noticeHandle) {
        TETL1TaskManager.getInstance().unregisterNEStateListener(neID, noticeHandle);
    }

    public void unregisterNEStateListener(long neID) {
        TETL1TaskManager.getInstance().unregisterNEStateListener(neID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putNENameNewToOldMap(String newNeName, String oldNeName) {
        if (null == newNeName || "".equals(newNeName.trim())) {
            LoggerFactory.getLogger(this.getClass()).info("putNENameNewToOldMap(), newNeName is null or empty");
            throw new IllegalArgumentException("newNeName should not be null or empty");
        }
        if (null == oldNeName || "".equals(oldNeName.trim())) {
            LoggerFactory.getLogger(this.getClass()).info("putNENameNewToOldMap(), oldNeName is null or empty");
            throw new IllegalArgumentException("oldNeName should not be null or empty");
        }
        Map<String, String> map = this.neNameNewToOldMap;
        synchronized (map) {
            this.neNameNewToOldMap.put(newNeName, oldNeName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getOldNENameByNew(String newNeName) {
        String oldName = null;
        Map<String, String> map = this.neNameNewToOldMap;
        synchronized (map) {
            oldName = this.neNameNewToOldMap.get(newNeName);
        }
        if (oldName == null) {
            LoggerFactory.getLogger(this.getClass()).info("getOldNENameByNew(), from neNameNewToOldMap value\u00a3\u00baoldNeName=null,by key:newNeName = " + newNeName);
        }
        return oldName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteNENameNewToOld(String newNeName) {
        Map<String, String> map = this.neNameNewToOldMap;
        synchronized (map) {
            this.neNameNewToOldMap.remove(newNeName);
        }
    }
}

