/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.qxprotocol.qx5adapter;

import com.huawei.uflight.necomm.IOStreamConvertor;
import org.slf4j.LoggerFactory;

public class TEQxPacketHead {
    public long ulDstAddr = 0L;
    public long ulSrcAddr = 0L;
    public int nType = 0;
    public int nLen = 0;
    public long ulReserved = 0L;

    public void init() {
        this.ulDstAddr = 0L;
        this.ulSrcAddr = 0L;
        this.nType = 0;
        this.nLen = 0;
        this.ulReserved = 0L;
    }

    public void fillPacketHead(long DstAddr, int Type2) {
        this.ulDstAddr = DstAddr;
        this.nType = Type2;
        this.nLen = 0;
        this.ulReserved = 0L;
    }

    public int readFromStream(byte[] bufVec) {
        if (bufVec.length < this.getQxPacketHeadSize()) {
            LoggerFactory.getLogger(this.getClass()).info(" data not enough long ! \n");
            return -2;
        }
        this.ulDstAddr = IOStreamConvertor.readUnsignedInt(bufVec, 0);
        this.ulSrcAddr = IOStreamConvertor.readUnsignedInt(bufVec, 4);
        this.nType = IOStreamConvertor.readUnsignedShort(bufVec, 8);
        this.nLen = IOStreamConvertor.readUnsignedShort(bufVec, 10);
        this.ulReserved = IOStreamConvertor.readUnsignedInt(bufVec, 12);
        return 0;
    }

    public byte[] getPacketHead() {
        byte[] packetHeadByte = new byte[16];
        int nOffset = 0;
        byte[] tmpByte = IOStreamConvertor.int2Bytes((int)this.ulDstAddr);
        System.arraycopy(tmpByte, 0, packetHeadByte, nOffset, 4);
        tmpByte = IOStreamConvertor.int2Bytes((int)this.ulSrcAddr);
        System.arraycopy(tmpByte, 0, packetHeadByte, nOffset += 4, 4);
        tmpByte = IOStreamConvertor.unsignedShort2Bytes(this.nType);
        System.arraycopy(tmpByte, 0, packetHeadByte, nOffset += 4, 2);
        tmpByte = IOStreamConvertor.unsignedShort2Bytes(this.nLen);
        System.arraycopy(tmpByte, 0, packetHeadByte, nOffset += 2, 2);
        tmpByte = IOStreamConvertor.int2Bytes((int)this.ulReserved);
        System.arraycopy(tmpByte, 0, packetHeadByte, nOffset += 2, 4);
        return packetHeadByte;
    }

    public int getQxPacketHeadSize() {
        return 16;
    }

    public static void main(String[] args) {
        TEQxPacketHead packetHead = new TEQxPacketHead();
        byte[] bufVec = new byte[]{-127, 9, 16, 18, -1, -1, -1, -1, 0, 2, 0, 3, 0, 0, 0, 4};
        packetHead.readFromStream(bufVec);
    }
}

