/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.qxprotocol.qx5adapter;

import com.huawei.uflight.necomm.IOStreamConvertor;

public class TEQxFrameHead {
    public volatile short byAckFlag = 0;
    public volatile short byFrameType = 0;
    public volatile int nPacketSerial = 0;
    public volatile short byFrameSerial = 0;
    public volatile short byFrameNum = 0;
    public volatile int nDataLen = 0;
    public volatile int nCheckSum = 0;

    public void init() {
        this.byAckFlag = 0;
        this.byFrameType = 0;
        this.nPacketSerial = 0;
        this.byFrameSerial = 0;
        this.byFrameNum = 0;
        this.nDataLen = 0;
        this.nCheckSum = 0;
    }

    public int readFromStream(byte[] bufVec) {
        int usSize = 0;
        if (null == bufVec || bufVec.length == 0) {
            return usSize;
        }
        usSize = bufVec.length > this.getTypeSize() ? this.getTypeSize() : bufVec.length;
        this.byAckFlag = (short)IOStreamConvertor.readUnsignedByte(bufVec[0]);
        this.byFrameType = (short)IOStreamConvertor.readUnsignedByte(bufVec[1]);
        this.nPacketSerial = IOStreamConvertor.readUnsignedShort(bufVec, 2);
        if (usSize == 10) {
            this.byFrameSerial = (short)IOStreamConvertor.readUnsignedByte(bufVec[4]);
            this.byFrameNum = (short)IOStreamConvertor.readUnsignedByte(bufVec[5]);
            this.nDataLen = IOStreamConvertor.readUnsignedShort(bufVec, 6);
            this.nCheckSum = IOStreamConvertor.readUnsignedShort(bufVec, 8);
        } else {
            this.byFrameSerial = 0;
            this.byFrameNum = 0;
            this.nDataLen = 0;
            this.nCheckSum = 0;
        }
        return 0;
    }

    public byte[] getFrameHead() {
        byte[] frameHeadByte = new byte[10];
        int nOffset = 0;
        byte[] tmpByte = new byte[]{(byte)this.byAckFlag};
        System.arraycopy(tmpByte, 0, frameHeadByte, nOffset, 1);
        tmpByte = new byte[]{(byte)this.byFrameType};
        System.arraycopy(tmpByte, 0, frameHeadByte, ++nOffset, 1);
        tmpByte = IOStreamConvertor.unsignedShort2Bytes(this.nPacketSerial);
        System.arraycopy(tmpByte, 0, frameHeadByte, ++nOffset, 2);
        tmpByte = new byte[]{(byte)this.byFrameSerial};
        System.arraycopy(tmpByte, 0, frameHeadByte, nOffset += 2, 1);
        tmpByte = new byte[]{(byte)this.byFrameNum};
        System.arraycopy(tmpByte, 0, frameHeadByte, ++nOffset, 1);
        tmpByte = IOStreamConvertor.unsignedShort2Bytes(this.nDataLen);
        System.arraycopy(tmpByte, 0, frameHeadByte, ++nOffset, 2);
        tmpByte = IOStreamConvertor.unsignedShort2Bytes(this.nCheckSum);
        System.arraycopy(tmpByte, 0, frameHeadByte, nOffset += 2, 2);
        return frameHeadByte;
    }

    public int getTypeSize() {
        return 10;
    }
}

