/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.qxprotocol.qx5adapter;

import com.huawei.uflight.necomm.IOStreamConvertor;
import com.huawei.uflight.necomm.TECommInfo;
import com.huawei.uflight.necomm.TECommunicationMgr;
import com.huawei.uflight.necomm.TEMessageBlock;
import com.huawei.uflight.necomm.osgi.NECommActivator;
import com.huawei.uflight.qxprotocol.QxNEConnectInfo;
import com.huawei.uflight.qxprotocol.SPacketWithHandle;
import com.huawei.uflight.qxprotocol.TEAdapterManager;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.TENEInfo;
import com.huawei.uflight.qxprotocol.TETaskManager;
import com.huawei.uflight.qxprotocol.qx5adapter.TEQx5Command;
import com.huawei.uflight.qxprotocol.qx5adapter.TEQx5Message;
import com.huawei.uflight.qxprotocol.qx5adapter.TEQxFrameHead;
import com.huawei.uflight.qxprotocol.qx5adapter.TEQxPacket;
import com.huawei.uflight.qxprotocol.qx5adapter.TEQxPacketHead;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.LoggerFactory;

public class TEQxCommuMgr {
    private static TEQxCommuMgr pInstance;
    private Map<TENEInfo, TECommInfo> neCommuInfoMap = new ConcurrentHashMap<TENEInfo, TECommInfo>();
    private Map<Long, TENEInfo> neInfoMap = new ConcurrentHashMap<Long, TENEInfo>();
    private Map<Integer, Integer> packSerialMap = new HashMap<Integer, Integer>();
    private ConcurrentMap<TECommInfo, PORT_STATUS> neCommPortStatus = new ConcurrentHashMap<TECommInfo, PORT_STATUS>();
    private Map packetMap = new ConcurrentHashMap();
    private int usPacketSerial = 0;
    private Timer pRecycleTimer = null;
    private Timer pLinkTimer = null;
    private Timer frameHandlerTimer = null;
    public static final int QX_RECYCLE_INTERVAL = 36000;
    public static final int QXFRAME_KEEP_TIME_SLICE = 900000;
    public static final int QX_LINK_INTERVAL = 60000;
    public static final int QX_LOGIN_NORMAL = 24833;
    public static final int QX_LOGIN_FORCE = 24834;
    public static final int QX4_DCN_CHECK = 64989;

    public void sendCommandFrame(TENEInfo handle, TEQxPacketHead packetHead, TEQxFrameHead frameHead, int ucMode) {
        TEQxFrameHead ackFameHead = frameHead;
        TEQxPacketHead ackPacketHead = packetHead;
        byte[] dataByte = new byte[packetHead.getQxPacketHeadSize() + frameHead.getTypeSize()];
        ackPacketHead = packetHead;
        ackPacketHead.ulDstAddr = packetHead.ulSrcAddr;
        ackPacketHead.ulSrcAddr = 0L;
        ackPacketHead.nLen = frameHead.getTypeSize();
        int nOffset = 0;
        System.arraycopy(IOStreamConvertor.int2Bytes((int)ackPacketHead.ulDstAddr), 0, dataByte, nOffset, 4);
        System.arraycopy(IOStreamConvertor.int2Bytes((int)ackPacketHead.ulSrcAddr), 0, dataByte, nOffset += 4, 4);
        System.arraycopy(IOStreamConvertor.unsignedShort2Bytes(ackPacketHead.nType), 0, dataByte, nOffset += 4, 2);
        System.arraycopy(IOStreamConvertor.unsignedShort2Bytes(ackPacketHead.nLen), 0, dataByte, nOffset += 2, 2);
        System.arraycopy(IOStreamConvertor.int2Bytes((int)ackPacketHead.ulReserved), 0, dataByte, nOffset += 2, 4);
        ackFameHead.byAckFlag = 0;
        ackFameHead.byFrameType = (short)ucMode;
        ackFameHead.nPacketSerial = frameHead.nPacketSerial;
        System.arraycopy(new byte[]{(byte)ackFameHead.byAckFlag}, 0, dataByte, nOffset += 4, 1);
        System.arraycopy(new byte[]{(byte)ackFameHead.byFrameType}, 0, dataByte, ++nOffset, 1);
        System.arraycopy(IOStreamConvertor.unsignedShort2Bytes(ackFameHead.nPacketSerial), 0, dataByte, ++nOffset, 2);
        System.arraycopy(new byte[]{(byte)ackFameHead.byFrameSerial}, 0, dataByte, nOffset += 2, 1);
        System.arraycopy(new byte[]{(byte)ackFameHead.byFrameNum}, 0, dataByte, ++nOffset, 1);
        System.arraycopy(IOStreamConvertor.unsignedShort2Bytes(ackFameHead.nDataLen), 0, dataByte, ++nOffset, 2);
        System.arraycopy(IOStreamConvertor.unsignedShort2Bytes(ackFameHead.nCheckSum), 0, dataByte, nOffset += 2, 2);
        nOffset += 2;
        String str = IOStreamConvertor.getStringFromByteArray(dataByte);
        LoggerFactory.getLogger(this.getClass()).info("TEQxCommuMgr sendCommandFrame: send ack data and req data.");
        LoggerFactory.getLogger(this.getClass()).info(str);
        TECommunicationMgr.instance().sendUrgent(handle.commInfo, dataByte, ackFameHead.getTypeSize() + ackPacketHead.getQxPacketHeadSize());
    }

    private void init() {
        this.usPacketSerial = 0;
        this.pRecycleTimer = new Timer();
        RecycleTask recycleTask = new RecycleTask();
        this.pRecycleTimer.schedule((TimerTask)recycleTask, 36000L, 36000L);
        if (!NECommActivator.isIntegratedMode()) {
            this.pLinkTimer = new Timer();
            LinkTimerTask linkTask = new LinkTimerTask();
            this.pLinkTimer.schedule((TimerTask)linkTask, 60000L, 60000L);
        }
        this.frameHandlerTimer = new Timer();
        TEQxFrameHandleTimerTask frameTask = new TEQxFrameHandleTimerTask();
        this.frameHandlerTimer.schedule((TimerTask)frameTask, 900000L, 900000L);
        this.neCommuInfoMap.clear();
        this.neInfoMap.clear();
    }

    private TEQxCommuMgr() {
        this.init();
    }

    public static synchronized TEQxCommuMgr instance() {
        if (pInstance == null) {
            pInstance = new TEQxCommuMgr();
        }
        return pInstance;
    }

    public int checkMessageValid(byte[] bufVec, int offset, long size) {
        TEQxPacketHead packetHead = new TEQxPacketHead();
        int packetHeadLength = packetHead.getQxPacketHeadSize();
        if (size <= (long)packetHeadLength) {
            LoggerFactory.getLogger(this.getClass()).info("MESSAGE_LENGTH_LESS: packetHeadLength= " + packetHeadLength + ",offset: " + offset + ",size: " + size);
            return -2;
        }
        packetHead.init();
        int iRet = packetHead.readFromStream(bufVec);
        if (iRet != 0) {
            LoggerFactory.getLogger(this.getClass()).info("TEQxCommuMgr checkMessageValid: Get packet head error :" + iRet);
            return -2;
        }
        long neId = packetHead.ulSrcAddr;
        int usPacketLen = packetHeadLength + packetHead.nLen;
        if (usPacketLen > 934) {
            LoggerFactory.getLogger(this.getClass()).info(" TEQxCommuMgr checkMessageValid: Packet data exceed: " + usPacketLen);
            return -1;
        }
        if ((long)offset + size < (long)usPacketLen) {
            return -2;
        }
        if (!this.checkReportCmdCode(bufVec, size)) {
            LoggerFactory.getLogger(TEQxCommuMgr.class).info("TEQxCommuMgr checkMessageValid: cmdCode isn't registered, PacketLen = " + usPacketLen);
            return usPacketLen;
        }
        int bufsize = usPacketLen < bufVec.length ? usPacketLen : bufVec.length;
        byte[] dataByte = new byte[bufsize];
        System.arraycopy(bufVec, 0, dataByte, 0, bufsize);
        String logCmdStr = IOStreamConvertor.getStringFromByteArray(dataByte);
        if (dataByte[9] == 1 || dataByte[9] == 2 || dataByte[9] == 4 || usPacketLen == 20) {
            LoggerFactory.getLogger(this.getClass()).info("TEQxCommuMgr checkMessageValid: NM Recycle,NE Recycle,NMID Resend");
            LoggerFactory.getLogger(this.getClass()).info(logCmdStr);
        } else {
            LoggerFactory.getLogger(this.getClass()).info("TEQxCommuMgr checkMessageValid: data frame");
            LoggerFactory.getLogger(this.getClass()).info("RecvQxData,data size is" + dataByte.length);
        }
        TEQxPacket packet = new TEQxPacket();
        if (packet.readFromStream(dataByte) < 0) {
            LoggerFactory.getLogger(this.getClass()).info("TEQxCommuMgr checkMessageValid:  Packet error!");
            return -2;
        }
        byte[] msgVec = this.unwrapMessage(packet);
        if (msgVec == null) {
            LoggerFactory.getLogger(TEQxCommuMgr.class).info("TEQxCommuMgr checkMessageValid: finish wraping message, but not have message frame.");
        }
        if (msgVec != null && msgVec.length > 0 && msgVec[0] == 5) {
            if (msgVec.length > 10 && IOStreamConvertor.readUnsignedShort(msgVec, 8) == 64989) {
                this.handleQueryVersion((int)neId, msgVec);
                return usPacketLen;
            }
            TEQx5Message pmsg = new TEQx5Message(false);
            pmsg.setNEID(neId);
            int ret = -1;
            try {
                ret = pmsg.initMessage(msgVec);
            }
            catch (Exception e) {
                return -1;
            }
            if (this.isWriteLog(pmsg.getQx5CommandList())) {
                LoggerFactory.getLogger(this.getClass()).info("RecvData is" + logCmdStr);
            }
            if (1 == ret) {
                return usPacketLen;
            }
            if (-98284 == ret) {
                LoggerFactory.getLogger(this.getClass()).info("TEQxCommuMgr checkMessageValid: Qx message inner parameter is wrong.");
            } else {
                if (pmsg.getType() != 3) {
                    TEMessageBlock msgBlock = new TEMessageBlock(pmsg);
                    TETaskManager.instance().enResponseQueue(msgBlock);
                    return usPacketLen;
                }
                List<TEQx5Command> cmds = pmsg.getQx5CommandList();
                if (!cmds.isEmpty() && cmds.get(0).getReportMessageAdapter() != null) {
                    TEMessageBlock msgBlock = new TEMessageBlock(pmsg);
                    TETaskManager.instance().enReportQueue(msgBlock);
                } else {
                    LoggerFactory.getLogger(this.getClass()).info("message isn't registered in list, will not put in quene");
                }
                return usPacketLen;
            }
        }
        LoggerFactory.getLogger(this.getClass()).info("TEQxCommuMgr checkMessageValid: Get Data Length " + usPacketLen);
        return usPacketLen;
    }

    private boolean checkReportCmdCode(byte[] bufVec, long datasize) {
        if (datasize >= 26L) {
            int packSerial = IOStreamConvertor.readUnsignedShort(bufVec, 18);
            short frameSerial = (short)IOStreamConvertor.readUnsignedByte(bufVec[20]);
            short frameNum = (short)IOStreamConvertor.readUnsignedByte(bufVec[21]);
            int cmdCodeOffset = 36;
            if (frameSerial == 0 && bufVec.length > cmdCodeOffset + 2) {
                int cmdCode = IOStreamConvertor.readUnsignedShort(bufVec, cmdCodeOffset);
                if (TEQx5Command.isReportCommand(cmdCode) && 28497 != cmdCode && !TETaskManager.instance().isCmdKeyRegregisted(cmdCode)) {
                    if (frameNum > 1) {
                        this.packSerialMap.put(packSerial, 1);
                    }
                    LoggerFactory.getLogger(TEQxCommuMgr.class).info("TEQxCommuMgr checkMessageValid: cmdKey isn't registered, cmdKey = " + cmdCode + ", packSerial = " + packSerial);
                    return false;
                }
                if (this.packSerialMap.containsKey(packSerial)) {
                    this.packSerialMap.remove(packSerial);
                }
            }
            if (frameSerial > 0 && this.packSerialMap.containsKey(packSerial)) {
                int recievedFrameCount = this.packSerialMap.get(packSerial);
                this.packSerialMap.put(packSerial, ++recievedFrameCount);
                LoggerFactory.getLogger(TEQxCommuMgr.class).info("TEQxCommuMgr checkMessageValid: frameSerial has been removed, packSerial = " + packSerial + ", frameSerial = " + frameSerial + ", frameNum = " + frameNum);
                if (recievedFrameCount == frameNum) {
                    LoggerFactory.getLogger(TEQxCommuMgr.class).info("TEQxCommuMgr checkMessageValid: packSerial has been removed, packSerial = " + packSerial + ", frameSerial = " + frameSerial + ", frameNum = " + frameNum);
                    this.packSerialMap.remove(packSerial);
                }
                return false;
            }
        }
        return true;
    }

    private void handleQueryVersion(int phneid, byte[] msgVec) {
        int neId = TENECommMgr.getInstance().getLogicNEID(phneid);
        TENEInfo neInfo = this.neInfoMap.get(neId);
        long ulNeVersion = IOStreamConvertor.readUnsignedInt(msgVec, 0);
        neInfo.setNEVersion(ulNeVersion);
        TEQx5Message pmsg = new TEQx5Message(false);
        TEQx5Command pCmd = new TEQx5Command(2);
        long serial = IOStreamConvertor.readUnsignedInt(msgVec, 4);
        pCmd.setSerial(serial);
        pCmd.setAckMode(0);
        pCmd.setCommandKey(64989);
        pCmd.setExecResult(37916);
        pCmd.setResultData(16, 2, msgVec);
        pmsg.handleResponse(ulNeVersion, phneid, pCmd);
    }

    boolean isWriteLog(List<TEQx5Command> qxCmdList) {
        HashSet<Integer> filterSet = TENECommMgr.getInstance().getFilterLogCmds();
        for (TEQx5Command qxCmd : qxCmdList) {
            if (!filterSet.contains(qxCmd.getCommandKey())) continue;
            return false;
        }
        return true;
    }

    public synchronized long requireSerial() {
        long ulSerial = 0L;
        if (this.usPacketSerial == 65535) {
            this.usPacketSerial = 0;
        }
        ulSerial = this.usPacketSerial++;
        return ulSerial;
    }

    public int calCheckSum(byte[] data, int nOffset, int nDataLen) {
        int usSum = 0;
        int beginIndex = nOffset;
        int endIndex = nOffset + nDataLen;
        if (beginIndex >= endIndex) {
            LoggerFactory.getLogger(this.getClass()).error("calCheckSum fault, nOffset is " + nOffset + ",nDataLen is " + nDataLen);
            return usSum;
        }
        int dataNum = 0;
        for (int i = beginIndex; i < endIndex; ++i) {
            dataNum = IOStreamConvertor.readUnsignedByte(data[i]);
            usSum += dataNum;
        }
        return usSum;
    }

    public int sendMessage(TENEInfo handle, byte[] pBuf, long ulDataLen, boolean isWriteLog) {
        long ulNeId = handle.iNeId;
        TECommInfo commInfo = this.getCommInfo(ulNeId);
        int ucPacketNum = 0;
        int ulDataOffset = 0;
        int ulMsgOffset = 0;
        int usLastPacketLen = 0;
        TEQxPacketHead packetHead = new TEQxPacketHead();
        TEQxFrameHead frameHead = new TEQxFrameHead();
        packetHead.init();
        frameHead.init();
        int maxFrameSize = 908;
        usLastPacketLen = (int)ulDataLen % maxFrameSize;
        if (ulDataLen / (long)maxFrameSize > 255L) {
            LoggerFactory.getLogger(this.getClass()).info("TEQxCommuMgr SendMessage Qx packet overflow, length : " + ulDataLen);
            return -5;
        }
        ucPacketNum = (int)ulDataLen / maxFrameSize + (usLastPacketLen > 0 ? 1 : 0);
        ulNeId = TENECommMgr.getInstance().getNEID((int)ulNeId);
        packetHead.fillPacketHead(ulNeId, 0);
        frameHead.byAckFlag = (short)255;
        frameHead.byFrameType = 0;
        frameHead.byFrameSerial = 0;
        frameHead.byFrameNum = (short)ucPacketNum;
        frameHead.nCheckSum = 0;
        frameHead.nDataLen = 908;
        long packetSerial = this.requireSerial();
        frameHead.nPacketSerial = (int)packetSerial;
        packetHead.nLen = 908 + frameHead.getTypeSize();
        long totalLen = (long)(ucPacketNum * (packetHead.getQxPacketHeadSize() + frameHead.getTypeSize())) + ulDataLen;
        byte[] msgVec = new byte[(int)totalLen];
        for (int i = 0; i < ucPacketNum; ++i) {
            int usFrameLen = 908;
            if (i == ucPacketNum - 1 && usLastPacketLen != 0) {
                packetHead.nLen = usLastPacketLen + frameHead.getTypeSize();
                frameHead.nDataLen = usLastPacketLen;
                usFrameLen = usLastPacketLen;
            }
            frameHead.byFrameSerial = (short)i;
            TECommInfo cfr_ignored_0 = handle.commInfo;
            if (commInfo.getCommType() == 2) {
                int usCheckSum;
                frameHead.nCheckSum = usCheckSum = this.calCheckSum(pBuf, ulDataOffset, usFrameLen);
            }
            int headSize = packetHead.getQxPacketHeadSize();
            System.arraycopy(packetHead.getPacketHead(), 0, msgVec, ulMsgOffset, headSize);
            ulMsgOffset += headSize;
            headSize = frameHead.getTypeSize();
            System.arraycopy(frameHead.getFrameHead(), 0, msgVec, ulMsgOffset, headSize);
            System.arraycopy(pBuf, ulDataOffset, msgVec, ulMsgOffset += headSize, usFrameLen);
            ulMsgOffset += usFrameLen;
            ulDataOffset += usFrameLen;
        }
        int ret = 0;
        long neVersion = IOStreamConvertor.readUnsignedInt(pBuf, 0);
        if (neVersion == 0x4010000L) {
            this.sendLoginMessage(handle, commInfo, msgVec, frameHead.byFrameSerial);
        } else {
            if (isWriteLog) {
                String str = IOStreamConvertor.getStringFromByteArray(msgVec);
                LoggerFactory.getLogger(this.getClass()).info("TEQxCommuMgr SendMessage Send Qx5 Command Start:");
                LoggerFactory.getLogger(this.getClass()).info(str);
                LoggerFactory.getLogger(this.getClass()).info("TEQxCommuMgr SendMessage Send Qx5 Command End.");
            } else {
                LoggerFactory.getLogger(this.getClass()).info("Send Qx5 Command,neid is " + handle.iNeId + " nephy id is " + ulNeId);
            }
            ret = TECommunicationMgr.instance().sendUrgent(commInfo, msgVec, msgVec.length);
            if (ret < 0) {
                LoggerFactory.getLogger(this.getClass()).info("TEQxCommuMgr SendMessage\u00a3\u00ba Data not put in comm queue.");
            }
            SPacketWithHandle PacketData = new SPacketWithHandle();
            PacketData.handle = handle;
            PacketData.msg = msgVec;
            this.addQxPacket(frameHead.nPacketSerial, PacketData);
        }
        return ret;
    }

    private void sendLoginMessage(TENEInfo handle, TECommInfo commInfo, byte[] msgVec, int packetSerial) {
        String str = IOStreamConvertor.getStringFromByteArray(msgVec);
        LoggerFactory.getLogger(this.getClass()).info("start send qx4 command To query neVersion");
        int nOffset = 0;
        byte[] msgQ4Vec = new byte[65];
        System.arraycopy(msgVec, 0, msgQ4Vec, nOffset, 10);
        int paraLen = 49;
        byte[] tmpByte = IOStreamConvertor.unsignedShort2Bytes(paraLen);
        System.arraycopy(tmpByte, 0, msgQ4Vec, nOffset += 10, 2);
        int reserved = 0;
        tmpByte = IOStreamConvertor.int2Bytes(reserved);
        System.arraycopy(tmpByte, 0, msgQ4Vec, nOffset += 2, 4);
        tmpByte = new byte[]{0, 0};
        System.arraycopy(tmpByte, 0, msgQ4Vec, nOffset += 4, 2);
        System.arraycopy(msgVec, 18, msgQ4Vec, nOffset += 2, 4);
        tmpByte = new byte[]{0, 39};
        System.arraycopy(tmpByte, 0, msgQ4Vec, nOffset += 4, 2);
        tmpByte = new byte[]{0, 0};
        System.arraycopy(tmpByte, 0, msgQ4Vec, nOffset += 2, 2);
        tmpByte = new byte[]{4, 1, 0, 0};
        System.arraycopy(tmpByte, 0, msgQ4Vec, nOffset += 2, 4);
        System.arraycopy(msgVec, 30, msgQ4Vec, nOffset += 4, 4);
        tmpByte = new byte[]{-3, -35, -52, -52, -1, -1, -1, -1, 0, 1, 0, 0, 4};
        System.arraycopy(tmpByte, 0, msgQ4Vec, nOffset += 4, 13);
        tmpByte = new byte[]{0, 0, 0, 0, 0};
        System.arraycopy(tmpByte, 0, msgQ4Vec, nOffset += 13, 5);
        tmpByte = new byte[]{0};
        System.arraycopy(tmpByte, 0, msgQ4Vec, nOffset += 5, 1);
        if (2 == commInfo.getCommType()) {
            tmpByte = new byte[39];
            System.arraycopy(msgQ4Vec, 26, tmpByte, 0, 39);
            int num = this.calCheckSum(tmpByte, 0, tmpByte.length);
            tmpByte = IOStreamConvertor.unsignedShort2Bytes(num);
            System.arraycopy(tmpByte, 0, msgQ4Vec, 24, 2);
        }
        str = IOStreamConvertor.getStringFromByteArray(msgQ4Vec);
        LoggerFactory.getLogger(this.getClass()).info("TEQxCommuMgr sendLoginMessage:Send QX4 login CommandData Start:");
        LoggerFactory.getLogger(this.getClass()).info(str);
        LoggerFactory.getLogger(this.getClass()).info("TEQxCommuMgr sendLoginMessage:Send QX4 login CommandData End.");
        int ret = TECommunicationMgr.instance().sendUrgent(commInfo, msgQ4Vec, msgQ4Vec.length);
        if (ret > 0) {
            LoggerFactory.getLogger(this.getClass()).info("TEQxCommuMgr sendLoginMessage\u00a3\u00baQX4 login CommandData not put in comm queue.");
        }
        SPacketWithHandle PacketData = new SPacketWithHandle();
        PacketData.handle = handle;
        PacketData.msg = msgQ4Vec;
        this.addQxPacket(packetSerial, PacketData);
    }

    public boolean canSendMessage(TENEInfo neInfo) {
        if (neInfo.isSuccToApplyNMID()) {
            return true;
        }
        TECommInfo commInfo = this.neCommuInfoMap.get(neInfo);
        if (null == commInfo) {
            LoggerFactory.getLogger(this.getClass()).info("TEQxCommuMgr canSendMessage: NE OF GENE is not exit! neid = " + neInfo.iNeId);
            return false;
        }
        neInfo.applyNMIDPacket();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            LoggerFactory.getLogger(this.getClass()).info("canSendMessage fail", (Throwable)e);
        }
        return PORT_STATUS.APPLYEND.equals(this.neCommPortStatus.get(commInfo));
    }

    public void setNeCommPortStatus(TENEInfo neInfo, PORT_STATUS status) {
        TECommInfo info = this.neCommuInfoMap.get(neInfo);
        if (info != null) {
            this.neCommPortStatus.put(info, status);
        }
    }

    public PORT_STATUS getNeCommPortStatus(TENEInfo neInfo) {
        TECommInfo info = this.neCommuInfoMap.get(neInfo);
        if (info != null) {
            return (PORT_STATUS)((Object)this.neCommPortStatus.get(info));
        }
        return null;
    }

    public ConcurrentMap<TECommInfo, PORT_STATUS> getCommPortMaps() {
        return this.neCommPortStatus;
    }

    private byte[] unwrapMessage(TEQxPacket packet) {
        long srcNeId = packet.packetHead.ulSrcAddr;
        int neID = TENECommMgr.getInstance().getLogicNEID((int)srcNeId);
        LoggerFactory.getLogger(this.getClass()).info("phy neId is" + srcNeId + " ,logic NEID is" + neID);
        TENEInfo itNeInfo = this.neInfoMap.get(neID);
        if (itNeInfo == null) {
            itNeInfo = new TENEInfo(neID, null);
            this.neInfoMap.put(Long.valueOf(neID), itNeInfo);
            LoggerFactory.getLogger(this.getClass()).info("TEQxCommuMgr unwrapMessage: sendNMIDPacket");
            LoggerFactory.getLogger(this.getClass()).info("TEQxCommuMgr UnwrapMessage,Ne  CommuInfo not exist! " + packet.packetHead.ulSrcAddr);
        }
        byte[] msgVec = itNeInfo.handleQxPacket(packet);
        return msgVec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addQxPacket(int serial, SPacketWithHandle data) {
        Map map = this.packetMap;
        synchronized (map) {
            this.packetMap.put(serial, data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletePacket(int serial) {
        Map map = this.packetMap;
        synchronized (map) {
            this.packetMap.remove(serial);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resendPacket(int serial) {
        SPacketWithHandle packHandle = null;
        Map map = this.packetMap;
        synchronized (map) {
            packHandle = (SPacketWithHandle)this.packetMap.get(serial);
        }
        if (null != packHandle) {
            String str = IOStreamConvertor.getStringFromByteArray(packHandle.msg);
            LoggerFactory.getLogger(this.getClass()).info("TEQxCommuMgr resendPacket\u00a3\u00ba");
            LoggerFactory.getLogger(this.getClass()).info(str);
            TECommunicationMgr.instance().sendUrgent(packHandle.handle.commInfo, packHandle.msg, packHandle.msg.length);
        }
    }

    private synchronized int createConect(TENEInfo neInfo, TECommInfo commInfo) {
        if (!this.neCommPortStatus.containsKey(commInfo)) {
            this.neCommPortStatus.put(commInfo, PORT_STATUS.UN_APPLY);
        }
        this.registerCommu(commInfo, neInfo);
        this.registerNEInfo(neInfo);
        LoggerFactory.getLogger(this.getClass()).info("TEQxCommuMgr createConect: Connect NE Start:neID =" + neInfo.iNeId);
        int result = TECommunicationMgr.instance().connect(commInfo, neInfo, TEAdapterManager.instance());
        if (result != 0) {
            LoggerFactory.getLogger(this.getClass()).info("TEQxCommuMgr createConect: No Succeed");
        } else {
            LoggerFactory.getLogger(this.getClass()).info("TEQxCommuMgr createConect: Connect NE Succeed.");
            if (NECommActivator.isIntegratedMode()) {
                neInfo.connectStateChanged(0);
            }
        }
        return result;
    }

    public int createConect(QxNEConnectInfo connectInfo) {
        TECommInfo commInfo = this.buildCommInfo(connectInfo.getPort(), connectInfo.getIpAddress(), connectInfo.getCommType(), connectInfo.getBaudrate());
        TENEInfo neInfo = new TENEInfo(connectInfo.getLogicNeID(), commInfo);
        if (connectInfo.isValidVersion()) {
            neInfo.setNEVersion(connectInfo.getNeVersion());
        }
        return this.createConect(neInfo, commInfo);
    }

    private TECommInfo buildCommInfo(int port, String ipAddress, int commType, String baudrate) {
        String[][] serialParams = null;
        switch (commType) {
            case 1: {
                commType = 0;
                break;
            }
            case 2: {
                commType = 1;
                break;
            }
            case 3: {
                commType = 2;
                if (null == baudrate) break;
                serialParams = new String[][]{{"baudrate", String.valueOf(baudrate)}};
                break;
            }
            case 4: {
                commType = 4;
                break;
            }
        }
        TECommInfo commInfo = new TECommInfo(commType, ipAddress, port, serialParams);
        return commInfo;
    }

    public synchronized int closeConnect(long neID, int port, String ipAddress, int commType) {
        TENEInfo neInfo = this.neInfoMap.get(neID);
        if (null == neInfo) {
            LoggerFactory.getLogger(this.getClass()).warn("TEQXCommuMgr closeConnect: neInfo is not eixt, neID = " + neID);
            return 0;
        }
        TECommInfo commInfo = this.neCommuInfoMap.get(neInfo);
        if (commInfo == null) {
            LoggerFactory.getLogger(this.getClass()).warn("TEQXCommuMgr closeConnect: neInfo is not eixt, neID = " + neID);
            return 0;
        }
        TECommunicationMgr.instance().close(commInfo, neInfo, true);
        this.unregisterCommu(neID);
        this.unregisterNEInfo(neID);
        return 0;
    }

    public synchronized boolean refreshConnect(long neID, int port, String ipAddress, int commType) {
        LoggerFactory.getLogger(this.getClass()).info("refreshConnect, neID = " + neID, (Object)("port = " + port + "ipAddress =" + ipAddress + "commType=" + commType));
        TENEInfo neInfo = this.neInfoMap.get(neID);
        if (null == neInfo) {
            LoggerFactory.getLogger(this.getClass()).info("refreshConnect: neInfo is not eixt, neID = " + neID);
            return false;
        }
        TECommInfo commInfo = this.neCommuInfoMap.get(neInfo);
        if (commInfo == null) {
            LoggerFactory.getLogger(this.getClass()).info("refreshConnect: neCommuInfo is not eixt, neID = " + neID);
            return false;
        }
        TECommunicationMgr.instance().close(commInfo, neInfo, true);
        this.unregisterCommu(neID);
        TECommInfo newCommInfo = this.buildCommInfo(port, ipAddress, commType, null);
        TENEInfo newNeInfo = new TENEInfo(neID, newCommInfo);
        int result = this.createConect(newNeInfo, newCommInfo);
        if (result != 0) {
            LoggerFactory.getLogger(this.getClass()).info("refreshConnect fail");
            return false;
        }
        return true;
    }

    public synchronized int registerCommu(TECommInfo commInfo, TENEInfo neInfo) {
        if (this.neCommuInfoMap.containsKey(neInfo)) {
            LoggerFactory.getLogger(this.getClass()).info("TEQXCommuMgr registerNEInfo: CommInfo Is exit.");
            return 0;
        }
        this.neCommuInfoMap.put(neInfo, commInfo);
        return 0;
    }

    public synchronized void registerNEInfo(TENEInfo neInfo) {
        this.neInfoMap.put(neInfo.iNeId, neInfo);
        LoggerFactory.getLogger(this.getClass()).info("registerNEInfo, neID=" + neInfo.iNeId);
    }

    public synchronized int unregisterCommu(long neId) {
        TENEInfo neInfo = this.getNECommuInfo(neId);
        this.neCommuInfoMap.remove(neInfo);
        return 0;
    }

    public synchronized void unregisterNEInfo(long neId) {
        this.neInfoMap.remove(neId);
    }

    public Map<TENEInfo, TECommInfo> getCommuInfo() {
        return this.neCommuInfoMap;
    }

    public void recycleQxFrameHandler() {
        Set<Map.Entry<Long, TENEInfo>> entries = this.neInfoMap.entrySet();
        for (Map.Entry<Long, TENEInfo> entry : entries) {
            TENEInfo neInfo = entry.getValue();
            neInfo.deleteTimeOutPacket();
        }
    }

    private void singleNETask() {
        Map.Entry<TENEInfo, TECommInfo> entry;
        TENEInfo neInfo;
        Set<Map.Entry<TENEInfo, TECommInfo>> entries = this.neCommuInfoMap.entrySet();
        Iterator<Map.Entry<TENEInfo, TECommInfo>> iter = entries.iterator();
        if (iter.hasNext() && !(neInfo = (entry = iter.next()).getKey()).sendNERecyclePacket()) {
            LoggerFactory.getLogger(this.getClass()).info("sendNERecyclePacket fail");
        }
    }

    public void recycleTimeHandler() {
        Set<Map.Entry<TENEInfo, TECommInfo>> entries = this.neCommuInfoMap.entrySet();
        for (Map.Entry<TENEInfo, TECommInfo> entry : entries) {
            TENEInfo neInfo = entry.getKey();
            if (neInfo.sendNERecyclePacket()) continue;
            LoggerFactory.getLogger(this.getClass()).info("TEQxCommuMgr.RecycleTimeHandler, unreg commuinfo.");
        }
    }

    public void linkTimeHandler() {
        TENEInfo neInfo;
        ArrayList<TENEInfo> tmpCommuInfolist = new ArrayList<TENEInfo>();
        Set<Map.Entry<TENEInfo, TECommInfo>> entries = this.neCommuInfoMap.entrySet();
        for (Map.Entry<TENEInfo, TECommInfo> entry : entries) {
            neInfo = entry.getKey();
            if (!neInfo.isSuccToApplyNMID()) continue;
            tmpCommuInfolist.add(neInfo);
        }
        for (int index = 0; index < tmpCommuInfolist.size(); ++index) {
            neInfo = (TENEInfo)tmpCommuInfolist.get(index);
            if (neInfo.sendNELinkPacket(neInfo)) continue;
            long neID = neInfo.iNeId;
            LoggerFactory.getLogger(this.getClass()).info("TEQxCommuMgr::LinkTimeHandler, unreg commuinfo 0x" + neID);
        }
    }

    public TENEInfo getNECommuInfo(long ulGNeId) {
        TENEInfo neInfo = this.neInfoMap.get(ulGNeId);
        if (neInfo == null) {
            LoggerFactory.getLogger(this.getClass()).info("TEQxCommuMgr getNECommuInfo: No GateWay NE, ulGNeId=" + ulGNeId);
        }
        return neInfo;
    }

    public TECommInfo getCommInfo(long ulGNeId) {
        TENEInfo neInfo = this.getNECommuInfo(ulGNeId);
        if (neInfo == null) {
            return null;
        }
        TECommInfo commInfo = this.neCommuInfoMap.get(neInfo);
        return commInfo;
    }

    class TEQxFrameHandleTimerTask
    extends TimerTask {
        TEQxFrameHandleTimerTask() {
        }

        @Override
        public void run() {
            TEQxCommuMgr.this.recycleQxFrameHandler();
        }
    }

    class LinkTimerTask
    extends TimerTask {
        LinkTimerTask() {
        }

        @Override
        public void run() {
            TEQxCommuMgr.this.linkTimeHandler();
        }
    }

    class RecycleTask
    extends TimerTask {
        RecycleTask() {
        }

        @Override
        public void run() {
            if (!NECommActivator.isIntegratedMode()) {
                TEQxCommuMgr.this.recycleTimeHandler();
            } else {
                TEQxCommuMgr.this.singleNETask();
            }
        }
    }

    public static enum PORT_STATUS {
        UN_APPLY,
        APPLYING,
        APPLYFAIL,
        APPLYEND;

    }
}

