/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.qxprotocol.qx5adapter;

import com.huawei.uflight.necomm.IOStreamConvertor;
import com.huawei.uflight.necomm.TECommInfo;
import com.huawei.uflight.qxprotocol.TEMessage;
import com.huawei.uflight.qxprotocol.TEMessageAdapter;
import com.huawei.uflight.qxprotocol.TENEInfo;
import com.huawei.uflight.qxprotocol.TEProtocolImpl;
import com.huawei.uflight.qxprotocol.qx5adapter.TEQx5Command;
import com.huawei.uflight.qxprotocol.qx5adapter.TEQx5Message;
import com.huawei.uflight.qxprotocol.qx5adapter.TEQxCommuMgr;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.LoggerFactory;

public class TEQx5ProtocolImpl
extends TEProtocolImpl {
    private static TEQx5ProtocolImpl pInstance = null;
    private Map rptCmdAdapterMap = new HashMap();
    private long ulCmdSerial;

    TEQx5ProtocolImpl() {
    }

    public static synchronized TEQx5ProtocolImpl instance() {
        if (pInstance == null) {
            pInstance = new TEQx5ProtocolImpl();
        }
        return pInstance;
    }

    public synchronized long requireSerial() {
        long ulSerial = 0L;
        if (65535L == this.ulCmdSerial) {
            this.ulCmdSerial = 0L;
        }
        ulSerial = this.ulCmdSerial++;
        return ulSerial;
    }

    @Override
    public int checkMessageValid(byte[] bufVec, int offset, long size) {
        return TEQxCommuMgr.instance().checkMessageValid(bufVec, offset, size);
    }

    @Override
    public TEMessage handleInput(TENEInfo neInfo, byte[] bufVec) {
        TEQx5Message pMessage = new TEQx5Message(false);
        if (pMessage.initMessage(bufVec) != 0) {
            LoggerFactory.getLogger(this.getClass()).info("TEQx5ProtocolImpl::HandleInput, del msg 0x%x, class type is %s.\n" + pMessage.getClass().toString());
            return null;
        }
        return pMessage;
    }

    @Override
    public int sendMessage(TEMessage pMessage) {
        TEQx5Message pMsg = (TEQx5Message)pMessage;
        long ulNeId = pMsg.getNEID();
        TENEInfo handle = TEQxCommuMgr.instance().getNECommuInfo(ulNeId);
        if (handle == null) {
            LoggerFactory.getLogger(this.getClass()).info(" TEQx5ProtocolImp1 sendMessage: Get Handle error! ");
            return -98296;
        }
        List<TEQx5Command> pCmdList = pMsg.getQx5CommandList();
        if (pCmdList.isEmpty()) {
            LoggerFactory.getLogger(this.getClass()).info("TEQx5ProtocolImp1 sendMessage: Qx5 msg has no cmd! ");
            return -98289;
        }
        TECommInfo commInfo = TEQxCommuMgr.instance().getCommInfo(ulNeId);
        if (commInfo.getCommType() != 2 && !TEQxCommuMgr.instance().canSendMessage(handle)) {
            LoggerFactory.getLogger(this.getClass()).info("TEQx5ProtocolImpl sendMessage:Apply for NM ID Fail,can not send message! neID: " + ulNeId);
            return -10;
        }
        return this.sendMessage(handle, pMsg);
    }

    private int sendMessage(TENEInfo handle, TEQx5Message pMsg) {
        int i;
        TEQx5Command pCmd = null;
        int nOffset = 0;
        List<TEQx5Command> pCmdList = pMsg.getQx5CommandList();
        boolean isWriteLog = TEQxCommuMgr.instance().isWriteLog(pCmdList);
        if (pCmdList == null || pCmdList.isEmpty()) {
            LoggerFactory.getLogger(this.getClass()).info(" Qx5 command list is null \n");
            return -98289;
        }
        long ulNeVersion = pMsg.getVersion();
        byte[] neVesionByte = IOStreamConvertor.int2Bytes((int)ulNeVersion);
        nOffset = 0;
        int cmdHeadSize = 0;
        int size = pCmdList.size();
        for (i = 0; i < size; ++i) {
            pCmd = pCmdList.get(i);
            long ulCmdLen = pCmd.getParaSize();
            cmdHeadSize += pCmd.getQx5CommandSize() + (int)ulCmdLen;
        }
        byte[] msgVec = new byte[5 + cmdHeadSize];
        System.arraycopy(neVesionByte, 0, msgVec, nOffset, 4);
        nOffset += 4;
        size = pCmdList.size();
        for (i = 0; i < size; ++i) {
            pCmd = pCmdList.get(i);
            long ulSerial = 0L;
            int usAckMode = 0;
            int usCmdName = 0;
            long ulCmdLen = pCmd.getParaSize();
            ulSerial = pCmd.getSerial();
            byte[] dataByte = IOStreamConvertor.int2Bytes((int)ulSerial);
            System.arraycopy(dataByte, 0, msgVec, nOffset, 4);
            usAckMode = pCmd.getAckMode();
            dataByte = IOStreamConvertor.unsignedShort2Bytes(usAckMode);
            System.arraycopy(dataByte, 0, msgVec, nOffset += 4, 2);
            usCmdName = pCmd.getCommandKey();
            dataByte = IOStreamConvertor.unsignedShort2Bytes(usCmdName);
            System.arraycopy(dataByte, 0, msgVec, nOffset += 2, 2);
            long cmdLen = ulCmdLen;
            dataByte = IOStreamConvertor.int2Bytes((int)ulCmdLen);
            System.arraycopy(dataByte, 0, msgVec, nOffset += 2, 4);
            nOffset += 4;
            dataByte = pCmd.getPara();
            if (dataByte != null) {
                LoggerFactory.getLogger(this.getClass()).info("TEQx5ProtocolImpl : no para");
                System.arraycopy(pCmd.getPara(), 0, msgVec, nOffset, (int)cmdLen);
            }
            nOffset += (int)cmdLen;
        }
        msgVec[msgVec.length - 1] = 0;
        long msgVecLen = msgVec.length;
        return TEQxCommuMgr.instance().sendMessage(handle, msgVec, msgVecLen, isWriteLog);
    }

    public TEMessageAdapter getReportCommandAdapter(int usCmdKey) {
        TEMessageAdapter it = (TEMessageAdapter)this.rptCmdAdapterMap.get(usCmdKey);
        return it;
    }

    public void addQx5ReportCmdAdapter(int usCmdCode, TEMessageAdapter pQx5MsgAdapter) {
        this.rptCmdAdapterMap.put(usCmdCode, pQx5MsgAdapter);
    }

    public void deleteQx5ReportCmdAdapter(int usCmdCode) {
        this.rptCmdAdapterMap.remove(usCmdCode);
    }
}

