/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.qxprotocol.qx5adapter;

import com.huawei.uflight.necomm.IOStreamConvertor;
import com.huawei.uflight.qxprotocol.TEAdapterManager;
import com.huawei.uflight.qxprotocol.TEFunSrvDataQx5MessageAdapter;
import com.huawei.uflight.qxprotocol.TEMessage;
import com.huawei.uflight.qxprotocol.TEMessageAdapter;
import com.huawei.uflight.qxprotocol.TEMessageInfo;
import com.huawei.uflight.qxprotocol.TEMessageUnit;
import com.huawei.uflight.qxprotocol.TEProtocolAdapter;
import com.huawei.uflight.qxprotocol.qx5adapter.TEQx5CmdHead;
import com.huawei.uflight.qxprotocol.qx5adapter.TEQx5Command;
import com.huawei.uflight.qxprotocol.qx5adapter.TEQx5ProtocolAdapter;
import com.huawei.uflight.qxprotocol.qx5adapter.TEQx5ProtocolImpl;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TEQx5Message
extends TEMessage {
    public long ulNeId = 0L;
    public long ulVersion = 0L;
    private boolean blTransFlag = false;
    public static final int TRANS_START_CMD = 28726;
    public static final int TRANS_SUBMIT_CMD = 28728;
    private List<TEQx5Command> commandList = new ArrayList<TEQx5Command>();
    private static Logger log = LoggerFactory.getLogger(TEQx5Message.class);

    public TEQx5Message(boolean isTrans) {
        super(TEQx5ProtocolAdapter.instance(), 1, 60000, false);
        this.blTransFlag = isTrans;
        super.setTransFlag(isTrans);
        this.ulMessageSerial = isTrans ? TEQx5ProtocolImpl.instance().requireSerial() : 0L;
    }

    @Override
    public int handleMessage() {
        TEProtocolAdapter pProtocolAdapter = this.protocolInstance();
        if (pProtocolAdapter == null) {
            log.info("TEQx5Message handleMessage: ProtocolAdapter is null.");
            return -10;
        }
        switch (this.getType()) {
            case 1: {
                if (this.blTransFlag) {
                    this.fillTransBegin();
                    this.fillTransEnd();
                }
                return pProtocolAdapter.handleMessage(this);
            }
            case 2: {
                int ret = 0;
                List<TEQx5Command> pCmdList = this.getQx5CommandList();
                if (pCmdList == null || pCmdList.isEmpty()) {
                    log.info("TEQx5Message handleMessage: Qx5 msg has no command! ");
                    return 0;
                }
                int size = pCmdList.size();
                for (int i = 0; i < size; ++i) {
                    TEQx5Command cmd = pCmdList.get(i);
                    ret = this.handleResponse(this.getVersion(), this.getNEID(), cmd);
                    if (ret == 0) continue;
                    log.info("TEQx5Message handleMessage: handle Qx5 response message error   " + ret);
                }
                return ret;
            }
            case 3: {
                return this.handleReportMessage();
            }
        }
        log.info("TEQx5Message handleMessage:  Message type error " + this.getType());
        return -98290;
    }

    public int handleResponse(long version, long neId, TEQx5Command pQx5Cmd) {
        TEAdapterManager adapterManager = TEAdapterManager.instance();
        TEMessageUnit sinkMsgUnit = new TEMessageUnit();
        sinkMsgUnit.ulMessageSerial = pQx5Cmd.getSerial();
        sinkMsgUnit.protocolType = 3;
        TEMessageUnit unitIt = adapterManager.findSrcMsgUnit(sinkMsgUnit);
        if (null == unitIt) {
            return 0;
        }
        TEMessageInfo infoIt = adapterManager.findSrcMsgInfo(unitIt);
        if (null == infoIt) {
            adapterManager.eraseFromUnitMap(sinkMsgUnit);
            return 0;
        }
        TEQx5Message pSinkMessage = (TEQx5Message)infoIt.pSinkMessage;
        if (pSinkMessage == null) {
            infoIt.pSinkMessage = new TEQx5Message(false);
            pSinkMessage = (TEQx5Message)infoIt.pSinkMessage;
            pSinkMessage.setNEID(neId);
            pSinkMessage.setVersion(version);
        }
        pSinkMessage.addQx5Command(pQx5Cmd);
        boolean bLastResponseFlag = false;
        if (pQx5Cmd.isCommandEnd()) {
            infoIt.deleteSinkMessage(sinkMsgUnit);
            adapterManager.eraseFromUnitMap(sinkMsgUnit);
        }
        int iResult = 0;
        if (infoIt.getSinkMessageCount() == 0) {
            bLastResponseFlag = true;
            if (infoIt.pMessageAdapter == null) {
                log.info("infoIt.m_pMessageAdapter is null, pQx5Cmd: " + pQx5Cmd.getCommandKey());
                infoIt.pMessageAdapter = TEFunSrvDataQx5MessageAdapter.instance();
            }
            iResult = infoIt.pMessageAdapter.handleResponse(pSinkMessage, infoIt.pSrcMessage, infoIt.pData, bLastResponseFlag);
            pSinkMessage.clearCommand();
            if (infoIt.getSinkMessageCount() == 0) {
                adapterManager.eraseFromInfoMap(unitIt);
            }
        }
        return iResult;
    }

    public int handleReportMessage() {
        long neId = this.getNEID();
        List<TEQx5Command> pCmdList = this.getQx5CommandList();
        if (!pCmdList.isEmpty()) {
            TEQx5Command pCmd = pCmdList.get(0);
            int ret = 0;
            TEMessageAdapter pMsgAdapter = null;
            if (28497 == pCmd.getCommandKey()) {
                pMsgAdapter = pCmd.getReportMessageAdapter();
                if (pMsgAdapter == null) {
                    log.info("TEQx5Message handleReportMessage: Assert! Qx5 rpt msg has no adpter." + pCmd.getCommandKey());
                } else {
                    ret = pMsgAdapter.handleReportCommand(neId, pCmdList);
                    if (ret != 0) {
                        log.info("TEQx5Message handleReportMessage: Qx5 Handle report msg error." + ret + pCmd.getCommandKey());
                    }
                    return 0;
                }
            }
        }
        int size = pCmdList.size();
        for (int i = 0; i < size; ++i) {
            int ret = 0;
            TEQx5Command pCmd = pCmdList.get(i);
            TEMessageAdapter pMsgAdapter = pCmd.getReportMessageAdapter();
            if (pMsgAdapter == null) {
                log.info("TEQx5Message handleReportMessage: Qx5 rpt msg has no adpter " + pCmd.getCommandKey());
                continue;
            }
            ret = pMsgAdapter.handleReportCommand(neId, pCmd);
            if (ret == 0) continue;
            log.info("TEQx5Message handleReportMessage: Qx5 Handle report msg error " + ret + pCmd.getCommandKey());
        }
        return 0;
    }

    public int initMessage(byte[] bufVec) {
        int uEndOffset = bufVec.length;
        int nOffset = 0;
        int nBufLen = 0;
        int nCmdCount = 0;
        log.info("TEQX5Message initMessage: handle Qx5 Command Message,data size is " + bufVec.length);
        long ulNeVersion = IOStreamConvertor.readUnsignedInt(bufVec, 0);
        this.setVersion(ulNeVersion);
        nOffset += 4;
        this.setType(2);
        nBufLen = bufVec.length;
        while (nOffset < nBufLen - 1) {
            TEQx5CmdHead cmdHead = new TEQx5CmdHead();
            cmdHead.ulSerial = IOStreamConvertor.readUnsignedInt(bufVec, nOffset);
            cmdHead.usControl = IOStreamConvertor.readUnsignedShort(bufVec, nOffset += 4);
            cmdHead.usCmdCode = IOStreamConvertor.readUnsignedShort(bufVec, nOffset += 2);
            cmdHead.ulParaLen = IOStreamConvertor.readUnsignedInt(bufVec, nOffset += 2);
            int cmdParaLen = (int)cmdHead.ulParaLen;
            nOffset += 4;
            int usResult = 0;
            if (!TEQx5Command.isReportCommand(cmdHead.usCmdCode)) {
                usResult = IOStreamConvertor.readUnsignedShort(bufVec, nOffset);
                nOffset += 2;
            }
            TEQx5Command pCmd = new TEQx5Command(2);
            pCmd.setSerial(cmdHead.ulSerial);
            pCmd.setAckMode(cmdHead.usControl);
            pCmd.setCommandKey(cmdHead.usCmdCode);
            pCmd.setExecResult(usResult);
            if (nCmdCount == 0) {
                if (TEQx5Command.isReportCommand(pCmd.getCommandKey())) {
                    this.setType(3);
                } else {
                    this.setType(2);
                }
            }
            if (this.getType() == 2) {
                if (cmdParaLen > 65536) {
                    log.info("Qx5 cmd length error" + cmdParaLen + " ,ulSerial is " + cmdHead.ulSerial + " , cmd is " + cmdHead.usCmdCode + ", cur nOffset is " + nOffset);
                    return 22;
                }
                if (nOffset + (cmdParaLen - 2) > uEndOffset) {
                    log.info("Message Data is exceed." + cmdParaLen + " ,ulSerial is " + cmdHead.ulSerial + " , cmd is " + cmdHead.usCmdCode + ", cur nOffset is " + nOffset);
                    return -98284;
                }
                pCmd.setResultData(nOffset - 2, cmdParaLen, bufVec);
                nOffset += cmdParaLen - 2;
            } else {
                if ((long)cmdHead.getTypeSize() + cmdHead.ulParaLen > (long)uEndOffset) {
                    return -98284;
                }
                pCmd.setResultData(nOffset, (int)cmdHead.ulParaLen, bufVec);
                nOffset = (int)((long)nOffset + cmdHead.ulParaLen);
            }
            this.commandList.add(pCmd);
            ++nCmdCount;
        }
        if (bufVec[nOffset] != 0) {
            log.info("TEQX5Message initMessage: Qx5 package endflg error  " + bufVec[nOffset]);
            return 22;
        }
        return 0;
    }

    public int fillTransBegin() {
        int cmdCount = this.getQx5CommandCount();
        if (cmdCount <= 0) {
            log.info("TEQX5Message initMessage: Qx5 Trans has no cmd " + cmdCount);
            return -98289;
        }
        TEQx5Command pCmd = new TEQx5Command(28726);
        pCmd.setSerial(this.ulMessageSerial);
        byte[] cmdCountbyte = new byte[]{1};
        pCmd.setData(0, 1, cmdCountbyte, true);
        this.commandList.add(0, pCmd);
        return 0;
    }

    public int fillTransEnd() {
        TEQx5Command pCmd = new TEQx5Command(28728);
        pCmd.requireSerial();
        String comment = "NGLCT";
        pCmd.setData(0, 255, comment.getBytes(), true);
        this.commandList.add(pCmd);
        return 0;
    }

    public int getQx5CommandCount() {
        return this.commandList.size();
    }

    public void clearCommand() {
        this.commandList.clear();
    }

    @Override
    public TEMessageAdapter getMessageAdapter() {
        return null;
    }

    public long getNEID() {
        return this.ulNeId;
    }

    public void setNEID(long neID) {
        this.ulNeId = neID;
    }

    public List<TEQx5Command> getQx5CommandList() {
        return this.commandList;
    }

    public void addQx5Command(TEQx5Command pQx5Cmd) {
        this.commandList.add(pQx5Cmd);
    }

    public void addQx5CommandList(List<TEQx5Command> pQx5CmdList) {
        this.commandList.addAll(pQx5CmdList);
    }

    public void setVersion(long version) {
        this.ulVersion = version;
    }

    public long getVersion() {
        return this.ulVersion;
    }

    public long getSetError() {
        return this.getError();
    }

    public long getError() {
        int size = this.commandList.size();
        for (int i = 0; i < size; ++i) {
            TEQx5Command it = this.commandList.get(i);
            int usResult = it.getExecResult();
            if (usResult == 0) continue;
            return 21 + usResult;
        }
        return 0L;
    }
}

