/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.qxprotocol.qx5adapter;

import com.huawei.uflight.qxprotocol.TECommand;
import com.huawei.uflight.qxprotocol.TEMessageAdapter;
import com.huawei.uflight.qxprotocol.qx5adapter.TEQx5ProtocolImpl;
import org.slf4j.LoggerFactory;

public class TEQx5Command
extends TECommand {
    private long ulSerial;
    private int usAckMode;
    private int usCommandKey;
    int paraLen = 0;
    private int nExecResult;
    private byte[] bufVec;
    private byte[] bufResultVec;

    public TEQx5Command() {
    }

    public TEQx5Command(int cmdKey) {
        this.usAckMode = 32768;
        if (cmdKey != 2) {
            this.requireSerial();
        }
        if (cmdKey != 2 || cmdKey != 1) {
            this.usCommandKey = cmdKey;
        }
        this.nExecResult = 0;
    }

    public boolean isCommandEnd() {
        return (this.usAckMode & 0x2000) == 0;
    }

    public void requireSerial() {
        this.ulSerial = TEQx5ProtocolImpl.instance().requireSerial();
    }

    public int getParaSize() {
        if (this.bufVec == null) {
            LoggerFactory.getLogger(this.getClass()).info("TEQx5Command: Command ParaLen is 0");
            this.paraLen = 0;
            return this.paraLen;
        }
        this.paraLen = this.bufVec.length;
        return this.paraLen;
    }

    public byte[] getPara() {
        return this.bufVec;
    }

    public byte[] getData(int nOffset, int nLength) {
        int nSize = this.bufVec.length;
        byte[] buffer = null;
        if (nSize - nOffset <= 0) {
            return buffer;
        }
        buffer = new byte[nSize - nOffset];
        nLength = nSize - nOffset >= nLength ? nLength : nSize - nOffset;
        System.arraycopy(this.bufResultVec, nOffset, buffer, 0, nLength);
        return buffer;
    }

    public byte[] getResultData(int nOffset, int nLength) {
        if (this.bufResultVec == null || this.bufResultVec.length == 0) {
            LoggerFactory.getLogger(this.getClass()).info("TEQx5Command: no data for the QX5 command.");
            return null;
        }
        int nSize = this.bufResultVec.length;
        byte[] buffer = null;
        if (nOffset >= nSize) {
            return buffer;
        }
        buffer = new byte[nLength];
        System.arraycopy(this.bufResultVec, nOffset, buffer, 0, nLength);
        return buffer;
    }

    public byte[] getResultData(int nOffset) {
        if (this.bufResultVec == null || this.bufResultVec.length == 0) {
            LoggerFactory.getLogger(this.getClass()).info("TEQx5Command: no data for the QX5 command.");
            return null;
        }
        int nSize = this.bufResultVec.length;
        byte[] buffer = null;
        if (nOffset >= nSize) {
            return buffer;
        }
        buffer = new byte[nSize - nOffset];
        System.arraycopy(this.bufResultVec, nOffset, buffer, 0, nSize - nOffset);
        return buffer;
    }

    public void setData(int nOffset, int nLength, byte[] buffer, boolean preFill) {
        byte[] tmpBuffer = null;
        if (nLength <= 0) {
            LoggerFactory.getLogger(this.getClass()).info("TEQx5Command: no data for the QX5 command.");
            return;
        }
        if (this.bufVec == null || this.bufVec.length == 0) {
            this.bufVec = new byte[nOffset + nLength];
        }
        if (nOffset + nLength > this.bufVec.length) {
            tmpBuffer = new byte[this.bufVec.length];
            System.arraycopy(this.bufVec, 0, tmpBuffer, 0, this.bufVec.length);
            this.bufVec = new byte[nOffset + nLength];
        }
        if (preFill) {
            System.arraycopy(buffer, 0, this.bufVec, this.bufVec.length - buffer.length, buffer.length);
        } else {
            System.arraycopy(buffer, 0, this.bufVec, nOffset, buffer.length);
        }
        if (tmpBuffer != null && tmpBuffer.length < this.bufVec.length) {
            System.arraycopy(tmpBuffer, 0, this.bufVec, 0, tmpBuffer.length);
        }
    }

    public void setResultData(int nOffset, int nLength, byte[] buffer) {
        if (nLength <= 0) {
            LoggerFactory.getLogger(this.getClass()).info("TEQx5Command setResultData: Qx5\u00c3\u00fc\u00c1\u00ee\u00b7\u00b5\u00bb\u00d8\u00ca\u00fd\u00be\u00dd\u00ce\u00de");
            return;
        }
        if (this.bufVec == null || this.bufVec.length == 0) {
            this.bufResultVec = new byte[nLength];
        }
        System.arraycopy(buffer, nOffset, this.bufResultVec, 0, nLength);
    }

    public static boolean isReportCommand(int usCmdKey) {
        return usCmdKey >= 28416 && usCmdKey <= 28671 || usCmdKey >= 16384 && usCmdKey <= 24575;
    }

    public TEMessageAdapter getReportMessageAdapter() {
        return TEQx5ProtocolImpl.instance().getReportCommandAdapter(this.getCommandKey());
    }

    public byte[] getByte(int nOffset) {
        if (this.bufResultVec == null || nOffset >= this.bufResultVec.length) {
            LoggerFactory.getLogger(this.getClass()).info("TEQx5Command::GetByte, Msg from ne error! \n");
            return null;
        }
        byte[] bytes = new byte[]{this.bufResultVec[nOffset]};
        return bytes;
    }

    public byte[] getWord(int nOffset) {
        if (this.bufResultVec == null || nOffset >= this.bufResultVec.length) {
            LoggerFactory.getLogger(this.getClass()).info("TEQx5Command::GetWord, Msg from ne error! \n");
            return null;
        }
        byte[] bytes = new byte[2];
        int length = bytes.length;
        for (int i = 0; i < length; ++i) {
            bytes[i] = this.bufResultVec[nOffset + i];
        }
        return bytes;
    }

    public byte[] getDword(int nOffset) {
        if (this.bufResultVec == null || nOffset >= this.bufResultVec.length) {
            LoggerFactory.getLogger(this.getClass()).info("TEQx5Command::GetWord, Msg from ne error! \n");
            return null;
        }
        byte[] bytes = new byte[4];
        int length = bytes.length;
        for (int i = 0; i < length; ++i) {
            bytes[i] = this.bufResultVec[nOffset + i];
        }
        return bytes;
    }

    public void setSerial(long ulSerial) {
        this.ulSerial = ulSerial;
    }

    public long getSerial() {
        return this.ulSerial;
    }

    public int getCommandKey() {
        return this.usCommandKey;
    }

    public void setCommandKey(int usCmd) {
        this.usCommandKey = usCmd;
    }

    public int getAckMode() {
        return this.usAckMode;
    }

    public void setAckMode(int usAckMode) {
        this.usAckMode = usAckMode;
    }

    public int getExecResult() {
        return this.nExecResult;
    }

    public void setExecResult(int nResult) {
        this.nExecResult = nResult;
    }

    public int getCommandSize() {
        return 16;
    }

    public int getQx5CommandSize() {
        return 12;
    }

    public String toString() {
        String cmdString = "CMD: " + this.usCommandKey + ", Serial:" + this.ulSerial + ", EXEResult:" + this.nExecResult;
        return cmdString;
    }
}

