/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.qxprotocol.qx5adapter;

import com.huawei.uflight.qxprotocol.TENEInfo;
import com.huawei.uflight.qxprotocol.qx5adapter.TEQxFrame;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QxFrameSet {
    private Map mapQxFrame = new Hashtable();
    private volatile int nTotalDataSize = 0;
    private volatile int nTotalFrameNum = 0;
    private int nKeepTime = 1800;
    private long firstFrameArriveTime = System.currentTimeMillis();
    private static Logger logger = LoggerFactory.getLogger(TENEInfo.class);

    public void setFirstFrameArriveTime(long time) {
        this.firstFrameArriveTime = time;
    }

    public long getFirstFrameArriveTime() {
        return this.firstFrameArriveTime;
    }

    public void insert(int ucFrameSerial, TEQxFrame pQxFrame) {
        if (pQxFrame == null) {
            return;
        }
        if (this.mapQxFrame.get(ucFrameSerial) != null) {
            return;
        }
        ++this.nTotalFrameNum;
        this.nTotalDataSize += pQxFrame.m_BufVec.length;
        this.mapQxFrame.put(ucFrameSerial, pQxFrame);
    }

    public byte[] getAllData() {
        logger.info("nTotalDataSize is " + this.nTotalDataSize);
        byte[] msgVec = new byte[this.nTotalDataSize];
        int nOffset = 0;
        Set entries = this.mapQxFrame.keySet();
        ArrayList keys = new ArrayList(entries);
        Collections.sort(keys);
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            TEQxFrame pQxFrame = (TEQxFrame)this.mapQxFrame.get(iter.next());
            System.arraycopy(pQxFrame.m_BufVec, 0, msgVec, nOffset, pQxFrame.m_BufVec.length);
            nOffset += pQxFrame.m_BufVec.length;
            logger.info("copy data, packSerial is " + pQxFrame.m_FrameHead.byFrameSerial + ", data size is" + pQxFrame.m_BufVec.length);
        }
        return msgVec;
    }

    public int getDecKeepTime() {
        this.nKeepTime -= 900000;
        return this.nKeepTime;
    }

    public int getTotalDataSize() {
        return this.nTotalDataSize;
    }

    public int getTotalFrameNum() {
        return this.nTotalFrameNum;
    }
}

