/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.qxprotocol.definitions;

import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import org.exolab.castor.util.IteratorEnumeration;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;

public class Operation
implements Serializable,
Cloneable {
    private int _cmdid;
    private boolean _has_cmdid;
    private boolean _has_level;
    private String _name;
    private Input _input;
    private ArrayList _outputList = new ArrayList();
    private long _cmdserial;
    private int _ackmode;
    private boolean _has_cmdserial;
    private boolean _has_ackmode;

    public void addOutput(Output vOutput) throws IndexOutOfBoundsException {
        this._outputList.add(vOutput);
    }

    public void addOutput(int index, Output vOutput) throws IndexOutOfBoundsException {
        this._outputList.add(index, vOutput);
    }

    public void clearOutput() {
        this._outputList.clear();
    }

    public Enumeration enumerateOutput() {
        return new IteratorEnumeration(this._outputList.iterator());
    }

    public int getCmdid() {
        return this._cmdid;
    }

    public Input getInput() {
        return this._input;
    }

    public String getName() {
        return this._name;
    }

    public Output getOutput(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._outputList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (Output)this._outputList.get(index);
    }

    public Output[] getOutput() {
        int size = this._outputList.size();
        Output[] mArray = new Output[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (Output)this._outputList.get(index);
        }
        return mArray;
    }

    public int getOutputCount() {
        return this._outputList.size();
    }

    public boolean hasCmdid() {
        return this._has_cmdid;
    }

    public boolean hasLevel() {
        return this._has_level;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public boolean removeOutput(Output vOutput) {
        boolean removed = this._outputList.remove(vOutput);
        return removed;
    }

    public Object removeOutput(int index) {
        return this._outputList.remove(index);
    }

    public void setCmdid(int cmdid) {
        this._cmdid = cmdid;
        this._has_cmdid = true;
    }

    public void setInput(Input input) {
        this._input = input;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setOutput(int index, Output vOutput) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._outputList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._outputList.set(index, vOutput);
    }

    public void setOutput(Output[] outputArray) {
        this._outputList.clear();
        for (int i = 0; i < outputArray.length; ++i) {
            this._outputList.add(outputArray[i]);
        }
    }

    public void setCmdSerial(long cmdSerial) {
        this._has_cmdserial = true;
        this._cmdserial = cmdSerial;
    }

    public void setAckMode(int ackMode) {
        this._has_ackmode = true;
        this._ackmode = ackMode;
    }

    public long getCmdSerial() {
        return this._cmdserial;
    }

    public int getAckMode() {
        if (!this.hasAckMode()) {
            return 32768;
        }
        return this._ackmode;
    }

    public boolean hasCmdSerial() {
        return this._has_cmdserial;
    }

    public boolean hasAckMode() {
        return this._has_ackmode;
    }

    public static Operation unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (Operation)Unmarshaller.unmarshal(Operation.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }

    public Object clone() {
        Operation cloneOperation = null;
        try {
            cloneOperation = (Operation)super.clone();
            cloneOperation.setInput((Input)this._input.clone());
            cloneOperation._outputList = new ArrayList();
            int len = this.getOutputCount();
            for (int i = 0; i < len; ++i) {
                cloneOperation.addOutput((Output)this.getOutput(i).clone());
            }
        }
        catch (Exception e) {
            throw new InternalError();
        }
        return cloneOperation;
    }
}

