/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.qxprotocol.definitions;

import com.huawei.uflight.qxprotocol.definitions.Part;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import org.exolab.castor.util.IteratorEnumeration;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;

public class Input
implements Serializable,
Cloneable {
    private ArrayList _partList = new ArrayList();

    public void addPart(Part vPart) throws IndexOutOfBoundsException {
        this._partList.add(vPart);
    }

    public void addPart(int index, Part vPart) throws IndexOutOfBoundsException {
        this._partList.add(index, vPart);
    }

    public void clearPart() {
        this._partList.clear();
    }

    public Enumeration enumeratePart() {
        return new IteratorEnumeration(this._partList.iterator());
    }

    public Part getPart(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._partList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (Part)this._partList.get(index);
    }

    public Part[] getPart() {
        int size = this._partList.size();
        Part[] mArray = new Part[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (Part)this._partList.get(index);
        }
        return mArray;
    }

    public Part getPart(String partName) throws IndexOutOfBoundsException {
        int size = this._partList.size();
        Part part = null;
        for (int index = 0; index < size; ++index) {
            part = (Part)this._partList.get(index);
            if (!part.getName().trim().equalsIgnoreCase(partName.trim())) continue;
            return part;
        }
        return null;
    }

    public int getPartCount() {
        return this._partList.size();
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public boolean removePart(Part vPart) {
        boolean removed = this._partList.remove(vPart);
        return removed;
    }

    public void setPart(int index, Part vPart) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._partList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._partList.set(index, vPart);
    }

    public void setPart(Part[] partArray) {
        this._partList.clear();
        for (int i = 0; i < partArray.length; ++i) {
            this._partList.add(partArray[i]);
        }
    }

    public String getPartValue(String partName) {
        int partSize = this._partList.size();
        for (int i = partSize - 1; i >= 0; --i) {
            Part tempPart = (Part)this._partList.get(i);
            if (!tempPart.getName().trim().equalsIgnoreCase(partName.trim())) continue;
            return tempPart.getValue();
        }
        return null;
    }

    public void setPartValue(String partName, String partValue) {
        int partSize = this._partList.size();
        for (int i = partSize - 1; i >= 0; --i) {
            Part tempPart = (Part)this._partList.get(i);
            if (!tempPart.getName().trim().equalsIgnoreCase(partName.trim())) continue;
            tempPart.setValue(partValue);
            return;
        }
    }

    public static Input unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (Input)Unmarshaller.unmarshal(Input.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }

    public Object clone() {
        Input cloneInput = null;
        try {
            cloneInput = (Input)super.clone();
            cloneInput._partList = new ArrayList();
            int len = this.getPartCount();
            for (int i = 0; i < len; ++i) {
                cloneInput.addPart((Part)this.getPart(i).clone());
            }
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        return cloneInput;
    }
}

