/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.qxprotocol;

import com.huawei.uflight.necomm.TEMessageBlock;
import com.huawei.uflight.necomm.TEMessageQueue;
import com.huawei.uflight.necomm.TEThreadPool;
import com.huawei.uflight.qxprotocol.NENMIDHandle;
import com.huawei.uflight.qxprotocol.NEStateNoticeHandle;
import com.huawei.uflight.qxprotocol.NoticeHandler;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TEFunInterfaceObject;
import com.huawei.uflight.qxprotocol.TEFunSrvDataQx5MessageAdapter;
import com.huawei.uflight.qxprotocol.TEFunSrvObjectMessage;
import com.huawei.uflight.qxprotocol.TEMessage;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.qx5adapter.TEQx5Message;
import com.huawei.uflight.qxprotocol.qx5adapter.TEQx5ProtocolImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TETaskManager {
    private static TETaskManager taskManager = new TETaskManager();
    private static Logger log = LoggerFactory.getLogger(TETaskManager.class);
    private Map reportListenerMap = new HashMap();
    private Map reportCmdIDToOperationMap = new HashMap();
    private Map neStateMap = new ConcurrentHashMap();
    private Map neNMIDMap = new HashMap();
    private BlockingQueue<TEMessageBlock> responseQueue = new LinkedBlockingQueue<TEMessageBlock>();
    private TEMessageQueue reportQueue = new TEMessageQueue(100000);
    private Thread responseProcessThread = null;
    private Thread reportProcessThread = null;
    private int retCode = 1090650120;
    private String reason = "";
    private static TEThreadPool dispatchNEStatePool;

    public static TETaskManager instance() {
        return taskManager;
    }

    private TETaskManager() {
        this.init();
    }

    public void init() {
        this.startResponsThread();
        this.reportProcessThread = new Thread(new Runnable(){

            @Override
            public void run() {
                log.info("The thread reportProcessThread has start!");
                while (true) {
                    TEMessageBlock msgBlock = TETaskManager.this.deReportQueue();
                    TEQx5Message qxMsg = (TEQx5Message)msgBlock.getObj();
                    try {
                        qxMsg.handleMessage();
                        continue;
                    }
                    catch (Exception e) {
                        log.info("the m_ulMessageSerial of qxMsg is " + qxMsg.ulMessageSerial);
                        log.error("reportProcessThread", (Throwable)e);
                        continue;
                    }
                    break;
                }
            }
        });
        this.reportProcessThread.setName("reportThread1");
        this.reportProcessThread.start();
        dispatchNEStatePool = new TEThreadPool("NEStatusDispatchThreadPool", 10);
    }

    private void startResponsThread() {
        this.responseProcessThread = new Thread(new Runnable(){

            @Override
            public void run() {
                TETaskManager.this.responseHandle();
            }
        });
        this.responseProcessThread.setName("responseThread1");
        this.responseProcessThread.start();
    }

    private void responseHandle() {
        log.info("The thread responseProcessThread1 has start!");
        while (true) {
            TEMessageBlock msgBlock;
            if ((msgBlock = this.deResponseQueue()) == null) {
                continue;
            }
            TEQx5Message qxMsg = (TEQx5Message)msgBlock.getObj();
            try {
                qxMsg.handleMessage();
                continue;
            }
            catch (Exception e) {
                log.info("handleMessage faile,the m_ulMessageSerial of qxMsg is " + qxMsg.ulMessageSerial, (Throwable)e);
                continue;
            }
            break;
        }
    }

    public void enResponseQueue(TEMessageBlock qxMsg) {
        if (!this.responseProcessThread.isAlive()) {
            this.startResponsThread();
        }
        try {
            log.info("one msg is input in responseProcessThread, msg = " + qxMsg);
            this.responseQueue.put(qxMsg);
        }
        catch (InterruptedException e) {
            log.info("enResponseQueue fail , qxMsg =" + qxMsg, (Throwable)e);
        }
    }

    private TEMessageBlock deResponseQueue() {
        TEMessageBlock msg = null;
        try {
            msg = this.responseQueue.take();
            log.info("one msg is output in responseProcessThread, msg = " + msg);
        }
        catch (InterruptedException e) {
            log.info("deResponseQueue fail ", (Throwable)e);
        }
        return msg;
    }

    public void enReportQueue(TEMessageBlock qxMsg) {
        this.reportQueue.enqueue(qxMsg);
        log.info("one msg is input in reportProcessThread, queue capacity = " + this.reportQueue.getSize());
    }

    public TEMessageBlock deReportQueue() {
        TEMessageBlock mb = this.reportQueue.dequeue();
        log.info("one msg is output in reportProcessThread, queue capacity = " + this.reportQueue.getSize());
        return mb;
    }

    public int sendMessage(TEFunInterfaceObject funInterObj) {
        TEFunSrvObjectMessage objMsg = new TEFunSrvObjectMessage(funInterObj);
        return objMsg.handleMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationResult sendCommand(TEFunInterfaceObject funInterObj) {
        if (funInterObj == null) {
            return null;
        }
        TEFunSrvObjectMessage objMsg = new TEFunSrvObjectMessage(funInterObj);
        objMsg.syncHandleMessage();
        TEFunInterfaceObject tEFunInterfaceObject = funInterObj;
        synchronized (tEFunInterfaceObject) {
            while (!funInterObj.messageInsignal) {
                try {
                    log.info(Thread.currentThread().getName() + " wait at lock " + funInterObj);
                    funInterObj.wait((long)(funInterObj.timeOut + 2) * 1000L);
                    funInterObj.messageInsignal = true;
                }
                catch (InterruptedException e) {
                    log.error("sendCommand() Error!", (Throwable)e);
                }
            }
        }
        log.info(Thread.currentThread().getName() + " return operResult: " + funInterObj);
        return funInterObj.operResult;
    }

    public void dispatchMessage(TEFunSrvObjectMessage rsp) {
        if (rsp.syncFlag == 1) {
            this.dispatchCommand(rsp);
        } else if (rsp.syncFlag == 3) {
            this.dispatchCommandAndCheck(rsp);
        } else {
            this.dispatchRequest(rsp);
        }
    }

    public void dispatchRequest(TEFunSrvObjectMessage rsp) {
        this.retCode = 0;
        rsp.funInterfaceObject.operResult = new OperationResult(this.retCode, this.reason);
        rsp.funInterfaceObject.handleResponse(rsp.funInterfaceObject.operationList, rsp.funInterfaceObject.operResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchCommand(TEFunSrvObjectMessage rsp) {
        TEFunInterfaceObject tEFunInterfaceObject = rsp.funInterfaceObject;
        synchronized (tEFunInterfaceObject) {
            rsp.funInterfaceObject.messageInsignal = true;
            this.retCode = 0;
            rsp.funInterfaceObject.operResult = new OperationResult(this.retCode, this.reason);
            log.info(Thread.currentThread().getName() + " NotifyAll at lock " + rsp.funInterfaceObject);
            rsp.funInterfaceObject.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchCommandAndCheck(TEFunSrvObjectMessage rsp) {
        boolean dataValid = rsp.funInterfaceObject.checkDataValid(rsp.funInterfaceObject.operationList, rsp.funInterfaceObject.operResult);
        if (dataValid) {
            TEFunInterfaceObject tEFunInterfaceObject = rsp.funInterfaceObject;
            synchronized (tEFunInterfaceObject) {
                rsp.funInterfaceObject.messageInsignal = true;
                rsp.funInterfaceObject.notifyAll();
            }
        }
    }

    public void dispatchReportListener(long neID, Operation cmd) {
        int cmdKey = cmd.getCmdid();
        ArrayList listnerList = (ArrayList)this.reportListenerMap.get(cmdKey);
        if (listnerList != null && !listnerList.isEmpty()) {
            for (int i = listnerList.size() - 1; i >= 0; --i) {
                NoticeHandler handler = (NoticeHandler)listnerList.get(i);
                int tmpNEID = (int)neID;
                tmpNEID = TENECommMgr.getInstance().getLogicNEID(tmpNEID);
                handler.handleNotice(cmdKey, tmpNEID, cmd);
            }
        }
    }

    public void registerListener(Operation oper, NoticeHandler handle) {
        int cmdCode = oper.getCmdid();
        ArrayList<NoticeHandler> listnerList = (ArrayList<NoticeHandler>)this.reportListenerMap.get(cmdCode);
        TEQx5ProtocolImpl.instance().addQx5ReportCmdAdapter(cmdCode, TEFunSrvDataQx5MessageAdapter.instance());
        if (listnerList != null) {
            listnerList.add(handle);
        } else {
            listnerList = new ArrayList<NoticeHandler>();
            listnerList.add(handle);
            this.reportListenerMap.put(cmdCode, listnerList);
        }
        this.reportCmdIDToOperationMap.put(cmdCode, oper);
    }

    public void registerNEStateListener(int neID, NEStateNoticeHandle rspHandler) {
        if (!this.neStateMap.containsKey(neID)) {
            this.neStateMap.put(neID, rspHandler);
        }
    }

    public void unregisterNEStateListener(int neID) {
        if (this.neStateMap.containsKey(neID)) {
            this.neStateMap.remove(neID);
        }
    }

    public void registerNENMIDListener(int neID, NENMIDHandle rspHandler) {
        this.neNMIDMap.put(neID, rspHandler);
    }

    public void unregisterNENMIDListener(int neID) {
        if (this.neNMIDMap.containsKey(neID)) {
            this.neNMIDMap.remove(neID);
        }
    }

    public void dispatchNEState(final int neID, final boolean neConnectState) {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                int neState = 1;
                NEStateNoticeHandle rspHandler = (NEStateNoticeHandle)TETaskManager.this.neStateMap.get(neID);
                neState = neConnectState ? 1 : 0;
                if (rspHandler != null) {
                    rspHandler.handleNoticeNeStateChange(neID, neState);
                }
            }
        };
        dispatchNEStatePool.runTask(task);
    }

    public void dispatchNENMIDState(int neID, boolean succToApplyNMID) {
        NENMIDHandle rspHandler = (NENMIDHandle)this.neNMIDMap.get(neID);
        if (rspHandler != null) {
            rspHandler.handleNoticeNeNMID(neID, succToApplyNMID);
        }
    }

    public Operation getReportOperation(int cmdCode) {
        Operation oper = (Operation)this.reportCmdIDToOperationMap.get(cmdCode);
        return (Operation)oper.clone();
    }

    public void unRegisterListener(Operation oper, NoticeHandler handle) {
        if (oper == null) {
            return;
        }
        int cmdCode = oper.getCmdid();
        ArrayList listenList = (ArrayList)this.reportListenerMap.get(cmdCode);
        if (handle == null || listenList == null || listenList.isEmpty()) {
            return;
        }
        listenList.remove(handle);
        if (listenList.isEmpty()) {
            TEQx5ProtocolImpl.instance().deleteQx5ReportCmdAdapter(cmdCode);
            this.reportCmdIDToOperationMap.remove(cmdCode);
        }
    }

    public Map getNMIDMap() {
        return (Map)((HashMap)this.neNMIDMap).clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleOut(TEMessage pMessage, byte[] pUserData, int ErrCode) {
        if (pMessage instanceof TEFunSrvObjectMessage) {
            TEFunSrvObjectMessage rsp = (TEFunSrvObjectMessage)pMessage;
            if (rsp.syncFlag == 1) {
                TEFunInterfaceObject tEFunInterfaceObject = rsp.funInterfaceObject;
                synchronized (tEFunInterfaceObject) {
                    rsp.funInterfaceObject.operationList = null;
                    this.retCode = 1090650120;
                    rsp.funInterfaceObject.operResult = new OperationResult(this.retCode, this.reason);
                    rsp.funInterfaceObject.messageInsignal = true;
                    log.info(Thread.currentThread().getName() + "NotifyAll at lock " + rsp.funInterfaceObject);
                    rsp.funInterfaceObject.notifyAll();
                }
            } else if (rsp.syncFlag == 3) {
                TEFunInterfaceObject tEFunInterfaceObject = rsp.funInterfaceObject;
                synchronized (tEFunInterfaceObject) {
                    rsp.funInterfaceObject.messageInsignal = true;
                    rsp.funInterfaceObject.notifyAll();
                    rsp.funInterfaceObject.handleTimeout();
                }
            } else {
                rsp.funInterfaceObject.handleTimeout();
            }
        }
    }

    public boolean isCmdKeyRegregisted(int cmdKey) {
        return this.reportCmdIDToOperationMap.containsKey(cmdKey);
    }
}

