/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.qxprotocol;

import com.huawei.uflight.necomm.IOStreamConvertor;
import com.huawei.uflight.necomm.TECommConnection;
import com.huawei.uflight.necomm.TECommInfo;
import com.huawei.uflight.necomm.TECommunicationMgr;
import com.huawei.uflight.necomm.osgi.NECommActivator;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.TETaskManager;
import com.huawei.uflight.qxprotocol.qx5adapter.QxFrameSet;
import com.huawei.uflight.qxprotocol.qx5adapter.TEQxCommuMgr;
import com.huawei.uflight.qxprotocol.qx5adapter.TEQxFrame;
import com.huawei.uflight.qxprotocol.qx5adapter.TEQxFrameHead;
import com.huawei.uflight.qxprotocol.qx5adapter.TEQxPacket;
import com.huawei.uflight.qxprotocol.qx5adapter.TEQxPacketHead;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TENEInfo
implements TECommConnection {
    private volatile int neGateWay = -1;
    private volatile int nPortNo = 0;
    private int neCommType;
    private int nRecycleCount = 0;
    private int connectState = 1;
    public long iNeId = 0L;
    private long neVersion = 0x4010000L;
    private volatile boolean bConnected = true;
    private boolean bNeIdValid = false;
    private Map packetMap = new ConcurrentHashMap();
    public TECommInfo commInfo = null;
    private static Logger logger = LoggerFactory.getLogger(TENEInfo.class);

    public TENEInfo(long neID, TECommInfo commInfo) {
        this.iNeId = neID;
        this.nRecycleCount = 0;
        this.bConnected = false;
        this.bNeIdValid = false;
        this.commInfo = commInfo;
        this.nPortNo = 101;
    }

    public boolean sendNERecyclePacket() {
        if (this.commInfo == null) {
            Map<TENEInfo, TECommInfo> commInfoMap = TEQxCommuMgr.instance().getCommuInfo();
            this.commInfo = commInfoMap.get(this);
        }
        if (this.commInfo.getCommType() == 2) {
            return true;
        }
        boolean bConnectChange = false;
        ++this.nRecycleCount;
        if (this.nRecycleCount > 3) {
            LoggerFactory.getLogger(this.getClass()).info("the count of sendNERecyclePacket is over three, neid = " + this.iNeId);
            if (this.bConnected) {
                bConnectChange = true;
            }
            this.bConnected = false;
        }
        if (bConnectChange) {
            return false;
        }
        TEQxPacketHead head = new TEQxPacketHead();
        head.init();
        int realNeid = TENECommMgr.getInstance().getNEID((int)this.iNeId);
        head.fillPacketHead(realNeid, 2);
        String str = IOStreamConvertor.getStringFromByteArray(head.getPacketHead());
        LoggerFactory.getLogger(this.getClass()).info("TENEInfo sendNERecyclePacket: Send NM Recycle Packet,neid = " + this.iNeId);
        LoggerFactory.getLogger(this.getClass()).info(str);
        TECommunicationMgr.instance().sendUrgent(this.commInfo, head.getPacketHead(), head.getQxPacketHeadSize());
        return true;
    }

    public boolean sendNELinkPacket(TENEInfo neInfo) {
        if (this.commInfo == null) {
            Map<TENEInfo, TECommInfo> commInfoMap = TEQxCommuMgr.instance().getCommuInfo();
            this.commInfo = commInfoMap.get(this);
        }
        if (this.commInfo.getCommType() == 2) {
            return true;
        }
        TEQxPacketHead packetHead = new TEQxPacketHead();
        packetHead.init();
        int realNeid = TENECommMgr.getInstance().getNEID((int)this.iNeId);
        packetHead.fillPacketHead(realNeid, 0);
        packetHead.nLen = 4;
        TEQxFrameHead frameHead = new TEQxFrameHead();
        frameHead.init();
        frameHead.byAckFlag = 0;
        frameHead.byFrameType = (short)5;
        frameHead.byFrameSerial = 0;
        byte[] bufVec = new byte[packetHead.getQxPacketHeadSize() + 4];
        System.arraycopy(packetHead.getPacketHead(), 0, bufVec, 0, packetHead.getQxPacketHeadSize());
        System.arraycopy(frameHead.getFrameHead(), 0, bufVec, packetHead.getQxPacketHeadSize(), 4);
        String str = IOStreamConvertor.getStringFromByteArray(bufVec);
        LoggerFactory.getLogger(this.getClass()).info("send Link Recycle Packet.");
        LoggerFactory.getLogger(this.getClass()).info(str);
        int ret = TECommunicationMgr.instance().sendUrgent(this.commInfo, bufVec, bufVec.length);
        if (ret < 0) {
            LoggerFactory.getLogger(this.getClass()).info("link Recycle Packet does not put in comm.");
            return false;
        }
        return true;
    }

    public int sendNMIDPacket(int usCmdId) {
        TEQxCommuMgr instance = TEQxCommuMgr.instance();
        Map<TENEInfo, TECommInfo> commInfoMap = instance.getCommuInfo();
        this.commInfo = commInfoMap.get(this);
        if (this.commInfo.getCommType() == 2) {
            return 0;
        }
        TEQxPacketHead packetHead = new TEQxPacketHead();
        packetHead.init();
        packetHead.fillPacketHead(0L, usCmdId);
        packetHead.nLen = 1;
        ++this.nPortNo;
        if (this.nPortNo > 116) {
            this.nPortNo = 101;
        }
        int nOffset = 0;
        byte[] nmidPacket = new byte[packetHead.getQxPacketHeadSize() + 1];
        byte[] tmpByte = IOStreamConvertor.int2Bytes((int)packetHead.ulDstAddr);
        System.arraycopy(tmpByte, 0, nmidPacket, nOffset, 4);
        tmpByte = IOStreamConvertor.int2Bytes((int)packetHead.ulSrcAddr);
        System.arraycopy(tmpByte, 0, nmidPacket, nOffset += 4, 4);
        tmpByte = IOStreamConvertor.unsignedShort2Bytes(packetHead.nType);
        System.arraycopy(tmpByte, 0, nmidPacket, nOffset += 4, 2);
        tmpByte = IOStreamConvertor.unsignedShort2Bytes(packetHead.nLen);
        System.arraycopy(tmpByte, 0, nmidPacket, nOffset += 2, 2);
        tmpByte = IOStreamConvertor.int2Bytes((int)packetHead.ulReserved);
        System.arraycopy(tmpByte, 0, nmidPacket, nOffset += 2, 4);
        tmpByte = new byte[]{(byte)this.nPortNo};
        System.arraycopy(tmpByte, 0, nmidPacket, nOffset += 4, 1);
        ++nOffset;
        String str = IOStreamConvertor.getStringFromByteArray(nmidPacket);
        LoggerFactory.getLogger(this.getClass()).info("sendNMIDPacket: " + str);
        return TECommunicationMgr.instance().sendUrgent(this.commInfo, nmidPacket, 20000);
    }

    public byte[] handleQxFrame(TENEInfo handle, TEQxPacket packet) {
        int usCheckSum;
        byte[] nullBytes = new byte[]{};
        TEQxFrame pFrame = new TEQxFrame();
        int ret = pFrame.readFromStream(packet.dataBufVec);
        logger.info("TENEInfo handleQxFrame :the data packet putted in data packet set.");
        if (ret != 0) {
            LoggerFactory.getLogger(this.getClass()).info("TENEInfo handleQxFrame: (Error) Frame read from stream " + ret);
            return nullBytes;
        }
        switch (pFrame.m_FrameHead.byFrameType) {
            case 1: {
                TEQxCommuMgr.instance().deletePacket(pFrame.m_FrameHead.nPacketSerial);
                TEQxCommuMgr.instance().sendCommandFrame(handle, packet.packetHead, pFrame.m_FrameHead, 1);
                return nullBytes;
            }
            case 3: {
                TEQxCommuMgr.instance().resendPacket(pFrame.m_FrameHead.nPacketSerial);
                return nullBytes;
            }
            case 0: {
                break;
            }
            default: {
                return nullBytes;
            }
        }
        if (handle.neCommType == 2 && pFrame.m_FrameHead.nCheckSum != (usCheckSum = TEQxCommuMgr.instance().calCheckSum(pFrame.m_BufVec, 0, pFrame.m_FrameHead.nDataLen))) {
            LoggerFactory.getLogger(this.getClass()).info("TENEInfo handleQxFrame: Check sum err! ");
            TEQxCommuMgr.instance().sendCommandFrame(handle, packet.packetHead, pFrame.m_FrameHead, 3);
            return nullBytes;
        }
        int usPacketSerial = pFrame.m_FrameHead.nPacketSerial;
        short ucFrameSerial = pFrame.m_FrameHead.byFrameSerial;
        QxFrameSet pFrameSet = (QxFrameSet)this.packetMap.get(usPacketSerial);
        if (pFrameSet != null) {
            pFrameSet.insert(ucFrameSerial, pFrame);
        } else {
            pFrameSet = new QxFrameSet();
            pFrameSet.insert(ucFrameSerial, pFrame);
            this.packetMap.put(usPacketSerial, pFrameSet);
        }
        int receiverFrameNum = pFrameSet.getTotalFrameNum();
        logger.info("receiverFrame packetSerial is " + pFrame.m_FrameHead.byFrameSerial + ",  datasize  is " + pFrame.m_FrameHead.nDataLen);
        logger.info("receiverFrameNum is " + receiverFrameNum + ", Total framenum is " + pFrame.m_FrameHead.byFrameNum);
        if (receiverFrameNum == pFrame.m_FrameHead.byFrameNum) {
            this.packetMap.remove(usPacketSerial);
            if (pFrame.m_FrameHead.byAckFlag == 255) {
                LoggerFactory.getLogger(this.getClass()).info("TENEInfo handleQxFrame: send ack frame.");
                TEQxCommuMgr.instance().sendCommandFrame(handle, packet.packetHead, pFrame.m_FrameHead, 1);
            }
            return pFrameSet.getAllData();
        }
        logger.info("TENEInfo handleQxFrame: data Packet is not over");
        return nullBytes;
    }

    public byte[] handleQxPacket(TEQxPacket packet) {
        byte[] nullBytes = new byte[]{};
        boolean bConnectChange = false;
        if (!this.bConnected) {
            this.bConnected = true;
            bConnectChange = true;
        }
        this.nRecycleCount = 0;
        if (bConnectChange) {
            logger.error("The neid(neid=" + this.iNeId + ") bConnectChange is handleQxPacket");
            TETaskManager.instance().dispatchNEState((int)this.iNeId, this.bConnected);
        }
        switch (packet.packetHead.nType) {
            case 0: {
                long ulDstAddr = packet.packetHead.ulDstAddr;
                long ulSrcAddr = packet.packetHead.ulSrcAddr;
                this.neGateWayCompare(ulDstAddr, ulSrcAddr);
                return this.handleQxFrame(this, packet);
            }
            case 1: {
                packet.packetHead.ulDstAddr = packet.packetHead.ulSrcAddr;
                packet.packetHead.ulSrcAddr = 0L;
                int nOffset = 0;
                byte[] packetHead = new byte[packet.packetHead.getQxPacketHeadSize()];
                byte[] tmpByte = IOStreamConvertor.int2Bytes((int)packet.packetHead.ulDstAddr);
                System.arraycopy(tmpByte, 0, packetHead, nOffset, 4);
                tmpByte = IOStreamConvertor.int2Bytes((int)packet.packetHead.ulSrcAddr);
                System.arraycopy(tmpByte, 0, packetHead, nOffset += 4, 4);
                tmpByte = IOStreamConvertor.unsignedShort2Bytes(packet.packetHead.nType);
                System.arraycopy(tmpByte, 0, packetHead, nOffset += 4, 2);
                tmpByte = IOStreamConvertor.unsignedShort2Bytes(packet.packetHead.nLen);
                System.arraycopy(tmpByte, 0, packetHead, nOffset += 2, 2);
                tmpByte = IOStreamConvertor.int2Bytes((int)packet.packetHead.ulReserved);
                System.arraycopy(tmpByte, 0, packetHead, nOffset += 2, 4);
                String str = IOStreamConvertor.getStringFromByteArray(packetHead);
                LoggerFactory.getLogger(this.getClass()).info("TENEInfo handleQxPacket: send ne recycle frame.");
                LoggerFactory.getLogger(this.getClass()).info(str);
                int ret = TECommunicationMgr.instance().sendUrgent(this.commInfo, packetHead, 20000);
                if (ret > 0) {
                    LoggerFactory.getLogger(this.getClass()).info("TENEInfo handleQxPacket\u00a3\u00ba ne recycle frame");
                }
                return nullBytes;
            }
            case 2: {
                LoggerFactory.getLogger(this.getClass()).info("TENEInfo handleQxPacket\u00a3\u00ba Received NM Recycle Frame, so the network is working.");
                break;
            }
            case 100: {
                break;
            }
            case 103: {
                long ulRsp = IOStreamConvertor.readUnsignedInt(packet.dataBufVec, 0);
                switch ((int)ulRsp) {
                    case 0: {
                        LoggerFactory.getLogger(this.getClass()).info("Succeed NMID: " + this.nPortNo + "  neid = " + this.iNeId);
                        TEQxCommuMgr.instance().setNeCommPortStatus(this, TEQxCommuMgr.PORT_STATUS.APPLYEND);
                        new Thread(new Runnable(){

                            @Override
                            public void run() {
                                TETaskManager.instance().dispatchNENMIDState((int)TENEInfo.this.iNeId, true);
                            }
                        }).start();
                        LoggerFactory.getLogger(this.getClass()).info("TENEInfo handleQxPacket: send NMID to NE  Succeed!, neid = " + this.iNeId);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        LoggerFactory.getLogger(this.getClass()).info("Failed NMID: " + this.nPortNo + "  neid = " + this.iNeId);
                        LoggerFactory.getLogger(this.getClass()).info("TENEInfo handleQxPacket :the port is used, please send the NMID packet ,code = " + ulRsp);
                        this.sendNMIDPacket(104);
                        break;
                    }
                    default: {
                        LoggerFactory.getLogger(this.getClass()).info("TENEInfo handleQxPacket :other error -5");
                        return nullBytes;
                    }
                }
                return nullBytes;
            }
            default: {
                LoggerFactory.getLogger(this.getClass()).info("TENEInfo handleQxPacket Qx5 Packet type:other error " + packet.packetHead.nType);
                return nullBytes;
            }
        }
        return nullBytes;
    }

    public boolean isSuccToApplyNMID() {
        if (this.isIntegratedMode()) {
            return true;
        }
        return TEQxCommuMgr.instance().getNeCommPortStatus(this).equals((Object)TEQxCommuMgr.PORT_STATUS.APPLYEND);
    }

    public void setNEVersion(long neVersion) {
        this.neVersion = neVersion;
    }

    public long getNEVersion() {
        return this.neVersion;
    }

    private void neGateWayCompare(long ulDstAddr, long ulSrcAddr) {
        this.neGateWay = (ulDstAddr &= 0xFFFFFFL) == (ulSrcAddr &= 0xFFFFFFL) ? 1 : 2;
    }

    public void setNEGateWay(int neGateWay) {
        this.neGateWay = neGateWay;
    }

    public int getNEGateWay() {
        return this.neGateWay;
    }

    @Override
    public synchronized void connectStateChanged(int connectState) {
        TEQxCommuMgr.PORT_STATUS status;
        if (connectState == 0) {
            this.connectState = 1;
            this.bConnected = true;
        } else {
            this.connectState = 0;
            status = TEQxCommuMgr.instance().getNeCommPortStatus(this);
            if (TEQxCommuMgr.PORT_STATUS.APPLYEND.equals((Object)status)) {
                TEQxCommuMgr.instance().setNeCommPortStatus(this, TEQxCommuMgr.PORT_STATUS.UN_APPLY);
                LoggerFactory.getLogger(this.getClass()).info("setNeCommPortStatus is UN_APPLY , neid is " + this.iNeId);
            }
            this.bConnected = false;
        }
        if (connectState == 0) {
            LoggerFactory.getLogger(this.getClass()).info("this neid state is CONNECTED,neid =" + this.iNeId);
            if (!this.isSuccToApplyNMID()) {
                status = TEQxCommuMgr.instance().getNeCommPortStatus(this);
                logger.info("start send nmid , neid = " + this.iNeId + "port status is " + (Object)((Object)status));
                if (TEQxCommuMgr.PORT_STATUS.UN_APPLY.equals((Object)status) || TEQxCommuMgr.PORT_STATUS.APPLYFAIL.equals((Object)status)) {
                    this.applyNMIDPacket();
                }
            }
        } else {
            LoggerFactory.getLogger(this.getClass()).info("this neid state is no CONNECTED,neid =" + this.iNeId);
        }
        TETaskManager.instance().dispatchNEState((int)this.iNeId, this.bConnected);
    }

    public void applyNMIDPacket() {
        TEQxCommuMgr.instance().setNeCommPortStatus(this, TEQxCommuMgr.PORT_STATUS.APPLYING);
        int retcode = this.sendNMIDPacket(104);
        if (retcode < 0) {
            TEQxCommuMgr.instance().setNeCommPortStatus(this, TEQxCommuMgr.PORT_STATUS.APPLYFAIL);
            LoggerFactory.getLogger(this.getClass()).info("send NMID to NE fail ! neid = " + this.iNeId + "ret code = " + retcode);
        }
    }

    public int getConnectState() {
        return this.connectState;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TENEInfo)) {
            return false;
        }
        return this.iNeId == ((TENEInfo)obj).iNeId;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (int)this.iNeId;
        return result;
    }

    private boolean isIntegratedMode() {
        return NECommActivator.isIntegratedMode();
    }

    public void deleteTimeOutPacket() {
        Set entries = this.packetMap.entrySet();
        Date arriveDate = new Date();
        for (Map.Entry entry : entries) {
            QxFrameSet packet = (QxFrameSet)entry.getValue();
            long interval = System.currentTimeMillis() - packet.getFirstFrameArriveTime();
            if (interval < 1800000L) continue;
            arriveDate.setTime(packet.getFirstFrameArriveTime());
            LoggerFactory.getLogger(this.getClass()).info("remove timeout packet from packetMap :packetSerial = " + entry.getKey() + "; first frame of the packet arrived at " + arriveDate + "; timeout = " + 1800L + "(s)");
            this.packetMap.remove(entry.getKey());
        }
    }
}

