/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.qxprotocol;

import com.huawei.uflight.necomm.TECommInfo;
import com.huawei.uflight.qxprotocol.MsgHandler;
import com.huawei.uflight.qxprotocol.NENMIDHandle;
import com.huawei.uflight.qxprotocol.NEStateNoticeHandle;
import com.huawei.uflight.qxprotocol.NoticeHandler;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.QxNEConnectInfo;
import com.huawei.uflight.qxprotocol.TEFunInterfaceObject;
import com.huawei.uflight.qxprotocol.TENEInfo;
import com.huawei.uflight.qxprotocol.TETaskManager;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.qx5adapter.TEQxCommuMgr;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TENECommMgr {
    private static TENECommMgr instance = null;
    private Map<Long, Long> logicID2PhyIDMap = new Hashtable<Long, Long>();
    private Map<Long, Long> phyID2LoginIDMap = new Hashtable<Long, Long>();
    private Map<Long, String> charsetMap = new Hashtable<Long, String>();
    private HashSet<Integer> filterLogCmds = new HashSet();
    private Logger log = LoggerFactory.getLogger(TENECommMgr.class);

    public static synchronized TENECommMgr getInstance() {
        if (null == instance) {
            instance = new TENECommMgr();
        }
        return instance;
    }

    public int sendMessage(int neID, List<Operation> operationList, MsgHandler handler, int timeOut) {
        TEFunInterfaceObject funObj = new TEFunInterfaceObject(neID, handler, operationList, timeOut);
        TENEInfo neInfo = TEQxCommuMgr.instance().getNECommuInfo(neID);
        if (neInfo != null) {
            funObj.version = neInfo.getNEVersion();
        }
        funObj.msgType = (byte)2;
        int retCode = 0;
        if (neInfo != null && neInfo.getConnectState() == 1) {
            retCode = TETaskManager.instance().sendMessage(funObj);
        } else {
            this.log.error("The neid(neid=" + neID + ") not register or ne status is abort.");
            retCode = -10;
        }
        if (retCode < 0) {
            return retCode;
        }
        return funObj.getSerial();
    }

    public OperationResult sendCommand(int neID, List<Operation> operList, int timeOut) {
        return this.sendCommand(neID, operList, null, timeOut);
    }

    public OperationResult sendCommandNoLog(int neID, List<Operation> operList, int timeOut) {
        TEFunInterfaceObject funObj = this.buildFunObject(neID, operList, null, timeOut);
        funObj.setWriteLog(false);
        return this.sendCommand(funObj);
    }

    public OperationResult sendCommand(int neID, List<Operation> operationList, int timeOut, boolean transFlag) {
        return this.sendCommand(neID, operationList, null, timeOut, transFlag);
    }

    public OperationResult sendCommand(int neID, List<Operation> operList, MsgHandler rspHandler, int timeOut, boolean transFlag) {
        TEFunInterfaceObject funObj = new TEFunInterfaceObject(neID, rspHandler, operList, timeOut, transFlag);
        TENEInfo neInfo = TEQxCommuMgr.instance().getNECommuInfo(neID);
        if (neInfo != null) {
            funObj.version = neInfo.getNEVersion();
        }
        funObj.msgType = null == rspHandler ? (byte)1 : (byte)3;
        if (neInfo != null && neInfo.getConnectState() == 1) {
            return TETaskManager.instance().sendCommand(funObj);
        }
        this.log.error("The neid(neid=" + neID + ") not register or ne status is abort.");
        OperationResult operResult = new OperationResult(1090617361, "");
        return operResult;
    }

    public OperationResult sendCommand(int neID, List<Operation> operList, MsgHandler rspHandler, int timeOut) {
        TEFunInterfaceObject funObj = this.buildFunObject(neID, operList, rspHandler, timeOut);
        return this.sendCommand(funObj);
    }

    private TEFunInterfaceObject buildFunObject(int neID, List<Operation> operList, MsgHandler rspHandler, int timeOut) {
        TEFunInterfaceObject funObj = new TEFunInterfaceObject(neID, rspHandler, operList, timeOut);
        funObj.msgType = null == rspHandler ? (byte)1 : (byte)3;
        return funObj;
    }

    private OperationResult sendCommand(TEFunInterfaceObject funObj) {
        TENEInfo neInfo = TEQxCommuMgr.instance().getNECommuInfo(funObj.neID);
        if (neInfo != null) {
            funObj.version = neInfo.getNEVersion();
        }
        if (neInfo != null && neInfo.getConnectState() == 1) {
            return TETaskManager.instance().sendCommand(funObj);
        }
        this.log.error("The neid(neid=" + funObj.neID + ") not register or ne status is abort.");
        OperationResult operResult = new OperationResult(1090617361, "");
        return operResult;
    }

    public void putLogicNEID(long neID, long logicNEID) {
        this.logicID2PhyIDMap.put(logicNEID, neID);
        this.phyID2LoginIDMap.put(neID, logicNEID);
        this.log.info("put neID and LogicNEID map, the neID=" + neID + ",logicNEID=" + logicNEID);
    }

    public void putCharset(long logicNEID, String charsetName) {
        this.charsetMap.put(logicNEID, charsetName);
        this.log.info("put LogicNEID and charsetName map, the logicNEID=" + logicNEID + ",charsetName=" + charsetName);
    }

    public int getNEID(long logicNEID) {
        Long phyID = this.logicID2PhyIDMap.get(logicNEID);
        this.log.info("getNEID logicNEID = " + logicNEID + "phyID NEID = " + phyID);
        if (phyID == null) {
            return -1;
        }
        return phyID.intValue();
    }

    public void deleteNEID(long logicNEID) {
        Long phyID = this.logicID2PhyIDMap.remove(logicNEID);
        this.phyID2LoginIDMap.remove(phyID);
        this.charsetMap.remove(logicNEID);
        this.log.info("delete LogicNEID, the logicNEID=" + logicNEID);
    }

    public int getLogicNEID(int neID) {
        Long logicNEID = this.phyID2LoginIDMap.get(neID);
        if (logicNEID == null) {
            logicNEID = this.phyID2LoginIDMap.get(0L);
            if (logicNEID != null) {
                this.deleteNEID(logicNEID);
                this.putLogicNEID(neID, logicNEID);
            } else {
                return -1;
            }
        }
        return logicNEID.intValue();
    }

    public int createConect(QxNEConnectInfo connectInfo) {
        return TEQxCommuMgr.instance().createConect(connectInfo);
    }

    public int createConect(long logicNeID, int port, String ipAddress, int commType) {
        QxNEConnectInfo connectInfo = new QxNEConnectInfo();
        connectInfo.setLogicNeID(logicNeID);
        connectInfo.setPort(port);
        connectInfo.setIpAddress(ipAddress);
        connectInfo.setCommType(commType);
        return this.createConect(connectInfo);
    }

    public int createConect(long logicNeID, int port, String ipAddress, int commType, String baudrate) {
        QxNEConnectInfo connectInfo = new QxNEConnectInfo();
        connectInfo.setLogicNeID(logicNeID);
        connectInfo.setPort(port);
        connectInfo.setIpAddress(ipAddress);
        connectInfo.setCommType(commType);
        connectInfo.setBaudrate(baudrate);
        return this.createConect(connectInfo);
    }

    public int closeConnect(long neID, int port, String ipAddress, int commType) {
        this.log.info("closeConnect :logicNEID=" + neID + ",ipAddress=" + ipAddress + ",port=" + port + "commType=" + commType);
        return TEQxCommuMgr.instance().closeConnect(neID, port, ipAddress, commType);
    }

    public boolean refreshConnect(long neID, int port, String ipAddress, int commType) {
        return TEQxCommuMgr.instance().refreshConnect(neID, port, ipAddress, commType);
    }

    public int getNeVersion(long neID) {
        int neVersion = 0x4010000;
        TENEInfo neInfo = TEQxCommuMgr.instance().getNECommuInfo(neID);
        if (neInfo == null) {
            LoggerFactory.getLogger(this.getClass()).info("TEQxCommuMgr getNECommuInfo: No GateWay NE");
            return neVersion;
        }
        neVersion = (int)neInfo.getNEVersion();
        return neVersion;
    }

    public void registerListener(Operation oper, NoticeHandler rspHandler) {
        TETaskManager.instance().registerListener(oper, rspHandler);
    }

    public void unregisterListener(Operation oper, NoticeHandler rspHandler) {
        TETaskManager.instance().unRegisterListener(oper, rspHandler);
    }

    public void registerNEStateListener(int neID, NEStateNoticeHandle rspHandler) {
        TETaskManager.instance().registerNEStateListener(neID, rspHandler);
    }

    public void unregisterNEStateListener(int neID) {
        TETaskManager.instance().unregisterNEStateListener(neID);
    }

    public void registerNENMIDListener(int neID, NENMIDHandle rspHandler) {
        TETaskManager.instance().registerNENMIDListener(neID, rspHandler);
    }

    public void unregisterNENMIDListener(int neID) {
        TETaskManager.instance().unregisterNENMIDListener(neID);
    }

    public TECommInfo getCommInfo(int neID) {
        return TEQxCommuMgr.instance().getCommInfo(neID);
    }

    String getNECharset(long logicNEID) {
        return this.charsetMap.get(logicNEID);
    }

    public int getNEGateWay(long logicNEID) {
        TENEInfo neInfo = TEQxCommuMgr.instance().getNECommuInfo(logicNEID);
        if (neInfo == null) {
            LoggerFactory.getLogger(this.getClass()).info("TEQxCommuMgr getNECommuInfo: No GateWay NE");
            return -1;
        }
        return neInfo.getNEGateWay();
    }

    public synchronized void addFilterLogCmds(HashSet<Integer> flogCmds) {
        if (flogCmds != null) {
            this.filterLogCmds.addAll(flogCmds);
        }
    }

    public HashSet<Integer> getFilterLogCmds() {
        return this.filterLogCmds;
    }
}

