/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.qxprotocol;

import com.huawei.uflight.necomm.IOStreamConvertor;
import com.huawei.uflight.qxprotocol.TEAdapterManager;
import com.huawei.uflight.qxprotocol.TECharsetConverter;
import com.huawei.uflight.qxprotocol.TECommand;
import com.huawei.uflight.qxprotocol.TEFunInterfaceProtocolAdapter;
import com.huawei.uflight.qxprotocol.TEFunSrvObjectMessage;
import com.huawei.uflight.qxprotocol.TEMessage;
import com.huawei.uflight.qxprotocol.TEMessageAdapter;
import com.huawei.uflight.qxprotocol.TEMessageInfo;
import com.huawei.uflight.qxprotocol.TEMessageUnit;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.TEProtocolAdapter;
import com.huawei.uflight.qxprotocol.TETaskManager;
import com.huawei.uflight.qxprotocol.definitions.Fault;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import com.huawei.uflight.qxprotocol.qx5adapter.TEQx5Command;
import com.huawei.uflight.qxprotocol.qx5adapter.TEQx5Message;
import com.huawei.uflight.qxprotocol.qx5adapter.TEQx5ProtocolAdapter;
import com.huawei.uflight.util.SecurityUtil;
import java.nio.charset.CharacterCodingException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TEFunSrvDataQx5MessageAdapter
extends TEMessageAdapter {
    private static TEFunSrvDataQx5MessageAdapter instanceObj = null;
    private static final int SLOTCONSTATNS = 65536;
    private static Logger log = LoggerFactory.getLogger(TEFunSrvDataQx5MessageAdapter.class);

    public TEFunSrvDataQx5MessageAdapter(TEProtocolAdapter pSrcProtocol, TEProtocolAdapter pSinkProtocol) {
        super(pSrcProtocol, pSinkProtocol);
    }

    public static synchronized TEFunSrvDataQx5MessageAdapter instance() {
        if (instanceObj == null) {
            instanceObj = new TEFunSrvDataQx5MessageAdapter(TEFunInterfaceProtocolAdapter.instance(), TEQx5ProtocolAdapter.instance());
        }
        return instanceObj;
    }

    public int handleMessage(TEMessage pMessage, boolean isWriteLog) {
        TEQx5Message pQx5Msg = new TEQx5Message(pMessage.isTransFlag());
        TEFunSrvObjectMessage funMsg = (TEFunSrvObjectMessage)pMessage;
        pQx5Msg.ulNeId = funMsg.getNeId();
        pQx5Msg.ulVersion = funMsg.getVersion();
        pQx5Msg.setWriteLog(isWriteLog);
        List<Operation> list = funMsg.funInterfaceObject.operationList;
        List cmdList = null;
        int nRet = 0;
        try {
            cmdList = this.convertOperationToQxCmd(list, pQx5Msg.ulNeId);
            funMsg.funInterfaceObject.initSerial();
            pQx5Msg.addQx5CommandList(cmdList);
            this.registerPrivateMessage(pMessage, this, null, pMessage.timeOut);
            this.registerMessage(pMessage, pQx5Msg);
            nRet = pQx5Msg.handleMessage();
        }
        catch (CharacterCodingException e) {
            nRet = -1090615065;
            funMsg.funInterfaceObject.messageInsignal = true;
            funMsg.funInterfaceObject.operResult.retCode = nRet;
        }
        return nRet;
    }

    public List convertOperationToQxCmd(List<Operation> operationList, long neid) throws CharacterCodingException {
        ArrayList<TEQx5Command> cmdList = new ArrayList<TEQx5Command>();
        if (operationList == null || operationList.isEmpty()) {
            log.info("TEFunSrvDataQx5MessageAdapter convertOperationToQxCmd:No Data.");
            return null;
        }
        int size = operationList.size();
        for (int i = 0; i < size; ++i) {
            Operation curOper = operationList.get(i);
            TEQx5Command cmd = new TEQx5Command(curOper.getCmdid());
            cmd.setAckMode(curOper.getAckMode());
            curOper.setCmdSerial(cmd.getSerial());
            Input partList = curOper.getInput();
            int paraLength = 0;
            int offSetPosition = 0;
            for (int paraIndex = 0; paraIndex < partList.getPartCount(); ++paraIndex) {
                Part curPara = partList.getPart(paraIndex);
                byte[] paraByte = this.getParaByte(curPara, neid);
                paraLength = null != paraByte ? paraByte.length : 0;
                boolean preFill = curPara.getPrefilled();
                cmd.setData(offSetPosition, paraLength, paraByte, preFill);
                offSetPosition += paraLength;
            }
            cmdList.add(cmd);
        }
        log.info("convertOperationToQxCmd: " + cmdList);
        return cmdList;
    }

    private byte[] getParaByte(Part pPara, long neid) throws CharacterCodingException {
        int paraLength = pPara.getLength();
        String paraType = pPara.getType();
        String paraValue = pPara.getValue();
        boolean slotFlag = false;
        boolean neFlag = false;
        boolean subrackFlag = false;
        slotFlag = pPara.getSlotConvertFlag();
        neFlag = pPara.getNEConvertFlag();
        subrackFlag = pPara.getSubrackConvertFlag();
        if (null == paraType || null == paraValue) {
            log.info("");
            return null;
        }
        if ("BYTE".equalsIgnoreCase(paraType)) {
            int intValue = Integer.parseInt(paraValue);
            if (slotFlag) {
                intValue = this.slotIDNMToNE(intValue);
            }
            byte[] intByte = IOStreamConvertor.unsignedShort2Bytes(intValue);
            byte[] byteByte = new byte[1];
            System.arraycopy(intByte, 1, byteByte, 0, 1);
            return byteByte;
        }
        if ("INT".equalsIgnoreCase(paraType)) {
            int tempValue;
            int intValue = tempValue = Integer.parseInt(paraValue);
            if (slotFlag) {
                intValue = this.slotIDNMToNE(tempValue);
            }
            if (subrackFlag) {
                intValue = this.subrackIDNMToNE(tempValue);
            }
            byte[] intByte = IOStreamConvertor.unsignedShort2Bytes(intValue);
            return intByte;
        }
        if ("LONG".equalsIgnoreCase(paraType)) {
            long longValue = Long.parseLong(paraValue);
            if (neFlag && longValue > 0L) {
                longValue = TENECommMgr.getInstance().getNEID((int)longValue);
            }
            byte[] longByte = IOStreamConvertor.int2Bytes((int)longValue);
            return longByte;
        }
        if ("VAR".equalsIgnoreCase(paraType)) {
            if (pPara.getEncryptflag()) {
                return SecurityUtil.decryptStrToByte((String)paraValue);
            }
            byte[] stringByte = new byte[paraValue.getBytes().length];
            byte[] srcByte = TECharsetConverter.convertStringToByte(neid, paraValue);
            System.arraycopy(srcByte, 0, stringByte, 0, srcByte.length);
            return stringByte;
        }
        if ("prototype".equalsIgnoreCase(paraType)) {
            byte[] srcByte = IOStreamConvertor.getByteArrayFromString(paraValue);
            if (paraLength == 0) {
                paraLength = srcByte.length;
            }
            byte[] stringByte = new byte[paraLength];
            if (paraLength > srcByte.length) {
                paraLength = srcByte.length;
            }
            System.arraycopy(srcByte, 0, stringByte, 0, paraLength);
            return stringByte;
        }
        byte[] stringByte = new byte[paraLength];
        byte[] srcByte = pPara.getEncryptflag() ? SecurityUtil.decryptStrToByte((String)paraValue) : TECharsetConverter.convertStringToByte(neid, paraValue);
        if (paraLength > srcByte.length) {
            paraLength = srcByte.length;
        }
        System.arraycopy(srcByte, 0, stringByte, 0, paraLength);
        return stringByte;
    }

    @Override
    public int handleResponse(TEMessage rspResult, TEMessage rspSource, byte[] pData, boolean bLastFlag) {
        int i;
        if (!(rspResult instanceof TEQx5Message) || !(rspSource instanceof TEFunSrvObjectMessage)) {
            return -1;
        }
        TEQx5Message pResult = (TEQx5Message)rspResult;
        TEFunSrvObjectMessage pSource = (TEFunSrvObjectMessage)rspSource;
        pSource.setResult(pResult.getError());
        List<TEQx5Command> cmdList = pResult.getQx5CommandList();
        List<Operation> operationList = pSource.funInterfaceObject.operationList;
        if (operationList == null) {
            return 0;
        }
        log.info("convertOperationToQxCmd: " + cmdList);
        int size = cmdList.size();
        for (i = 0; i < size; ++i) {
            TEQx5Command qxCmd = cmdList.get(i);
            try {
                this.fillReturnData(pSource.funInterfaceObject.neID, operationList, qxCmd);
                continue;
            }
            catch (Exception ex) {
                log.error("fillReturnData() fail!", (Throwable)ex);
            }
        }
        size = operationList.size();
        for (i = 0; i < size; ++i) {
            Operation oper = operationList.get(i);
            if (oper.getOutputCount() == 0) {
                log.info("oper.getOutputCount(): " + oper.getCmdid());
                continue;
            }
            Output delOutput = oper.getOutput(0);
            oper.removeOutput(delOutput);
        }
        TETaskManager.instance().dispatchMessage(pSource);
        return 0;
    }

    private void fillReturnData(long neid, List<Operation> operList, TEQx5Command qxCmd) {
        int size = operList.size();
        for (int i = 0; i < size; ++i) {
            Operation oper = operList.get(i);
            if (oper.getCmdid() != qxCmd.getCommandKey() || oper.getCmdSerial() != qxCmd.getSerial()) continue;
            if (oper.getOutputCount() == 0) {
                log.info("outputCount is zero: " + qxCmd);
                return;
            }
            Output tmpOutPut = (Output)oper.getOutput(0).clone();
            int operResult = qxCmd.getExecResult();
            Fault operFault = tmpOutPut.getFault(0);
            operFault.setCode(String.valueOf(operResult));
            int cmdOffsetPosition = 2;
            int paraLen = tmpOutPut.getPartCount();
            for (int paraIndex = 0; paraIndex < paraLen; ++paraIndex) {
                byte[] intByte;
                String strValue;
                Part curPart = tmpOutPut.getPart(paraIndex);
                String paraType = curPart.getType();
                int len = curPart.getLength();
                boolean slotFlag = false;
                boolean neFlag = false;
                boolean subrackFlag = false;
                slotFlag = curPart.getSlotConvertFlag();
                neFlag = curPart.getNEConvertFlag();
                subrackFlag = curPart.getSubrackConvertFlag();
                if ("BYTE".equalsIgnoreCase(paraType)) {
                    byte[] byteValue = qxCmd.getByte(cmdOffsetPosition);
                    if (null == byteValue) break;
                    int value = IOStreamConvertor.readUnsignedByte(byteValue[0]);
                    if (slotFlag) {
                        value = this.slotIDNEToNM(value);
                    }
                    strValue = String.valueOf(value);
                } else if ("INT".equalsIgnoreCase(paraType)) {
                    int tempValue;
                    intByte = qxCmd.getWord(cmdOffsetPosition);
                    if (intByte == null) break;
                    int value = tempValue = IOStreamConvertor.readUnsignedShort(intByte, 0);
                    if (slotFlag) {
                        value = this.slotIDNEToNM(tempValue);
                    }
                    if (subrackFlag) {
                        value = this.subrackIDNEToNM(tempValue);
                    }
                    strValue = String.valueOf(value);
                } else if ("LONG".equalsIgnoreCase(paraType)) {
                    intByte = qxCmd.getDword(cmdOffsetPosition);
                    if (intByte == null) break;
                    long value = IOStreamConvertor.readUnsignedInt(intByte, 0);
                    if (neFlag && value > 0L) {
                        value = TENECommMgr.getInstance().getLogicNEID((int)value);
                    }
                    strValue = String.valueOf(value);
                } else if ("VAR".equalsIgnoreCase(paraType)) {
                    byte[] srcByte = qxCmd.getResultData(cmdOffsetPosition);
                    if (srcByte == null) break;
                    strValue = curPart.getEncryptflag() ? SecurityUtil.encryptByteToStr((byte[])srcByte) : TECharsetConverter.convertByteToString(neid, srcByte);
                } else if ("prototype".equalsIgnoreCase(paraType)) {
                    intByte = null;
                    intByte = 0 == len ? qxCmd.getResultData(cmdOffsetPosition) : qxCmd.getResultData(cmdOffsetPosition, len);
                    if (intByte == null) break;
                    strValue = IOStreamConvertor.hexChangToString(intByte);
                } else {
                    intByte = qxCmd.getResultData(cmdOffsetPosition, len);
                    if (intByte == null) break;
                    strValue = curPart.getEncryptflag() ? SecurityUtil.encryptByteToStr((byte[])intByte) : TECharsetConverter.convertByteToString(neid, intByte);
                }
                cmdOffsetPosition += len;
                curPart.setValue(strValue);
            }
            oper.addOutput(tmpOutPut);
            break;
        }
    }

    private void fillReportData(Operation oper, TEQx5Command qxCmd) {
        if (oper.getCmdid() == qxCmd.getCommandKey()) {
            Output tmpOutPut = (Output)oper.getOutput(0).clone();
            int cmdOffsetPosition = 0;
            int paraLen = tmpOutPut.getPartCount();
            for (int paraIndex = 0; paraIndex < paraLen; ++paraIndex) {
                byte[] intByte;
                String strValue;
                Part curPart = tmpOutPut.getPart(paraIndex);
                String paraType = curPart.getType();
                int len = curPart.getLength();
                boolean slotFlag = false;
                boolean neFlag = false;
                boolean subrackFlag = false;
                slotFlag = curPart.getSlotConvertFlag();
                neFlag = curPart.getNEConvertFlag();
                subrackFlag = curPart.getSubrackConvertFlag();
                if ("BYTE".equalsIgnoreCase(paraType)) {
                    byte[] byteValue = qxCmd.getByte(cmdOffsetPosition);
                    if (null == byteValue) break;
                    int value = IOStreamConvertor.readUnsignedByte(byteValue[0]);
                    if (slotFlag) {
                        value = this.slotIDNEToNM(value);
                    }
                    strValue = String.valueOf(value);
                } else if ("INT".equalsIgnoreCase(paraType)) {
                    int tempValue;
                    intByte = qxCmd.getWord(cmdOffsetPosition);
                    if (intByte == null) break;
                    int value = tempValue = IOStreamConvertor.readUnsignedShort(intByte, 0);
                    if (slotFlag) {
                        value = this.slotIDNEToNM(tempValue);
                    }
                    if (subrackFlag) {
                        value = this.subrackIDNEToNM(tempValue);
                    }
                    strValue = String.valueOf(value);
                } else if ("LONG".equalsIgnoreCase(paraType)) {
                    intByte = qxCmd.getDword(cmdOffsetPosition);
                    if (intByte == null) break;
                    long value = IOStreamConvertor.readUnsignedInt(intByte, 0);
                    if (neFlag && value > 0L) {
                        value = TENECommMgr.getInstance().getLogicNEID((int)value);
                    }
                    strValue = String.valueOf(value);
                } else if ("VAR".equalsIgnoreCase(paraType)) {
                    intByte = qxCmd.getResultData(cmdOffsetPosition);
                    if (intByte == null) break;
                    strValue = curPart.getEncryptflag() ? SecurityUtil.encryptByteToStr((byte[])intByte) : new String(intByte);
                } else if ("prototype".equalsIgnoreCase(paraType)) {
                    intByte = null;
                    intByte = 0 == len ? qxCmd.getResultData(cmdOffsetPosition) : qxCmd.getResultData(cmdOffsetPosition, len);
                    if (intByte == null) break;
                    strValue = IOStreamConvertor.hexChangToString(intByte);
                } else {
                    intByte = qxCmd.getResultData(cmdOffsetPosition, len);
                    if (intByte == null) break;
                    strValue = curPart.getEncryptflag() ? SecurityUtil.encryptByteToStr((byte[])intByte) : new String(intByte);
                }
                cmdOffsetPosition += len;
                curPart.setValue(strValue);
            }
            oper.addOutput(tmpOutPut);
            Output tmpOutput = oper.getOutput(0);
            oper.removeOutput(tmpOutput);
        }
    }

    @Override
    public int handleReportCommand(long neId, TECommand cmd) {
        if (!(cmd instanceof TEQx5Command)) {
            return -1;
        }
        TEQx5Command qxCmd = (TEQx5Command)cmd;
        int cmdKey = qxCmd.getCommandKey();
        Operation oper = TETaskManager.instance().getReportOperation(cmdKey);
        this.fillReportData(oper, qxCmd);
        log.info("enter report command: neid = " + neId + ", cmd = " + cmdKey);
        TETaskManager.instance().dispatchReportListener(neId, oper);
        log.info("exit report command: neid = " + neId + ", cmd = " + cmdKey);
        return 0;
    }

    @Override
    public int handleReportCommand(long neID, List pCmdList) {
        int size = pCmdList.size();
        for (int i = 0; i < size; ++i) {
            if (!(pCmdList.get(i) instanceof TEQx5Command)) continue;
            TEQx5Command cmd = (TEQx5Command)pCmdList.get(i);
            this.handleReportCommand(neID, cmd);
        }
        return 0;
    }

    @Override
    public int registerMessage(TEMessage pSource, TEMessage pSink) {
        TEQx5Message pMessage = (TEQx5Message)pSink;
        List<TEQx5Command> pCmdList = pMessage.getQx5CommandList();
        if (pCmdList.isEmpty()) {
            log.info("RegisterMessage: Qx5 msg has no command! ");
            return 0;
        }
        int size = pCmdList.size();
        for (int i = 0; i < size; ++i) {
            TEQx5Command qx5Cmd = pCmdList.get(i);
            TEMessageUnit msgSrcUnit = new TEMessageUnit(pSource.getMessageSerial(), pSource.protocolInstance().getType());
            TEMessageUnit msgSinkUnit = new TEMessageUnit(qx5Cmd.getSerial(), 3);
            TEMessageInfo msgInfo = TEAdapterManager.instance().findSrcMsgInfo(msgSrcUnit);
            if (msgInfo == null) {
                log.info("msgSrcUnit: " + msgSrcUnit.ulMessageSerial + ", Type: " + pSource.protocolInstance().getType() + "qx5Cmd: " + qx5Cmd.getCommandKey());
                log.info("Register null message adatper! qx5Cmd\u00a3\u00ba " + qx5Cmd.getCommandKey());
                msgInfo = new TEMessageInfo();
                msgInfo.pSrcMessage = pSource;
                msgInfo.addSinkMessage(msgSinkUnit);
                TEAdapterManager.instance().insertToInfoMap(msgSrcUnit, msgInfo);
            } else {
                msgInfo.addSinkMessage(msgSinkUnit);
            }
            TEAdapterManager.instance().insertToUnitMap(msgSinkUnit, msgSrcUnit);
        }
        return 0;
    }

    public TEProtocolAdapter srcProtocolInstance() {
        return this.m_pSrcProtocol;
    }

    public TEProtocolAdapter sinkProtocolInstance() {
        return this.m_pSinkProtocol;
    }

    public boolean isVersionSupport(TEFunSrvObjectMessage srvObjectMessage) {
        return true;
    }

    private int slotIDNEToNM(int slotID) {
        int slot = slotID & 0x1F;
        int shelfID = slotID & 0xE0;
        return slot += (shelfID >>>= 5) * 65536;
    }

    private int slotIDNMToNE(int slotID) {
        int shelfID = slotID / 65536;
        int slot = slotID % 65536;
        slot = (shelfID <<= 5) + slot;
        return slot;
    }

    private int subrackIDNEToNM(int slotID) {
        int slot = slotID & 0xFF;
        int shelfID = slotID & 0xFF00;
        return slot += (shelfID >>>= 8) * 65536;
    }

    private int subrackIDNMToNE(int slotID) {
        int shelfID = slotID / 65536;
        int slot = slotID % 65536;
        slot = (shelfID <<= 8) + slot;
        return slot;
    }
}

