/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.qxprotocol;

import com.huawei.uflight.qxprotocol.TENECommMgr;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import org.slf4j.LoggerFactory;

public final class TECharsetConverter {
    private static final String CHARSET_GBK = "GBK";
    private static final String CHARSET_ISO8859 = "ISO-8859-1";
    private static final String CHARSET_UTF8 = "UTF-8";

    private TECharsetConverter() {
    }

    public static byte[] convertStringToByte(long logicNEID, String s) throws CharacterCodingException {
        String charsetName = TECharsetConverter.getNeCharsetName(logicNEID);
        String str = s;
        if (charsetName.equals(CHARSET_GBK)) {
            CharsetDecoder gbk_decoder = Charset.forName(CHARSET_GBK).newDecoder();
            CharsetEncoder gbk_encoder = Charset.forName(CHARSET_GBK).newEncoder();
            str = gbk_decoder.decode(gbk_encoder.encode(CharBuffer.wrap(s))).toString();
        } else if (charsetName.equals(CHARSET_ISO8859) && !Charset.forName(charsetName).newEncoder().canEncode(str)) {
            LoggerFactory.getLogger(TECharsetConverter.class).error("CharsetConverter String = " + str + " don't support " + charsetName);
            throw new CharacterCodingException();
        }
        return str.getBytes(Charset.forName(charsetName));
    }

    public static String convertByteToString(long logicNEID, byte[] byteArr) {
        String charsetName = TECharsetConverter.getNeCharsetName(logicNEID);
        CharsetDecoder unicode_decoder = Charset.forName(CHARSET_UTF8).newDecoder();
        CharsetEncoder unicode_encoder = Charset.forName(CHARSET_UTF8).newEncoder();
        String str = null;
        try {
            if (charsetName.equals(CHARSET_GBK)) {
                str = new String(byteArr, Charset.forName(CHARSET_GBK));
                str = unicode_decoder.decode(unicode_encoder.encode(CharBuffer.wrap(str))).toString();
            } else if (charsetName.equals(CHARSET_ISO8859)) {
                str = new String(byteArr, Charset.forName(CHARSET_ISO8859));
                str = unicode_decoder.decode(unicode_encoder.encode(CharBuffer.wrap(str))).toString();
            } else {
                str = new String(byteArr, Charset.forName(CHARSET_UTF8));
            }
        }
        catch (Exception e) {
            LoggerFactory.getLogger(TECharsetConverter.class).error("convertByteToString() fail!", (Throwable)e);
        }
        return str;
    }

    private static String getNeCharsetName(long logicNEID) {
        String charset = TENECommMgr.getInstance().getNECharset(logicNEID);
        if (null == charset) {
            charset = CHARSET_UTF8;
        }
        LoggerFactory.getLogger(TECharsetConverter.class).debug("getNeCharsetName(neid=" + logicNEID + ",logicNEID=" + logicNEID + ")=" + charset);
        return charset;
    }
}

