/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.qxprotocol;

import com.huawei.uflight.necomm.IOStreamConvertor;
import com.huawei.uflight.necomm.TECommInfo;
import com.huawei.uflight.necomm.TEInputDataReceiver;
import com.huawei.uflight.qxprotocol.IMessageValidater;
import com.huawei.uflight.qxprotocol.TEFunSrvDataQx5MessageAdapter;
import com.huawei.uflight.qxprotocol.TEMessage;
import com.huawei.uflight.qxprotocol.TEMessageAdapter;
import com.huawei.uflight.qxprotocol.TEMessageInfo;
import com.huawei.uflight.qxprotocol.TEMessageUnit;
import com.huawei.uflight.qxprotocol.TEProtocolAdapter;
import com.huawei.uflight.qxprotocol.qx5adapter.TEQxCommuMgr;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.LoggerFactory;

public final class TEAdapterManager
implements TEInputDataReceiver {
    private static TEAdapterManager m_pInstance = null;
    List protocolList = new ArrayList();
    Map messageMap = new HashMap();
    Map srcMessageInfoMap = new HashMap();
    private List<IMessageValidater> validaters = new ArrayList<IMessageValidater>();
    Timer pMessageTimer = null;
    TimerTask messageTimerTask = new TimerTask(){

        @Override
        public void run() {
            TEAdapterManager.this.handleTimeOut();
        }
    };

    private TEAdapterManager() {
        this.init();
    }

    public void init() {
        this.pMessageTimer = new Timer();
        this.pMessageTimer.schedule(this.messageTimerTask, 5000L, 5000L);
    }

    public static synchronized TEAdapterManager instance() {
        if (null == m_pInstance) {
            m_pInstance = new TEAdapterManager();
        }
        return m_pInstance;
    }

    public void addProtocolAdapter(TEProtocolAdapter pProtocolAdapter) {
        if (null != pProtocolAdapter) {
            this.protocolList.add(pProtocolAdapter);
        }
    }

    public synchronized void registerMessageValidater(IMessageValidater validater) {
        if (null == validater) {
            throw new IllegalArgumentException("validater can not be null");
        }
        this.validaters.add(validater);
    }

    public synchronized void unregisterMessageValidater(IMessageValidater validater) {
        if (null == validater) {
            throw new IllegalArgumentException("validater can not be null");
        }
        this.validaters.remove(validater);
    }

    public synchronized int registerPrivateMessage(TEMessage pSource, TEMessageAdapter pMsgAdapter, byte[] pUserData, int nTimeOut) {
        TEMessageUnit msgSrcUnit = new TEMessageUnit(pSource.getMessageSerial(), pSource.protocolInstance().getType());
        TEMessageInfo msgInfo = new TEMessageInfo(pSource, pMsgAdapter, null, nTimeOut);
        TEMessageInfo iter = (TEMessageInfo)this.srcMessageInfoMap.get(msgSrcUnit);
        if (iter != null) {
            if (null != pUserData) {
                iter.setUserData(pUserData);
            }
            return 0;
        }
        msgInfo.pSrcMessage = pSource;
        msgInfo.pData = pUserData;
        this.srcMessageInfoMap.put(msgSrcUnit, msgInfo);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int registerMessage(TEMessage pSource, TEMessage pSink) {
        TEMessageUnit msgSrcUnit = new TEMessageUnit(pSource.getMessageSerial(), pSource.protocolInstance().getType());
        TEMessageUnit msgSinkUnit = new TEMessageUnit(pSink.getMessageSerial(), pSink.protocolInstance().getType());
        TEAdapterManager tEAdapterManager = this;
        synchronized (tEAdapterManager) {
            TEMessageInfo iter = (TEMessageInfo)this.srcMessageInfoMap.get(msgSrcUnit);
            if (iter == null) {
                LoggerFactory.getLogger(this.getClass()).info("Register null message adatper!");
                TEMessageInfo msgInfo = new TEMessageInfo();
                msgInfo.pSrcMessage = pSource;
                msgInfo.sinkMessageList.add(msgSinkUnit);
                this.srcMessageInfoMap.put(msgSrcUnit, msgInfo);
            } else {
                iter.addSinkMessage(msgSinkUnit);
            }
            this.messageMap.put(msgSinkUnit, msgSrcUnit);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int unRegisterSourceMessage(TEMessage pSource) {
        TEMessageUnit msgSrcUnit = new TEMessageUnit(pSource.getMessageSerial(), pSource.protocolInstance().getType());
        TEAdapterManager tEAdapterManager = this;
        synchronized (tEAdapterManager) {
            TEMessageInfo map_iter = (TEMessageInfo)this.srcMessageInfoMap.get(msgSrcUnit);
            if (map_iter == null) {
                LoggerFactory.getLogger(this.getClass()).info("TEAdapterManager::UnRegisterSourceMessage, not found source message in map.\n");
                return 0;
            }
            int size = map_iter.sinkMessageList.size();
            for (int i = 0; i < size; ++i) {
                TEMessageUnit messageUnitSink = (TEMessageUnit)map_iter.sinkMessageList.get(i);
                TEMessageUnit msgIter = (TEMessageUnit)this.messageMap.get(messageUnitSink);
                this.messageMap.remove(msgIter);
            }
            this.srcMessageInfoMap.remove(msgSrcUnit);
            LoggerFactory.getLogger(this.getClass()).info("unRegister serial: " + msgSrcUnit.ulMessageSerial);
        }
        return 0;
    }

    public synchronized int unRegisterSinkMessage(TEMessage pSinkMsg) {
        TEMessageUnit msgSinkUnit = new TEMessageUnit(pSinkMsg.getMessageSerial(), pSinkMsg.protocolInstance().getType());
        TEMessageUnit msgIter = (TEMessageUnit)this.messageMap.get(msgSinkUnit);
        if (msgIter == null) {
            LoggerFactory.getLogger(this.getClass()).info("TEAdapterManager::UnRegisterSinkMessage, not found sink message in map table.\n");
            return 0;
        }
        TEMessageInfo infoIter = (TEMessageInfo)this.srcMessageInfoMap.get(msgIter);
        if (infoIter != null) {
            infoIter.deleteSinkMessage(msgSinkUnit);
        } else {
            LoggerFactory.getLogger(this.getClass()).info("TEAdapterManager::UnRegisterSinkMessage, not found sink message in source.\n");
        }
        this.messageMap.remove(msgSinkUnit);
        return 0;
    }

    public synchronized TEMessageUnit findSrcMsgUnit(TEMessageUnit sinkMsgUnit) {
        TEMessageUnit unitIt = (TEMessageUnit)this.messageMap.get(sinkMsgUnit);
        return unitIt;
    }

    public synchronized TEMessageInfo findSrcMsgInfo(TEMessageUnit srcMsgUnit) {
        TEMessageInfo infoIt = (TEMessageInfo)this.srcMessageInfoMap.get(srcMsgUnit);
        return infoIt;
    }

    public synchronized void eraseFromUnitMap(TEMessageUnit unitIt) {
        this.messageMap.remove(unitIt);
    }

    public synchronized void eraseFromInfoMap(TEMessageUnit infoIt) {
        this.srcMessageInfoMap.remove(infoIt);
    }

    public synchronized void insertToInfoMap(TEMessageUnit unit, TEMessageInfo info) {
        this.srcMessageInfoMap.put(unit, info);
    }

    public synchronized void insertToUnitMap(TEMessageUnit key, TEMessageUnit value) {
        this.messageMap.put(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTimeOut() {
        TEAdapterManager tEAdapterManager = this;
        synchronized (tEAdapterManager) {
            HashMap messageInfoMap = (HashMap)((HashMap)this.srcMessageInfoMap).clone();
            Set entries = messageInfoMap.entrySet();
            for (Map.Entry entry : entries) {
                TEMessageInfo info = (TEMessageInfo)entry.getValue();
                TEMessageUnit srcUnit = (TEMessageUnit)entry.getKey();
                TEMessage pSrcMessage = info.pSrcMessage;
                if (null == pSrcMessage) {
                    LoggerFactory.getLogger(this.getClass()).info("TEAdapterManager HandleTimeOut: Warning, Pointer is NULL! \n ");
                    continue;
                }
                if (info.iTimeOut < 0) {
                    LoggerFactory.getLogger(this.getClass()).info("TEAdapterManager HandleTimeOut: Del msg.");
                    int size = info.sinkMessageList.size();
                    for (int i = 0; i < size; ++i) {
                        TEMessageUnit msgUnit = (TEMessageUnit)info.sinkMessageList.get(i);
                        this.messageMap.remove(msgUnit);
                    }
                    TEMessageAdapter pMessageAdapter = info.pMessageAdapter;
                    byte[] pUserData = info.pData;
                    this.srcMessageInfoMap.remove(srcUnit);
                    if (pMessageAdapter == null) {
                        LoggerFactory.getLogger(this.getClass()).info("handle timeout Remove serial: " + srcUnit.ulMessageSerial);
                        pMessageAdapter = TEFunSrvDataQx5MessageAdapter.instance();
                    }
                    pMessageAdapter.handleAsyncError(pSrcMessage, pUserData, 1);
                }
                info.iTimeOut -= 5;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int checkMessageValid(byte[] data, int offset, int size, TECommInfo commInfo) {
        List<IMessageValidater> list = this.validaters;
        synchronized (list) {
            for (IMessageValidater validater : this.validaters) {
                try {
                    int count = validater.checkMessageValid(data, offset, size, commInfo);
                    if (count <= 0) continue;
                    LoggerFactory.getLogger(this.getClass()).info("Message valid for " + validater + ",receive count is " + count);
                    return count;
                }
                catch (Exception ex) {
                    LoggerFactory.getLogger(this.getClass()).error("Exception occured while check message ,validater = " + validater.getClass().getName(), (Throwable)ex);
                }
            }
        }
        int count = 0;
        count = TEQxCommuMgr.instance().checkMessageValid(data, offset, size);
        if (count >= 0) {
            return count;
        }
        if (count == -3 || count == -2) {
            LoggerFactory.getLogger(this.getClass()).info("TEAdapterManager :Message valid for protocol, but data not enough!  Attention!!!! " + count);
            return -2;
        }
        LoggerFactory.getLogger(this.getClass()).info("TEAdapterManager: Message not valid for protocol!  Attention  " + count);
        return -1;
    }

    @Override
    public int getMaxPacketLength() {
        return 934;
    }

    @Override
    public int getHeadLength() {
        return 16;
    }

    @Override
    public int getFrameLength(byte[] buffer) {
        return IOStreamConvertor.readUnsignedShort(buffer, 10);
    }

    public static void main(String[] args) {
        m_pInstance = TEAdapterManager.instance();
        byte[] bufVec = new byte[]{-127, 9, 16, 18, -1, -1, -1, -1, 2, 0, 3, 0, 0, 0, 0, 4, 3, 3, 3};
        m_pInstance.checkMessageValid(bufVec, 0, bufVec.length, null);
    }
}

