/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.necomm.ssl.util;

public final class CipherMapping {
    private static final String[] mediumCiphers = new String[]{"SSL_RSA_WITH_RC4_128_MD5", "SSL_RSA_WITH_RC4_128_SHA", "TLS_RSA_WITH_AES_128_CBC_SHA", "TLS_DHE_RSA_WITH_AES_128_CBC_SHA", "TLS_DHE_DSS_WITH_AES_128_CBC_SHA", "SSL_DH_anon_WITH_RC4_128_MD5", "TLS_DH_anon_WITH_AES_128_CBC_SHA"};
    private static final String[] highCiphers = new String[]{"SSL_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA", "SSL_DH_anon_WITH_3DES_EDE_CBC_SHA"};
    private static final String[] lowCiphers = new String[]{"SSL_RSA_WITH_DES_CBC_SHA", "SSL_DHE_RSA_WITH_DES_CBC_SHA", "SSL_DHE_DSS_WITH_DES_CBC_SHA", "SSL_DH_anon_WITH_DES_CBC_SHA", "SSL_RSA_EXPORT_WITH_RC4_40_MD5", "SSL_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA", "SSL_RSA_WITH_NULL_MD5", "SSL_DH_anon_EXPORT_WITH_RC4_40_MD5", "SSL_DH_anon_EXPORT_WITH_DES40_CBC_SHA"};

    private CipherMapping() {
    }

    public static String[] getCipherList(String level) {
        if ("low".equals(level)) {
            return lowCiphers;
        }
        if ("medium".equals(level)) {
            return mediumCiphers;
        }
        if ("high".equals(level)) {
            return highCiphers;
        }
        String[] all = CipherMapping.getSupportedCipherSuites();
        return all;
    }

    private static String[] getSupportedCipherSuites() {
        int lows = lowCiphers.length;
        int mediums = mediumCiphers.length;
        int highs = highCiphers.length;
        String[] all = new String[lows + mediums + highs];
        System.arraycopy(lowCiphers, 0, all, 0, lows);
        System.arraycopy(mediumCiphers, 0, all, lows, mediums);
        System.arraycopy(highCiphers, 0, all, mediums, highs);
        return all;
    }
}

