/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.necomm.ssl;

import com.huawei.uflight.necomm.ssl.KeyMaterial;
import com.huawei.uflight.necomm.ssl.NoSuchProtocolVersionException;
import com.huawei.uflight.necomm.ssl.NoTrustCertException;
import com.huawei.uflight.necomm.ssl.SSLSocketFactoryCustomized;
import com.huawei.uflight.necomm.ssl.TrustMaterial;
import com.huawei.uflight.necomm.ssl.TrustStoreException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class SSL {
    private KeyMaterial theKeyMaterial;
    private TrustMaterial theTrustMaterial;
    private String enabledProtocolVersion = "TLSv1";
    private boolean bAuthPeer = true;
    private String[] enabledCipherSuites = null;
    private static List supportedCipherSuites = null;

    public SSL() {
        this.setEnabledProtocolVersion(this.enabledProtocolVersion);
        this.theTrustMaterial = new TrustMaterial();
        SSLSocketFactory sf = (SSLSocketFactory)SSLSocketFactory.getDefault();
        String[] cs = sf.getSupportedCipherSuites();
        supportedCipherSuites = Arrays.asList(cs);
        this.enabledCipherSuites = cs;
    }

    public void setAuthPeer(boolean authPeer) {
        this.bAuthPeer = authPeer;
    }

    public boolean authPeer() {
        return this.bAuthPeer;
    }

    public String[] setEnabledCipherSuites(String[] cipherSuites) {
        if (cipherSuites == null || cipherSuites.length == 0) {
            this.enabledCipherSuites = supportedCipherSuites.toArray(new String[supportedCipherSuites.size()]);
            return this.enabledCipherSuites;
        }
        int len = cipherSuites.length;
        ArrayList<String> enabled = new ArrayList<String>(len);
        for (int i = 0; i < len; ++i) {
            if (!supportedCipherSuites.contains(cipherSuites[i])) continue;
            enabled.add(cipherSuites[i]);
        }
        this.enabledCipherSuites = enabled.isEmpty() ? supportedCipherSuites.toArray(new String[supportedCipherSuites.size()]) : enabled.toArray(new String[enabled.size()]);
        return this.enabledCipherSuites;
    }

    public String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    public String setEnabledProtocolVersion(String protocolVersion) {
        this.enabledProtocolVersion = protocolVersion.indexOf("SSLv2") != -1 ? "SSLv3" : (protocolVersion.indexOf("TLSv1") != -1 ? "TLSv1" : protocolVersion);
        return this.enabledProtocolVersion;
    }

    public String getEnabledProtocolVersion() {
        return this.enabledProtocolVersion;
    }

    public void addKeyMaterial(KeyMaterial keyMaterial) {
        this.theKeyMaterial = keyMaterial;
    }

    public void addTrustMaterial(TrustMaterial trustMaterial) {
        if (trustMaterial != null) {
            this.theTrustMaterial = trustMaterial;
        }
    }

    public SocketFactory createSocketFactory() throws NoSuchProtocolVersionException, KeyStoreException, UnrecoverableKeyException, KeyManagementException, TrustStoreException, NoTrustCertException {
        SSLContext sslContext = this.createSSLContext();
        SocketFactory factory = this.getSocketFactory(sslContext);
        return factory;
    }

    public SSLContext createSSLContext() throws NoSuchProtocolVersionException, TrustStoreException, KeyStoreException, UnrecoverableKeyException, KeyManagementException {
        KeyManager[] kms;
        TrustManager[] tms;
        SSLContext sslContext = null;
        try {
            sslContext = SSLContext.getInstance(this.getEnabledProtocolVersion());
        }
        catch (NoSuchAlgorithmException nsaex) {
            throw new NoSuchProtocolVersionException(this.getEnabledProtocolVersion(), nsaex);
        }
        this.theTrustMaterial.setAuthPeer(this.bAuthPeer);
        try {
            tms = this.theTrustMaterial.getTrustManagers();
        }
        catch (Exception ex) {
            throw new TrustStoreException("Incorrect certificates while authorizing peer required.", ex);
        }
        if (this.theKeyMaterial == null) {
            kms = null;
        } else {
            try {
                kms = this.theKeyMaterial.getKeyManagers();
            }
            catch (NoSuchAlgorithmException nsaex) {
                KeyStoreException ex = new KeyStoreException("KeyManager can not parse the KeyStore: " + nsaex.toString());
                ex.initCause(nsaex);
                throw ex;
            }
        }
        sslContext.init(kms, tms, null);
        return sslContext;
    }

    private SocketFactory getSocketFactory(SSLContext context) {
        SSLSocketFactory factory = context.getSocketFactory();
        SSLSocketFactoryCustomized factoryCustomized = new SSLSocketFactoryCustomized(factory);
        factoryCustomized.setEnabledCipherSuite(this.getEnabledCipherSuites());
        factoryCustomized.setEnabledProtocols(new String[]{this.getEnabledProtocolVersion()});
        return factoryCustomized;
    }
}

