/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.necomm.ssl;

import com.huawei.uflight.necomm.ssl.util.AreaDescContainer;
import com.huawei.uflight.necomm.ssl.util.CommStyleInfo;
import com.huawei.uflight.necomm.ssl.util.CommStyleManager;
import com.huawei.uflight.necomm.ssl.util.DescContainer;
import org.slf4j.LoggerFactory;

public class Option {
    private String version = "TLSv1";
    private String encryptLevel = "medium";
    private boolean enableAuthPeer = false;
    private boolean enableSSL = true;
    private boolean enableSessionReuse = true;
    private int sessionTimeout = 300;
    private boolean enableSSLPortAutoAdapt = false;
    private CommStyleInfo optionCommStyle = null;
    private DescContainer options = null;

    public Option() {
    }

    public Option(String optionFile) {
        this.readOption(optionFile);
    }

    private boolean readOption(String optionFile) {
        this.optionCommStyle = CommStyleManager.getInstance().getAbsCommStyleFile(optionFile);
        if (this.optionCommStyle == null) {
            return false;
        }
        AreaDescContainer ssl = this.optionCommStyle.getAreaDescContainer("ssl");
        this.options = ssl.getDescContainer("options");
        if (this.options == null) {
            return false;
        }
        try {
            this.enableSSL = Boolean.valueOf(this.options.getParasItemValue("enableSSL"));
            this.version = this.options.getParasItemValue("version");
            this.encryptLevel = this.options.getParasItemValue("encryptLevel");
            this.enableAuthPeer = Boolean.valueOf(this.options.getParasItemValue("enableAuthPeer"));
            this.enableSessionReuse = Boolean.valueOf(this.options.getParasItemValue("enableSessionReuse"));
            this.sessionTimeout = Integer.valueOf(this.options.getParasItemValue("sessionTimeout"));
            this.enableSSLPortAutoAdapt = Boolean.valueOf(this.options.getParasItemValue("enableSSLPortAutoAdapt"));
        }
        catch (NumberFormatException e) {
            LoggerFactory.getLogger(Option.class).error("readOption() error.", (Throwable)e);
            return false;
        }
        return true;
    }

    public String getVersion() {
        return this.version;
    }

    public String getEncryptLevel() {
        return this.encryptLevel;
    }

    public boolean isEnableAuthPeer() {
        return this.enableAuthPeer;
    }

    public boolean isEnableSSL() {
        return this.enableSSL;
    }

    public boolean isEnableSessionReuse() {
        return this.enableSessionReuse;
    }

    public int getSessionTimeout() {
        return this.sessionTimeout;
    }

    public boolean isEnableSSLPortAutoAdapt() {
        return this.enableSSLPortAutoAdapt;
    }
}

