/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.necomm;

import com.huawei.uflight.necomm.TECommData;
import com.huawei.uflight.necomm.TECommUtils;
import com.huawei.uflight.necomm.TEUDPCommInfo;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TEUDPHandler {
    private int commType = 0;
    private InetAddress bindAddr = null;
    private int bindPort = -1;
    private NetworkInterface netInf = null;
    private DatagramSocket socket = null;
    private volatile int connectState = -1;
    private int bufSize = 65536;
    private String name = null;
    private static Logger logger = LoggerFactory.getLogger(TEUDPHandler.class);

    TEUDPHandler() {
    }

    public int open(TEUDPCommInfo info, int bSize) {
        this.bufSize = bSize;
        return this.open(info);
    }

    public int open(TEUDPCommInfo info) {
        this.connectState = -1;
        if (null == info) {
            logger.error("UDPCommInfo is null, open failed!");
            return -1;
        }
        this.bindPort = info.getBindPort();
        this.commType = info.getCommType();
        if (2 == this.commType) {
            this.connectState = this.openMulticast(info);
        } else if (1 == this.commType || 0 == this.commType) {
            this.connectState = this.openBroadAndUnicast();
        } else {
            logger.error("invalid commType = " + this.commType + ", open failed!");
            this.connectState = -1;
        }
        return this.connectState;
    }

    private int openMulticast(TEUDPCommInfo info) {
        this.name = "UDP_Multicast[" + info.getBindAddr() + ":" + this.bindPort + "," + info.getNetInfAddr() + "]";
        try {
            if (info.getBindAddr() != null) {
                this.bindAddr = InetAddress.getByName(info.getBindAddr());
                if (!this.bindAddr.isMulticastAddress()) {
                    logger.error(this.name + " open() failed: bindAddr " + this.bindAddr + " is not a multicast address.");
                    return -1;
                }
            }
            if (info.getNetInfAddr() != null) {
                InetAddress localAddr = InetAddress.getByName(info.getNetInfAddr());
                this.netInf = NetworkInterface.getByInetAddress(localAddr);
            }
        }
        catch (Exception e) {
            logger.error(this.name + " open() failed:", (Throwable)e);
            return -1;
        }
        MulticastSocket mSocket = null;
        try {
            mSocket = this.bindPort > 0 ? new MulticastSocket(this.bindPort) : new MulticastSocket();
            this.socket = mSocket;
        }
        catch (Exception e) {
            logger.error(this.name + " open():", (Throwable)e);
            return -1;
        }
        try {
            if (null != this.netInf) {
                mSocket.setNetworkInterface(this.netInf);
            }
            if (null != this.bindAddr) {
                mSocket.joinGroup(this.bindAddr);
            }
            mSocket.setTimeToLive(16);
            this.socket.setSoTimeout(TECommUtils.parseString2Int(TECommUtils.getSysProperty("UDPSoTimeout"), 30000));
        }
        catch (Exception e) {
            this.connectState = 1;
            logger.error(this.name + " open():", (Throwable)e);
            return 1;
        }
        logger.info(this.name + " open(): OK!");
        return 0;
    }

    private int openBroadAndUnicast() {
        this.name = 0 == this.commType ? "UDP_Unicast[" + this.bindPort + "]" : "UDP_Broadcast[" + this.bindPort + "]";
        try {
            this.socket = this.bindPort > 0 ? new DatagramSocket(this.bindPort) : new DatagramSocket();
            this.socket.setBroadcast(1 == this.commType);
            this.socket.setSoTimeout(TECommUtils.parseString2Int(TECommUtils.getSysProperty("UDPSoTimeout"), 30000));
        }
        catch (SocketException ex) {
            logger.error(this.name + " open() failed:", (Throwable)ex);
            return -1;
        }
        catch (Exception ex) {
            this.connectState = 1;
            logger.error(this.name + " open():", (Throwable)ex);
            return 1;
        }
        logger.info(this.name + " open(): OK!");
        return 0;
    }

    public int close() {
        if (null == this.socket) {
            logger.info(this.name + " has been closed.");
            return 0;
        }
        if (2 == this.commType) {
            try {
                ((MulticastSocket)this.socket).leaveGroup(this.bindAddr);
            }
            catch (IOException ie) {
                logger.error(this.name + " close():", (Throwable)ie);
            }
        }
        this.connectState = -1;
        this.socket.close();
        this.socket = null;
        logger.info(this.name + " close(): OK!");
        return 0;
    }

    public int send(TECommData data) {
        if (null == this.socket) {
            logger.error(this.name + " is closed, send failed: " + data);
            return -1;
        }
        DatagramPacket packet = new DatagramPacket(data.getData(), 0, data.getData().length);
        try {
            packet.setAddress(InetAddress.getByName(data.getAddr()));
            packet.setPort(data.getPort());
            this.socket.send(packet);
        }
        catch (IOException ex) {
            logger.error(this.name + " send():", (Throwable)ex);
            return -1;
        }
        return data.getData().length;
    }

    public TECommData recv() {
        if (null == this.socket) {
            logger.error(this.name + " is closed, recv failed.");
            return null;
        }
        TECommData data = null;
        byte[] b = new byte[this.bufSize];
        DatagramPacket packet = new DatagramPacket(b, this.bufSize);
        try {
            this.socket.receive(packet);
            data = new TECommData();
            data.setData(b);
            data.setLength(packet.getLength());
            data.setAddr(packet.getAddress().getHostAddress());
            data.setPort(packet.getPort());
        }
        catch (SocketTimeoutException ste) {
            logger.error(this.name + " received no data, recv() timed out, return null.");
            return null;
        }
        catch (IOException ex) {
            if (this.connectState != -1) {
                logger.error(this.name + " recv():", (Throwable)ex);
            }
            return null;
        }
        return data;
    }

    int getConnectState() {
        return this.connectState;
    }

    public String toString() {
        return this.name;
    }
}

